/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.window;

import org.apache.iotdb.db.queryengine.execution.aggregation.timerangeiterator.ITimeRangeIterator;
import org.apache.iotdb.db.queryengine.execution.operator.window.ConditionWindowManager;
import org.apache.iotdb.db.queryengine.execution.operator.window.ConditionWindowParameter;
import org.apache.iotdb.db.queryengine.execution.operator.window.CountWindowManager;
import org.apache.iotdb.db.queryengine.execution.operator.window.CountWindowParameter;
import org.apache.iotdb.db.queryengine.execution.operator.window.EqualBinaryWindowManager;
import org.apache.iotdb.db.queryengine.execution.operator.window.EqualBooleanWindowManager;
import org.apache.iotdb.db.queryengine.execution.operator.window.EqualDoubleWindowManager;
import org.apache.iotdb.db.queryengine.execution.operator.window.EqualFloatWindowManager;
import org.apache.iotdb.db.queryengine.execution.operator.window.EqualIntWindowManager;
import org.apache.iotdb.db.queryengine.execution.operator.window.EqualLongWindowManager;
import org.apache.iotdb.db.queryengine.execution.operator.window.IWindowManager;
import org.apache.iotdb.db.queryengine.execution.operator.window.SessionWindowManager;
import org.apache.iotdb.db.queryengine.execution.operator.window.SessionWindowParameter;
import org.apache.iotdb.db.queryengine.execution.operator.window.TimeWindowManager;
import org.apache.iotdb.db.queryengine.execution.operator.window.TimeWindowParameter;
import org.apache.iotdb.db.queryengine.execution.operator.window.VariationDoubleWindowManager;
import org.apache.iotdb.db.queryengine.execution.operator.window.VariationFloatWindowManager;
import org.apache.iotdb.db.queryengine.execution.operator.window.VariationIntWindowManager;
import org.apache.iotdb.db.queryengine.execution.operator.window.VariationLongWindowManager;
import org.apache.iotdb.db.queryengine.execution.operator.window.VariationWindowManager;
import org.apache.iotdb.db.queryengine.execution.operator.window.VariationWindowParameter;
import org.apache.iotdb.db.queryengine.execution.operator.window.WindowParameter;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class WindowManagerFactory {
    private WindowManagerFactory() {
    }

    public static IWindowManager genWindowManager(WindowParameter windowParameter, ITimeRangeIterator timeRangeIterator, boolean ascending) {
        switch (windowParameter.getWindowType()) {
            case TIME_WINDOW: {
                return new TimeWindowManager(timeRangeIterator, (TimeWindowParameter)windowParameter);
            }
            case VARIATION_WINDOW: {
                return ((VariationWindowParameter)windowParameter).getDelta() == 0.0 ? WindowManagerFactory.genEqualEventWindowManager((VariationWindowParameter)windowParameter, ascending) : WindowManagerFactory.genVariationEventWindowManager((VariationWindowParameter)windowParameter, ascending);
            }
            case CONDITION_WINDOW: {
                return new ConditionWindowManager((ConditionWindowParameter)windowParameter);
            }
            case SESSION_WINDOW: {
                return new SessionWindowManager(windowParameter.isNeedOutputEndTime(), ((SessionWindowParameter)windowParameter).getTimeInterval(), ascending);
            }
            case COUNT_WINDOW: {
                return new CountWindowManager((CountWindowParameter)windowParameter);
            }
        }
        throw new IllegalArgumentException("Not support this type of aggregation window :" + windowParameter.getWindowType().name());
    }

    private static VariationWindowManager genEqualEventWindowManager(VariationWindowParameter eventWindowParameter, boolean ascending) {
        switch (eventWindowParameter.getDataType()) {
            case INT32: {
                return new EqualIntWindowManager(eventWindowParameter, ascending);
            }
            case INT64: {
                return new EqualLongWindowManager(eventWindowParameter, ascending);
            }
            case FLOAT: {
                return new EqualFloatWindowManager(eventWindowParameter, ascending);
            }
            case DOUBLE: {
                return new EqualDoubleWindowManager(eventWindowParameter, ascending);
            }
            case TEXT: {
                return new EqualBinaryWindowManager(eventWindowParameter, ascending);
            }
            case BOOLEAN: {
                return new EqualBooleanWindowManager(eventWindowParameter, ascending);
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type in equal event aggregation : %s", eventWindowParameter.getDataType()));
    }

    private static VariationWindowManager genVariationEventWindowManager(VariationWindowParameter eventWindowParameter, boolean ascending) {
        switch (eventWindowParameter.getDataType()) {
            case INT32: {
                return new VariationIntWindowManager(eventWindowParameter, ascending);
            }
            case INT64: {
                return new VariationLongWindowManager(eventWindowParameter, ascending);
            }
            case FLOAT: {
                return new VariationFloatWindowManager(eventWindowParameter, ascending);
            }
            case DOUBLE: {
                return new VariationDoubleWindowManager(eventWindowParameter, ascending);
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type in variation event aggregation : %s", eventWindowParameter.getDataType()));
    }
}

