/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.unary;

import org.apache.iotdb.commons.exception.IoTDBRuntimeException;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.UnaryColumnTransformer;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.Type;

public class TimestampNegationColumnTransformer
extends UnaryColumnTransformer {
    public TimestampNegationColumnTransformer(Type returnType, ColumnTransformer childColumnTransformer) {
        super(returnType, childColumnTransformer);
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (!column.isNull(i)) {
                this.returnType.writeLong(columnBuilder, TimestampNegationColumnTransformer.transform(this.childColumnTransformer.getType().getLong(column, i)));
                continue;
            }
            columnBuilder.appendNull();
        }
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder, boolean[] selection) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (selection[i] && !column.isNull(i)) {
                this.returnType.writeLong(columnBuilder, TimestampNegationColumnTransformer.transform(this.childColumnTransformer.getType().getLong(column, i)));
                continue;
            }
            columnBuilder.appendNull();
        }
    }

    @Override
    protected void checkType() {
    }

    public static long transform(long value) {
        if (value == Long.MIN_VALUE) {
            throw new IoTDBRuntimeException(String.format("The %s is out of range of long.", value), TSStatusCode.NUMERIC_VALUE_OUT_OF_RANGE.getStatusCode(), true);
        }
        return -value;
    }
}

