/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.write.chunk;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.encoding.encoder.Encoder;
import org.apache.tsfile.encoding.encoder.TSEncodingBuilder;
import org.apache.tsfile.encrypt.EncryptParameter;
import org.apache.tsfile.encrypt.EncryptUtils;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.exception.write.PageException;
import org.apache.tsfile.file.header.PageHeader;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.read.common.block.column.TimeColumn;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.TsPrimitiveType;
import org.apache.tsfile.write.chunk.IChunkWriter;
import org.apache.tsfile.write.chunk.TimeChunkWriter;
import org.apache.tsfile.write.chunk.ValueChunkWriter;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.VectorMeasurementSchema;
import org.apache.tsfile.write.writer.TsFileIOWriter;

public class AlignedChunkWriterImpl
implements IChunkWriter {
    protected TimeChunkWriter timeChunkWriter;
    protected List<ValueChunkWriter> valueChunkWriterList;
    protected int valueIndex;
    protected EncryptParameter encryptParam;
    protected long remainingPointsNumber;

    protected AlignedChunkWriterImpl() {
    }

    public AlignedChunkWriterImpl(VectorMeasurementSchema schema) {
        this.encryptParam = EncryptUtils.getEncryptParameter();
        this.timeChunkWriter = new TimeChunkWriter(schema.getMeasurementName(), schema.getTimeCompressor(), schema.getTimeTSEncoding(), schema.getTimeEncoder(), this.encryptParam);
        List<String> valueMeasurementIdList = schema.getSubMeasurementsList();
        List<TSDataType> valueTSDataTypeList = schema.getSubMeasurementsTSDataTypeList();
        List<TSEncoding> valueTSEncodingList = schema.getSubMeasurementsTSEncodingList();
        List<Encoder> valueEncoderList = schema.getSubMeasurementsEncoderList();
        this.valueChunkWriterList = new ArrayList<ValueChunkWriter>(valueMeasurementIdList.size());
        for (int i = 0; i < valueMeasurementIdList.size(); ++i) {
            this.valueChunkWriterList.add(new ValueChunkWriter(valueMeasurementIdList.get(i), schema.getValueCompressor(i), valueTSDataTypeList.get(i), valueTSEncodingList.get(i), valueEncoderList.get(i), this.encryptParam));
        }
        this.valueIndex = 0;
        this.remainingPointsNumber = this.timeChunkWriter.getRemainingPointNumberForCurrentPage();
    }

    public AlignedChunkWriterImpl(VectorMeasurementSchema schema, EncryptParameter encryptParam) {
        this.encryptParam = encryptParam;
        this.timeChunkWriter = new TimeChunkWriter(schema.getMeasurementName(), schema.getTimeCompressor(), schema.getTimeTSEncoding(), schema.getTimeEncoder(), this.encryptParam);
        List<String> valueMeasurementIdList = schema.getSubMeasurementsList();
        List<TSDataType> valueTSDataTypeList = schema.getSubMeasurementsTSDataTypeList();
        List<TSEncoding> valueTSEncodingList = schema.getSubMeasurementsTSEncodingList();
        List<Encoder> valueEncoderList = schema.getSubMeasurementsEncoderList();
        this.valueChunkWriterList = new ArrayList<ValueChunkWriter>(valueMeasurementIdList.size());
        for (int i = 0; i < valueMeasurementIdList.size(); ++i) {
            this.valueChunkWriterList.add(new ValueChunkWriter(valueMeasurementIdList.get(i), schema.getValueCompressor(i), valueTSDataTypeList.get(i), valueTSEncodingList.get(i), valueEncoderList.get(i), this.encryptParam));
        }
        this.valueIndex = 0;
        this.remainingPointsNumber = this.timeChunkWriter.getRemainingPointNumberForCurrentPage();
    }

    public AlignedChunkWriterImpl(IMeasurementSchema timeSchema, List<IMeasurementSchema> valueSchemaList) {
        this.encryptParam = EncryptUtils.getEncryptParameter();
        this.timeChunkWriter = new TimeChunkWriter(timeSchema.getMeasurementName(), timeSchema.getCompressor(), timeSchema.getEncodingType(), timeSchema.getTimeEncoder(), this.encryptParam);
        this.valueChunkWriterList = new ArrayList<ValueChunkWriter>(valueSchemaList.size());
        for (int i = 0; i < valueSchemaList.size(); ++i) {
            this.valueChunkWriterList.add(new ValueChunkWriter(valueSchemaList.get(i).getMeasurementName(), valueSchemaList.get(i).getCompressor(), valueSchemaList.get(i).getType(), valueSchemaList.get(i).getEncodingType(), valueSchemaList.get(i).getValueEncoder(), this.encryptParam));
        }
        this.valueIndex = 0;
        this.remainingPointsNumber = this.timeChunkWriter.getRemainingPointNumberForCurrentPage();
    }

    public AlignedChunkWriterImpl(IMeasurementSchema timeSchema, List<IMeasurementSchema> valueSchemaList, EncryptParameter encryptParam) {
        this.encryptParam = encryptParam;
        this.timeChunkWriter = new TimeChunkWriter(timeSchema.getMeasurementName(), timeSchema.getCompressor(), timeSchema.getEncodingType(), timeSchema.getTimeEncoder(), this.encryptParam);
        this.valueChunkWriterList = new ArrayList<ValueChunkWriter>(valueSchemaList.size());
        for (int i = 0; i < valueSchemaList.size(); ++i) {
            this.valueChunkWriterList.add(new ValueChunkWriter(valueSchemaList.get(i).getMeasurementName(), valueSchemaList.get(i).getCompressor(), valueSchemaList.get(i).getType(), valueSchemaList.get(i).getEncodingType(), valueSchemaList.get(i).getValueEncoder(), this.encryptParam));
        }
        this.valueIndex = 0;
        this.remainingPointsNumber = this.timeChunkWriter.getRemainingPointNumberForCurrentPage();
    }

    public AlignedChunkWriterImpl(List<IMeasurementSchema> schemaList) {
        this.encryptParam = EncryptUtils.getEncryptParameter();
        TSEncoding timeEncoding = TSEncoding.valueOf(TSFileDescriptor.getInstance().getConfig().getTimeEncoder());
        TSDataType timeType = TSFileDescriptor.getInstance().getConfig().getTimeSeriesDataType();
        CompressionType timeCompression = TSFileDescriptor.getInstance().getConfig().getCompressor(TSDataType.INT64);
        this.timeChunkWriter = new TimeChunkWriter("", timeCompression, timeEncoding, TSEncodingBuilder.getEncodingBuilder(timeEncoding).getEncoder(timeType), this.encryptParam);
        this.valueChunkWriterList = new ArrayList<ValueChunkWriter>(schemaList.size());
        for (int i = 0; i < schemaList.size(); ++i) {
            this.valueChunkWriterList.add(new ValueChunkWriter(schemaList.get(i).getMeasurementName(), schemaList.get(i).getCompressor(), schemaList.get(i).getType(), schemaList.get(i).getEncodingType(), schemaList.get(i).getValueEncoder(), this.encryptParam));
        }
        this.valueIndex = 0;
        this.remainingPointsNumber = this.timeChunkWriter.getRemainingPointNumberForCurrentPage();
    }

    public AlignedChunkWriterImpl(List<IMeasurementSchema> schemaList, EncryptParameter encryptParam) {
        this.encryptParam = encryptParam;
        TSEncoding timeEncoding = TSEncoding.valueOf(TSFileDescriptor.getInstance().getConfig().getTimeEncoder());
        TSDataType timeType = TSFileDescriptor.getInstance().getConfig().getTimeSeriesDataType();
        CompressionType timeCompression = TSFileDescriptor.getInstance().getConfig().getCompressor();
        this.timeChunkWriter = new TimeChunkWriter("", timeCompression, timeEncoding, TSEncodingBuilder.getEncodingBuilder(timeEncoding).getEncoder(timeType), this.encryptParam);
        this.valueChunkWriterList = new ArrayList<ValueChunkWriter>(schemaList.size());
        for (int i = 0; i < schemaList.size(); ++i) {
            this.valueChunkWriterList.add(new ValueChunkWriter(schemaList.get(i).getMeasurementName(), schemaList.get(i).getCompressor(), schemaList.get(i).getType(), schemaList.get(i).getEncodingType(), schemaList.get(i).getValueEncoder(), this.encryptParam));
        }
        this.valueIndex = 0;
        this.remainingPointsNumber = this.timeChunkWriter.getRemainingPointNumberForCurrentPage();
    }

    public void write(long time, int value, boolean isNull) {
        this.valueChunkWriterList.get(this.valueIndex++).write(time, value, isNull);
    }

    public void write(long time, long value, boolean isNull) {
        this.valueChunkWriterList.get(this.valueIndex++).write(time, value, isNull);
    }

    public void write(long time, boolean value, boolean isNull) {
        this.valueChunkWriterList.get(this.valueIndex++).write(time, value, isNull);
    }

    public void write(long time, float value, boolean isNull) {
        this.valueChunkWriterList.get(this.valueIndex++).write(time, value, isNull);
    }

    public void write(long time, double value, boolean isNull) {
        this.valueChunkWriterList.get(this.valueIndex++).write(time, value, isNull);
    }

    public void write(long time, Binary value, boolean isNull) {
        this.valueChunkWriterList.get(this.valueIndex++).write(time, value, isNull);
    }

    public void write(long time, int value, boolean isNull, int valueIndex) {
        this.valueChunkWriterList.get(valueIndex).write(time, value, isNull);
    }

    public void write(long time, long value, boolean isNull, int valueIndex) {
        this.valueChunkWriterList.get(valueIndex).write(time, value, isNull);
    }

    public void write(long time, boolean value, boolean isNull, int valueIndex) {
        this.valueChunkWriterList.get(valueIndex).write(time, value, isNull);
    }

    public void write(long time, float value, boolean isNull, int valueIndex) {
        this.valueChunkWriterList.get(valueIndex).write(time, value, isNull);
    }

    public void write(long time, double value, boolean isNull, int valueIndex) {
        this.valueChunkWriterList.get(valueIndex).write(time, value, isNull);
    }

    public void write(long time, Binary value, boolean isNull, int valueIndex) {
        this.valueChunkWriterList.get(valueIndex).write(time, value, isNull);
    }

    public void write(long time, TsPrimitiveType[] points) {
        this.valueIndex = 0;
        block8: for (TsPrimitiveType point : points) {
            ValueChunkWriter writer = this.valueChunkWriterList.get(this.valueIndex++);
            switch (writer.getDataType()) {
                case INT64: 
                case TIMESTAMP: {
                    writer.write(time, point != null ? point.getLong() : Long.MAX_VALUE, point == null);
                    continue block8;
                }
                case INT32: 
                case DATE: {
                    writer.write(time, point != null ? point.getInt() : Integer.MAX_VALUE, point == null);
                    continue block8;
                }
                case FLOAT: {
                    writer.write(time, point != null ? point.getFloat() : Float.MAX_VALUE, point == null);
                    continue block8;
                }
                case DOUBLE: {
                    writer.write(time, point != null ? point.getDouble() : Double.MAX_VALUE, point == null);
                    continue block8;
                }
                case BOOLEAN: {
                    writer.write(time, point != null ? point.getBoolean() : false, point == null);
                    continue block8;
                }
                case TEXT: 
                case BLOB: 
                case STRING: {
                    writer.write(time, point != null ? point.getBinary() : new Binary("".getBytes(StandardCharsets.UTF_8)), point == null);
                }
            }
        }
        this.write(time);
    }

    public void write(long time) {
        this.valueIndex = 0;
        this.timeChunkWriter.write(time);
        if (this.checkPageSizeAndMayOpenANewPage()) {
            this.writePageToPageBuffer();
        }
    }

    public void writeTime(long time) {
        this.timeChunkWriter.write(time);
    }

    public void write(TimeColumn timeColumn, Column[] valueColumns, int batchSize) {
        if (this.remainingPointsNumber < (long)batchSize) {
            int pointsHasWritten = (int)this.remainingPointsNumber;
            this.batchWrite(timeColumn, valueColumns, pointsHasWritten, 0);
            this.batchWrite(timeColumn, valueColumns, batchSize - pointsHasWritten, pointsHasWritten);
        } else {
            this.batchWrite(timeColumn, valueColumns, batchSize, 0);
        }
    }

    private void batchWrite(TimeColumn timeColumn, Column[] valueColumns, int batchSize, int arrayOffset) {
        this.valueIndex = 0;
        long[] times = timeColumn.getTimes();
        block8: for (Column column : valueColumns) {
            ValueChunkWriter chunkWriter = this.valueChunkWriterList.get(this.valueIndex++);
            TSDataType tsDataType = chunkWriter.getDataType();
            switch (tsDataType) {
                case TEXT: 
                case BLOB: 
                case STRING: {
                    chunkWriter.write(times, column.getBinaries(), column.isNull(), batchSize, arrayOffset);
                    continue block8;
                }
                case DOUBLE: {
                    chunkWriter.write(times, column.getDoubles(), column.isNull(), batchSize, arrayOffset);
                    continue block8;
                }
                case BOOLEAN: {
                    chunkWriter.write(times, column.getBooleans(), column.isNull(), batchSize, arrayOffset);
                    continue block8;
                }
                case INT64: 
                case TIMESTAMP: {
                    chunkWriter.write(times, column.getLongs(), column.isNull(), batchSize, arrayOffset);
                    continue block8;
                }
                case INT32: 
                case DATE: {
                    chunkWriter.write(times, column.getInts(), column.isNull(), batchSize, arrayOffset);
                    continue block8;
                }
                case FLOAT: {
                    chunkWriter.write(times, column.getFloats(), column.isNull(), batchSize, arrayOffset);
                    continue block8;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown data type " + (Object)((Object)tsDataType));
                }
            }
        }
        this.write(times, batchSize, arrayOffset);
    }

    public void write(long[] time, int batchSize, int arrayOffset) {
        this.valueIndex = 0;
        this.timeChunkWriter.write(time, batchSize, arrayOffset);
        if (this.checkPageSizeAndMayOpenANewPage()) {
            this.writePageToPageBuffer();
        }
        this.remainingPointsNumber = this.timeChunkWriter.getRemainingPointNumberForCurrentPage();
    }

    public void writeByColumn(long time, int value, boolean isNull) {
        this.valueChunkWriterList.get(this.valueIndex).write(time, value, isNull);
    }

    public void writeByColumn(long time, long value, boolean isNull) {
        this.valueChunkWriterList.get(this.valueIndex).write(time, value, isNull);
    }

    public void writeByColumn(long time, boolean value, boolean isNull) {
        this.valueChunkWriterList.get(this.valueIndex).write(time, value, isNull);
    }

    public void writeByColumn(long time, float value, boolean isNull) {
        this.valueChunkWriterList.get(this.valueIndex).write(time, value, isNull);
    }

    public void writeByColumn(long time, double value, boolean isNull) {
        this.valueChunkWriterList.get(this.valueIndex).write(time, value, isNull);
    }

    public void writeByColumn(long time, Binary value, boolean isNull) {
        this.valueChunkWriterList.get(this.valueIndex).write(time, value, isNull);
    }

    public void nextColumn() {
        ++this.valueIndex;
    }

    protected boolean checkPageSizeAndMayOpenANewPage() {
        if (this.timeChunkWriter.checkPageSizeAndMayOpenANewPage()) {
            return true;
        }
        for (ValueChunkWriter writer : this.valueChunkWriterList) {
            if (!writer.checkPageSizeAndMayOpenANewPage()) continue;
            return true;
        }
        return false;
    }

    protected void writePageToPageBuffer() {
        this.timeChunkWriter.writePageToPageBuffer();
        for (ValueChunkWriter valueChunkWriter : this.valueChunkWriterList) {
            valueChunkWriter.writePageToPageBuffer();
        }
    }

    public void writePageHeaderAndDataIntoTimeBuff(ByteBuffer data, PageHeader header) throws PageException {
        this.timeChunkWriter.writePageHeaderAndDataIntoBuff(data, header);
    }

    public void writePageHeaderAndDataIntoValueBuff(ByteBuffer data, PageHeader header, int valueIndex) throws PageException {
        this.valueChunkWriterList.get(valueIndex).writePageHeaderAndDataIntoBuff(data, header);
    }

    @Override
    public void writeToFileWriter(TsFileIOWriter tsfileWriter) throws IOException {
        this.timeChunkWriter.writeToFileWriter(tsfileWriter);
        for (ValueChunkWriter valueChunkWriter : this.valueChunkWriterList) {
            valueChunkWriter.writeToFileWriter(tsfileWriter);
        }
    }

    @Override
    public long estimateMaxSeriesMemSize() {
        long estimateMaxSeriesMemSize = this.timeChunkWriter.estimateMaxSeriesMemSize();
        for (ValueChunkWriter valueChunkWriter : this.valueChunkWriterList) {
            estimateMaxSeriesMemSize += valueChunkWriter.estimateMaxSeriesMemSize();
        }
        return estimateMaxSeriesMemSize;
    }

    @Override
    public long getSerializedChunkSize() {
        long currentChunkSize = this.timeChunkWriter.getCurrentChunkSize();
        for (ValueChunkWriter valueChunkWriter : this.valueChunkWriterList) {
            currentChunkSize += valueChunkWriter.getCurrentChunkSize();
        }
        return currentChunkSize;
    }

    @Override
    public void sealCurrentPage() {
        this.timeChunkWriter.sealCurrentPage();
        for (ValueChunkWriter valueChunkWriter : this.valueChunkWriterList) {
            valueChunkWriter.sealCurrentPage();
        }
    }

    public void sealCurrentTimePage() {
        this.timeChunkWriter.sealCurrentPage();
    }

    public void sealCurrentValuePage(int valueIndex) {
        this.valueChunkWriterList.get(valueIndex).sealCurrentPage();
    }

    @Override
    public void clearPageWriter() {
        this.timeChunkWriter.clearPageWriter();
        for (ValueChunkWriter valueChunkWriter : this.valueChunkWriterList) {
            valueChunkWriter.clearPageWriter();
        }
    }

    @Override
    public boolean checkIsChunkSizeOverThreshold(long size, long pointNum, boolean returnTrueIfChunkEmpty) {
        if (returnTrueIfChunkEmpty && this.timeChunkWriter.getPointNum() == 0L || this.timeChunkWriter.getPointNum() >= pointNum || this.timeChunkWriter.estimateMaxSeriesMemSize() >= size) {
            return true;
        }
        for (ValueChunkWriter valueChunkWriter : this.valueChunkWriterList) {
            if (valueChunkWriter.estimateMaxSeriesMemSize() < size) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.timeChunkWriter.getPointNum() + this.timeChunkWriter.getPageWriter().getPointNumber() == 0L;
    }

    @Override
    public boolean checkIsUnsealedPageOverThreshold(long size, long pointNum, boolean returnTrueIfPageEmpty) {
        if (returnTrueIfPageEmpty && this.timeChunkWriter.getPageWriter().getPointNumber() == 0L || this.timeChunkWriter.checkIsUnsealedPageOverThreshold(size, pointNum)) {
            return true;
        }
        for (ValueChunkWriter valueChunkWriter : this.valueChunkWriterList) {
            if (!valueChunkWriter.checkIsUnsealedPageOverThreshold(size)) continue;
            return true;
        }
        return false;
    }

    public ValueChunkWriter getValueChunkWriterByIndex(int valueIndex) {
        return this.valueChunkWriterList.get(valueIndex);
    }

    public TimeChunkWriter getTimeChunkWriter() {
        return this.timeChunkWriter;
    }

    public List<ValueChunkWriter> getValueChunkWriterList() {
        return this.valueChunkWriterList;
    }
}

