/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.dprofile;

import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.library.dprofile.util.ExactOrderStatistics;
import org.apache.iotdb.library.dprofile.util.GKArray;
import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDAFPercentile
implements UDTF {
    protected static Map<Integer, Long> intDic;
    protected static Map<Long, Long> longDic;
    protected static Map<Float, Long> floatDic;
    protected static Map<Double, Long> doubleDic;
    private ExactOrderStatistics statistics;
    private GKArray sketch;
    private boolean exact;
    private double rank;
    private Type dataType;

    @Override
    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE).validate(error -> (Double)error >= 0.0 && (Double)error < 1.0, "error has to be greater than or equal to 0 and less than 1.", (Object)validator.getParameters().getDoubleOrDefault("error", 0.0)).validate(rank -> (Double)rank > 0.0 && (Double)rank <= 1.0, "rank has to be greater than 0 and less than or equal to 1.", (Object)validator.getParameters().getDoubleOrDefault("rank", 0.5));
    }

    @Override
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        configurations.setAccessStrategy(new RowByRowAccessStrategy()).setOutputDataType(parameters.getDataType(0));
        this.dataType = parameters.getDataType(0);
        double error = parameters.getDoubleOrDefault("error", 0.0);
        this.rank = parameters.getDoubleOrDefault("rank", 0.5);
        boolean bl = this.exact = error == 0.0;
        if (this.exact) {
            this.statistics = new ExactOrderStatistics(parameters.getDataType(0));
        } else {
            this.sketch = new GKArray(error);
        }
        switch (this.dataType) {
            case INT32: {
                intDic = new HashMap<Integer, Long>();
                break;
            }
            case INT64: {
                longDic = new HashMap<Long, Long>();
                break;
            }
            case FLOAT: {
                floatDic = new HashMap<Float, Long>();
                break;
            }
            case DOUBLE: {
                doubleDic = new HashMap<Double, Long>();
                break;
            }
        }
    }

    @Override
    public void transform(Row row, PointCollector collector) throws Exception {
        if (this.exact) {
            this.statistics.insert(row);
            switch (this.dataType) {
                case INT32: {
                    intDic.put(row.getInt(0), row.getTime());
                    break;
                }
                case INT64: {
                    longDic.put(row.getLong(0), row.getTime());
                    break;
                }
                case FLOAT: {
                    floatDic.put(Float.valueOf(row.getFloat(0)), row.getTime());
                    break;
                }
                case DOUBLE: {
                    doubleDic.put(row.getDouble(0), row.getTime());
                    break;
                }
            }
        } else {
            double res = Util.getValueAsDouble(row);
            this.sketch.insert(res);
        }
    }

    @Override
    public void terminate(PointCollector collector) throws Exception {
        if (this.exact) {
            switch (this.dataType) {
                case INT32: {
                    int ires = Integer.parseInt(this.statistics.getPercentile(this.rank));
                    long time = intDic.getOrDefault(ires, 0L);
                    collector.putInt(time, ires);
                    break;
                }
                case INT64: {
                    long lres = Long.parseLong(this.statistics.getPercentile(this.rank));
                    long time = longDic.getOrDefault(lres, 0L);
                    collector.putLong(time, lres);
                    break;
                }
                case FLOAT: {
                    float fres = Float.parseFloat(this.statistics.getPercentile(this.rank));
                    long time = floatDic.getOrDefault(Float.valueOf(fres), 0L);
                    collector.putFloat(time, fres);
                    break;
                }
                case DOUBLE: {
                    double dres = Double.parseDouble(this.statistics.getPercentile(this.rank));
                    long time = doubleDic.getOrDefault(dres, 0L);
                    collector.putDouble(time, dres);
                    break;
                }
            }
        } else {
            double res = this.sketch.query(this.rank);
            switch (this.dataType) {
                case INT32: {
                    collector.putInt(0L, (int)res);
                    break;
                }
                case INT64: {
                    collector.putLong(0L, (long)res);
                    break;
                }
                case FLOAT: {
                    collector.putFloat(0L, (float)res);
                    break;
                }
                case DOUBLE: {
                    collector.putDouble(0L, res);
                    break;
                }
            }
        }
    }
}

