/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import javax.jcr.RepositoryException;
import javax.jcr.Workspace;
import javax.jcr.query.qom.QueryObjectModelFactory;
import org.apache.jackrabbit.core.query.ExecutableQuery;
import org.apache.jackrabbit.core.query.PropertyTypeRegistry;
import org.apache.jackrabbit.core.query.lucene.PerQueryCache;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.jackrabbit.core.session.SessionContext;

public abstract class AbstractQueryImpl
implements ExecutableQuery {
    protected final SessionContext sessionContext;
    protected final SearchIndex index;
    protected final PropertyTypeRegistry propReg;
    private boolean documentOrder = true;
    protected final PerQueryCache cache = new PerQueryCache();

    public AbstractQueryImpl(SessionContext sessionContext, SearchIndex index, PropertyTypeRegistry propReg) {
        this.sessionContext = sessionContext;
        this.index = index;
        this.propReg = propReg;
    }

    public boolean getRespectDocumentOrder() {
        return this.documentOrder;
    }

    public void setRespectDocumentOrder(boolean documentOrder) {
        this.documentOrder = documentOrder;
    }

    protected QueryObjectModelFactory getQOMFactory() throws RepositoryException {
        Workspace workspace = this.sessionContext.getSessionImpl().getWorkspace();
        return workspace.getQueryManager().getQOMFactory();
    }

    public abstract boolean needsSystemTree();
}

