/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone.cli;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.chain.Context;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.jackrabbit.standalone.cli.CommandException;

public final class CommandHelper {
    private static ResourceBundle bundle = ResourceBundle.getBundle(CommandHelper.class.getPackage().getName() + ".resources");
    public static final String CURRENT_NODE_KEY = "jcr.current";
    public static final String REPOSITORY_KEY = "jcr.repository";
    public static final String SESSION_KEY = "jcr.session";
    public static final String OUTPUT_KEY = "jcr.output";
    public static final String REPO_ADDRESS_KEY = "jcr.repo.address";

    private CommandHelper() {
    }

    public static void setOutput(Context ctx, PrintWriter out) {
        if (out == null) {
            ctx.remove(OUTPUT_KEY);
        } else {
            ctx.put(OUTPUT_KEY, out);
        }
    }

    public static void setCurrentNode(Context ctx, Node node) {
        if (node == null) {
            ctx.remove(CURRENT_NODE_KEY);
        } else {
            ctx.put(CURRENT_NODE_KEY, node);
        }
    }

    public static void setRepository(Context ctx, Repository repository, String address) {
        if (repository == null) {
            ctx.remove(REPOSITORY_KEY);
            ctx.remove(REPO_ADDRESS_KEY);
        } else {
            ctx.put(REPOSITORY_KEY, repository);
            ctx.put(REPO_ADDRESS_KEY, address);
        }
    }

    public static void setSession(Context ctx, Session session) throws CommandException {
        if (session == null) {
            ctx.remove(SESSION_KEY);
        } else {
            if (ctx.get(SESSION_KEY) != null) {
                throw new CommandException("exception.already.logged.in");
            }
            ctx.put(SESSION_KEY, session);
        }
    }

    public static PrintWriter getOutput(Context ctx) {
        PrintWriter out = (PrintWriter)ctx.get(OUTPUT_KEY);
        if (out == null) {
            out = new PrintWriter(System.out, true);
        }
        return out;
    }

    public static Node getCurrentNode(Context ctx) throws CommandException {
        Node n = (Node)ctx.get(CURRENT_NODE_KEY);
        if (n == null) {
            throw new CommandException("exception.no.current.node");
        }
        return n;
    }

    public static Repository getRepository(Context ctx) throws CommandException {
        Repository r = (Repository)ctx.get(REPOSITORY_KEY);
        if (r == null) {
            throw new CommandException("exception.no.current.repository");
        }
        return r;
    }

    public static String getRepositoryAddress(Context ctx) throws CommandException {
        String a = (String)ctx.get(REPO_ADDRESS_KEY);
        if (a == null) {
            throw new CommandException("exception.no.current.repository");
        }
        return a;
    }

    public static Session getSession(Context ctx) throws CommandException {
        Session s = (Session)ctx.get(SESSION_KEY);
        if (s == null) {
            throw new CommandException("exception.no.current.session");
        }
        return s;
    }

    public static Node getNode(Context ctx, String path) throws CommandException, RepositoryException {
        try {
            Item i = CommandHelper.getItem(ctx, path);
            if (!i.isNode()) {
                throw new CommandException("exception.no.node.at", new String[]{path});
            }
            return (Node)i;
        }
        catch (PathNotFoundException e) {
            throw new CommandException("exception.no.node.at", new String[]{path});
        }
    }

    public static Item getItem(Context ctx, String path) throws CommandException, PathNotFoundException, RepositoryException {
        Node current = CommandHelper.getCurrentNode(ctx);
        Item i = null;
        if (path == null) {
            i = current;
        } else if (path.equals("/")) {
            i = current.getSession().getRootNode();
        } else if (path.startsWith("/")) {
            i = current.getSession().getItem(path);
        } else {
            Object newPath = current.getPath();
            if (!((String)newPath).endsWith("/")) {
                newPath = (String)newPath + "/";
            }
            newPath = (String)newPath + path;
            i = current.getSession().getItem((String)newPath);
        }
        return i;
    }

    public static boolean hasNode(Context ctx, String path) throws CommandException, RepositoryException {
        Session s = CommandHelper.getSession(ctx);
        if (path.equals("/")) {
            return true;
        }
        if (path.startsWith("/")) {
            return s.getRootNode().hasNode(path.substring(1));
        }
        Node current = (Node)ctx.get(CURRENT_NODE_KEY);
        return current.hasNode(path);
    }

    public static NodeIterator getNodes(Context ctx, Node node, String pattern) throws RepositoryException {
        if (pattern != null) {
            return node.getNodes(pattern);
        }
        return node.getNodes();
    }

    public static PropertyIterator getProperties(Context ctx, Node node, String pattern) throws RepositoryException {
        if (pattern != null) {
            return node.getProperties(pattern);
        }
        return node.getProperties();
    }

    public static ResourceBundle getBundle() {
        return bundle;
    }

    public static Iterator<Item> getItems(Context ctx, Node node, String pattern) throws RepositoryException {
        return IteratorUtils.chainedIterator(CommandHelper.getNodes(ctx, node, pattern), CommandHelper.getProperties(ctx, node, pattern));
    }
}

