/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailet;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;

public class Attribute {
    private final AttributeName name;
    private final AttributeValue<?> value;

    public static Attribute convertToAttribute(String name, Object value) {
        AttributeName attributeName = AttributeName.of(name);
        AttributeValue<?> attributeValue = AttributeValue.ofAny(value);
        return new Attribute(attributeName, attributeValue);
    }

    public Attribute(AttributeName name, AttributeValue<?> value) {
        Preconditions.checkNotNull((Object)name, (Object)"`name` should not be null");
        Preconditions.checkNotNull(value, (Object)"`value` should not be null");
        this.name = name;
        this.value = value;
    }

    public AttributeName getName() {
        return this.name;
    }

    public AttributeValue<?> getValue() {
        return this.value;
    }

    public Attribute duplicate() {
        return new Attribute(this.name, this.value.duplicate());
    }

    public final boolean equals(Object o) {
        if (o instanceof Attribute) {
            Attribute that = (Attribute)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("value", this.value).toString();
    }
}

