/*
 * Decompiled with CFR 0.152.
 */
package cats.syntax;

import cats.Alternative;
import cats.Applicative;
import cats.ApplicativeError;
import cats.Eval;
import cats.Now;
import cats.Show;
import cats.data.EitherT;
import cats.data.EitherT$;
import cats.data.EitherT$FromEitherPartiallyApplied$;
import cats.data.Ior;
import cats.data.Ior$;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.Validated;
import cats.data.Validated$;
import cats.kernel.Eq;
import cats.kernel.Order;
import cats.kernel.PartialOrder;
import cats.kernel.Semigroup;
import cats.syntax.EitherOps;
import cats.syntax.EitherUtil$;
import java.io.Serializable;
import scala.;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;

public final class EitherOps$ {
    public static final EitherOps$ MODULE$ = new EitherOps$();

    public final <A, B> void foreach$extension(Either<A, B> $this, Function1<B, BoxedUnit> f) {
        Either<A, B> either = $this;
        if (either instanceof Left) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Object b = right.value();
            BoxedUnit boxedUnit = (BoxedUnit)f.apply(b);
        } else {
            throw new MatchError(either);
        }
    }

    public final <BB, A, B> BB getOrElse$extension(Either<A, B> $this, Function0<BB> function0) {
        Object object;
        Either<A, B> either = $this;
        if (either instanceof Left) {
            object = function0.apply();
        } else if (either instanceof Right) {
            Object b;
            Right right = (Right)either;
            object = b = right.value();
        } else {
            throw new MatchError(either);
        }
        return (BB)object;
    }

    public final <C, BB, A, B> Either<C, BB> orElse$extension(Either<A, B> $this, Function0<Either<C, BB>> fallback) {
        Either either;
        Either<A, B> either2 = $this;
        if (either2 instanceof Left) {
            either = (Either)fallback.apply();
        } else if (either2 instanceof Right) {
            Right right = (Right)either2;
            either = EitherUtil$.MODULE$.leftCast(right);
        } else {
            throw new MatchError(either2);
        }
        return either;
    }

    public final <BB, A, B> Either<A, BB> recover$extension(Either<A, B> $this, PartialFunction<A, BB> pf) {
        Left left;
        Object a;
        Right right = $this;
        Right right2 = right instanceof Left && pf.isDefinedAt(a = (left = (Left)right).value()) ? package$.MODULE$.Right().apply(pf.apply(a)) : $this;
        return right2;
    }

    public final <AA, BB, A, B> Either<AA, BB> recoverWith$extension(Either<A, B> $this, PartialFunction<A, Either<AA, BB>> pf) {
        Left left;
        Object a;
        Either either = $this;
        Either either2 = either instanceof Left && pf.isDefinedAt(a = (left = (Left)either).value()) ? (Either)pf.apply(a) : $this;
        return either2;
    }

    public final <BB, A, B> BB valueOr$extension(Either<A, B> $this, Function1<A, BB> f) {
        Object object;
        Either<A, B> either = $this;
        if (either instanceof Left) {
            Left left = (Left)either;
            Object a = left.value();
            object = f.apply(a);
        } else if (either instanceof Right) {
            Object b;
            Right right = (Right)either;
            object = b = right.value();
        } else {
            throw new MatchError(either);
        }
        return (BB)object;
    }

    public final <A, B> boolean forall$extension(Either<A, B> $this, Function1<B, Object> f) {
        boolean bl;
        Either<A, B> either = $this;
        if (either instanceof Left) {
            bl = true;
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Object b = right.value();
            bl = BoxesRunTime.unboxToBoolean((Object)f.apply(b));
        } else {
            throw new MatchError(either);
        }
        return bl;
    }

    public final <A, B> boolean exists$extension(Either<A, B> $this, Function1<B, Object> f) {
        boolean bl;
        Either<A, B> either = $this;
        if (either instanceof Left) {
            bl = false;
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Object b = right.value();
            bl = BoxesRunTime.unboxToBoolean((Object)f.apply(b));
        } else {
            throw new MatchError(either);
        }
        return bl;
    }

    public final <AA, A, B> Either<AA, B> ensure$extension(Either<A, B> $this, Function0<AA> onFailure, Function1<B, Object> f) {
        Left left;
        Left left2 = $this;
        if (left2 instanceof Left) {
            left = $this;
        } else if (left2 instanceof Right) {
            Right right = (Right)left2;
            Object b = right.value();
            left = BoxesRunTime.unboxToBoolean((Object)f.apply(b)) ? $this : package$.MODULE$.Left().apply(onFailure.apply());
        } else {
            throw new MatchError(left2);
        }
        return left;
    }

    public final <AA, A, B> Either<AA, B> ensureOr$extension(Either<A, B> $this, Function1<B, AA> onFailure, Function1<B, Object> f) {
        Left left;
        Left left2 = $this;
        if (left2 instanceof Left) {
            left = $this;
        } else if (left2 instanceof Right) {
            Right right = (Right)left2;
            Object b = right.value();
            left = BoxesRunTime.unboxToBoolean((Object)f.apply(b)) ? $this : package$.MODULE$.Left().apply(onFailure.apply(b));
        } else {
            throw new MatchError(left2);
        }
        return left;
    }

    public final <A, B> Ior<A, B> toIor$extension(Either<A, B> $this) {
        return Ior$.MODULE$.fromEither($this);
    }

    public final <A, B> Option<B> toOption$extension(Either<A, B> $this) {
        None$ none$;
        Either<A, B> either = $this;
        if (either instanceof Left) {
            none$ = None$.MODULE$;
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Object b = right.value();
            none$ = new Some(b);
        } else {
            throw new MatchError(either);
        }
        return none$;
    }

    public final <A, B> List<B> toList$extension(Either<A, B> $this) {
        Nil$ nil$;
        Either<A, B> either = $this;
        if (either instanceof Left) {
            nil$ = package$.MODULE$.Nil();
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Object b = right.value();
            nil$ = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{b}));
        } else {
            throw new MatchError(either);
        }
        return nil$;
    }

    public final <A, B> Try<B> toTry$extension(Either<A, B> $this, .less.colon.less<A, Throwable> ev) {
        Failure failure;
        Either<A, B> either = $this;
        if (either instanceof Left) {
            Left left = (Left)either;
            Object a = left.value();
            failure = new Failure((Throwable)ev.apply(a));
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Object b = right.value();
            failure = new Success(b);
        } else {
            throw new MatchError(either);
        }
        return failure;
    }

    public final <A, B> Validated<A, B> toValidated$extension(Either<A, B> $this) {
        Validated<Object, Object> validated;
        Either<A, B> either = $this;
        if (either instanceof Left) {
            Left left = (Left)either;
            Object a = left.value();
            validated = Validated$.MODULE$.invalid(a);
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Object b = right.value();
            validated = Validated$.MODULE$.valid(b);
        } else {
            throw new MatchError(either);
        }
        return validated;
    }

    public final <AA, A, B> Validated<NonEmptyList<AA>, B> toValidatedNel$extension(Either<A, B> $this) {
        Validated<NonEmptyList<Object>, Object> validated;
        Either<A, B> either = $this;
        if (either instanceof Left) {
            Left left = (Left)either;
            Object a = left.value();
            validated = Validated$.MODULE$.invalidNel(a);
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Object b = right.value();
            validated = Validated$.MODULE$.valid(b);
        } else {
            throw new MatchError(either);
        }
        return validated;
    }

    public final <AA, BB, A, B> Either<AA, BB> withValidated$extension(Either<A, B> $this, Function1<Validated<A, B>, Validated<AA, BB>> f) {
        return ((Validated)f.apply(this.toValidated$extension($this))).toEither();
    }

    public final <F, A, B> F to$extension(Either<A, B> $this, Alternative<F> F) {
        Object f;
        Either<A, B> either = $this;
        if (either instanceof Left) {
            f = F.empty();
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Object b = right.value();
            f = F.pure(b);
        } else {
            throw new MatchError(either);
        }
        return f;
    }

    public final <C, D, A, B> Either<C, D> bimap$extension(Either<A, B> $this, Function1<A, C> fa, Function1<B, D> fb) {
        Left left;
        Either<A, B> either = $this;
        if (either instanceof Left) {
            Left left2 = (Left)either;
            Object a = left2.value();
            left = package$.MODULE$.Left().apply(fa.apply(a));
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Object b = right.value();
            left = package$.MODULE$.Right().apply(fb.apply(b));
        } else {
            throw new MatchError(either);
        }
        return left;
    }

    public final <C, A, B> Either<A, C> map$extension(Either<A, B> $this, Function1<B, C> f) {
        Right right;
        Either<A, B> either = $this;
        if (either instanceof Left) {
            Left left = (Left)either;
            right = EitherUtil$.MODULE$.rightCast(left);
        } else if (either instanceof Right) {
            Right right2 = (Right)either;
            Object b = right2.value();
            right = package$.MODULE$.Right().apply(f.apply(b));
        } else {
            throw new MatchError(either);
        }
        return right;
    }

    public final <AA, C, Z, A, B> Eval<Either<AA, Z>> map2Eval$extension(Either<A, B> $this, Eval<Either<AA, C>> fc, Function2<B, C, Z> f) {
        Eval eval;
        Either<A, B> either = $this;
        if (either instanceof Left) {
            Left left = (Left)either;
            eval = new Now<Either<AA, Z>>(EitherUtil$.MODULE$.rightCast(left));
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Object b = right.value();
            eval = fc.map((Function1 & Serializable)x$1 -> x$1.map((Function1 & Serializable)x$2 -> f.apply(b, x$2)));
        } else {
            throw new MatchError(either);
        }
        return eval;
    }

    public final <C, A, B> Either<C, B> leftMap$extension(Either<A, B> $this, Function1<A, C> f) {
        Left left;
        Either<A, B> either = $this;
        if (either instanceof Left) {
            Left left2 = (Left)either;
            Object a = left2.value();
            left = package$.MODULE$.Left().apply(f.apply(a));
        } else if (either instanceof Right) {
            Right right = (Right)either;
            left = EitherUtil$.MODULE$.leftCast(right);
        } else {
            throw new MatchError(either);
        }
        return left;
    }

    public final <AA, D, A, B> Either<AA, D> flatMap$extension(Either<A, B> $this, Function1<B, Either<AA, D>> f) {
        Either either;
        Either<A, B> either2 = $this;
        if (either2 instanceof Left) {
            Left left = (Left)either2;
            either = EitherUtil$.MODULE$.rightCast(left);
        } else if (either2 instanceof Right) {
            Right right = (Right)either2;
            Object b = right.value();
            either = (Either)f.apply(b);
        } else {
            throw new MatchError(either2);
        }
        return either;
    }

    public final <C, BB, A, B> Either<C, BB> leftFlatMap$extension(Either<A, B> $this, Function1<A, Either<C, BB>> f) {
        Either either;
        Either<A, B> either2 = $this;
        if (either2 instanceof Left) {
            Left left = (Left)either2;
            Object a = left.value();
            either = (Either)f.apply(a);
        } else if (either2 instanceof Right) {
            Right right = (Right)either2;
            either = EitherUtil$.MODULE$.leftCast(right);
        } else {
            throw new MatchError(either2);
        }
        return either;
    }

    public final <AA, BB, A, B> int compare$extension(Either<A, B> $this, Either<AA, BB> that, Order<AA> AA, Order<BB> BB) {
        int n;
        Either<A, B> either = $this;
        if (either instanceof Left) {
            int n2;
            Left left = (Left)either;
            Object a1 = left.value();
            Either<AA, BB> either2 = that;
            if (either2 instanceof Left) {
                Left left2 = (Left)either2;
                Object a2 = left2.value();
                n2 = AA.compare(a1, a2);
            } else if (either2 instanceof Right) {
                n2 = -1;
            } else {
                throw new MatchError(either2);
            }
            n = n2;
        } else if (either instanceof Right) {
            int n3;
            Right right = (Right)either;
            Object b1 = right.value();
            Either<AA, BB> either3 = that;
            if (either3 instanceof Left) {
                n3 = 1;
            } else if (either3 instanceof Right) {
                Right right2 = (Right)either3;
                Object b2 = right2.value();
                n3 = BB.compare(b1, b2);
            } else {
                throw new MatchError(either3);
            }
            n = n3;
        } else {
            throw new MatchError(either);
        }
        return n;
    }

    public final <AA, BB, A, B> double partialCompare$extension(Either<A, B> $this, Either<AA, BB> that, PartialOrder<AA> AA, PartialOrder<BB> BB) {
        double d;
        Either<A, B> either = $this;
        if (either instanceof Left) {
            double d2;
            Left left = (Left)either;
            Object a1 = left.value();
            Either<AA, BB> either2 = that;
            if (either2 instanceof Left) {
                Left left2 = (Left)either2;
                Object a2 = left2.value();
                d2 = AA.partialCompare(a1, a2);
            } else if (either2 instanceof Right) {
                d2 = -1.0;
            } else {
                throw new MatchError(either2);
            }
            d = d2;
        } else if (either instanceof Right) {
            double d3;
            Right right = (Right)either;
            Object b1 = right.value();
            Either<AA, BB> either3 = that;
            if (either3 instanceof Left) {
                d3 = 1.0;
            } else if (either3 instanceof Right) {
                Right right2 = (Right)either3;
                Object b2 = right2.value();
                d3 = BB.partialCompare(b1, b2);
            } else {
                throw new MatchError(either3);
            }
            d = d3;
        } else {
            throw new MatchError(either);
        }
        return d;
    }

    public final <AA, BB, A, B> boolean $eq$eq$eq$extension(Either<A, B> $this, Either<AA, BB> that, Eq<AA> AA, Eq<BB> BB) {
        boolean bl;
        Either<A, B> either = $this;
        if (either instanceof Left) {
            boolean bl2;
            Left left = (Left)either;
            Object a1 = left.value();
            Either<AA, BB> either2 = that;
            if (either2 instanceof Left) {
                Left left2 = (Left)either2;
                Object a2 = left2.value();
                bl2 = AA.eqv(a1, a2);
            } else if (either2 instanceof Right) {
                bl2 = false;
            } else {
                throw new MatchError(either2);
            }
            bl = bl2;
        } else if (either instanceof Right) {
            boolean bl3;
            Right right = (Right)either;
            Object b1 = right.value();
            Either<AA, BB> either3 = that;
            if (either3 instanceof Left) {
                bl3 = false;
            } else if (either3 instanceof Right) {
                Right right2 = (Right)either3;
                Object b2 = right2.value();
                bl3 = BB.eqv(b1, b2);
            } else {
                throw new MatchError(either3);
            }
            bl = bl3;
        } else {
            throw new MatchError(either);
        }
        return bl;
    }

    public final <F, AA, D, A, B> F traverse$extension(Either<A, B> $this, Function1<B, F> f, Applicative<F> F) {
        Object object;
        Either<A, B> either = $this;
        if (either instanceof Left) {
            Left left = (Left)either;
            object = F.pure(EitherUtil$.MODULE$.rightCast(left));
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Object b = right.value();
            object = F.map(f.apply(b), (Function1 & Serializable)x$3 -> package$.MODULE$.Right().apply(x$3));
        } else {
            throw new MatchError(either);
        }
        return object;
    }

    public final <C, A, B> C foldLeft$extension(Either<A, B> $this, C c, Function2<C, B, C> f) {
        Object object;
        Either<A, B> either = $this;
        if (either instanceof Left) {
            object = c;
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Object b = right.value();
            object = f.apply(c, b);
        } else {
            throw new MatchError(either);
        }
        return object;
    }

    public final <C, A, B> Eval<C> foldRight$extension(Either<A, B> $this, Eval<C> lc, Function2<B, Eval<C>, Eval<C>> f) {
        Eval eval;
        Either<A, B> either = $this;
        if (either instanceof Left) {
            eval = lc;
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Object b = right.value();
            eval = (Eval)f.apply(b, lc);
        } else {
            throw new MatchError(either);
        }
        return eval;
    }

    public final <AA, BB, A, B> Either<AA, BB> combine$extension(Either<A, B> $this, Either<AA, BB> that, Semigroup<BB> BB) {
        Left left;
        Either<A, B> either = $this;
        if (either instanceof Left) {
            Left left2;
            left = left2 = (Left)either;
        } else if (either instanceof Right) {
            Left left3;
            Right right = (Right)either;
            Object b1 = right.value();
            Either<AA, BB> either2 = that;
            if (either2 instanceof Left) {
                Left left4;
                left3 = left4 = (Left)either2;
            } else if (either2 instanceof Right) {
                Right right2 = (Right)either2;
                Object b2 = right2.value();
                left3 = package$.MODULE$.Right().apply(BB.combine(b1, b2));
            } else {
                throw new MatchError(either2);
            }
            left = left3;
        } else {
            throw new MatchError(either);
        }
        return left;
    }

    public final <AA, BB, A, B> String show$extension(Either<A, B> $this, Show<AA> AA, Show<BB> BB) {
        String string;
        Either<A, B> either = $this;
        if (either instanceof Left) {
            Left left = (Left)either;
            Object a = left.value();
            string = new StringBuilder(6).append("Left(").append(AA.show(a)).append(")").toString();
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Object b = right.value();
            string = new StringBuilder(7).append("Right(").append(BB.show(b)).append(")").toString();
        } else {
            throw new MatchError(either);
        }
        return string;
    }

    public final <AA, BB, C, A, B> Either<AA, C> ap$extension(Either<A, B> $this, Either<AA, Function1<BB, C>> that) {
        return that.flatMap((Function1 & Serializable)f -> $this.map(f));
    }

    public final <F, A, B> EitherT<F, A, B> toEitherT$extension(Either<A, B> $this, Applicative<F> evidence$1) {
        return EitherT$FromEitherPartiallyApplied$.MODULE$.apply$extension(EitherT$.MODULE$.fromEither(), $this, evidence$1);
    }

    public final <AA, A, B> Either<Object, B> toEitherNec$extension(Either<A, B> $this) {
        return this.leftMap$extension($this, (Function1 & Serializable)a -> cats.data.package$.MODULE$.NonEmptyChain().one(a));
    }

    public final <AA, A, B> Either<Object, B> toEitherNes$extension(Either<A, B> $this, Order<AA> O) {
        return this.leftMap$extension($this, (Function1 & Serializable)x$4 -> cats.data.package$.MODULE$.NonEmptySet().one(x$4, O));
    }

    public final <AA, A, B> Either<NonEmptyList<AA>, B> toEitherNel$extension(Either<A, B> $this) {
        return this.leftMap$extension($this, (Function1 & Serializable)head -> NonEmptyList$.MODULE$.one(head));
    }

    public final <F, A, B> F raiseOrPure$extension(Either<A, B> $this, ApplicativeError<F, A> ev) {
        return ev.fromEither($this);
    }

    public final <F, A, B> F liftTo$extension(Either<A, B> $this, ApplicativeError<F, ? super A> F) {
        return F.fromEither($this);
    }

    public final <A, B> int hashCode$extension(Either<A, B> $this) {
        return $this.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final <A, B> boolean equals$extension(Either<A, B> $this, Object x$1) {
        Object object = x$1;
        if (!(object instanceof EitherOps)) return false;
        boolean bl = true;
        if (!bl) return false;
        Either either = x$1 == null ? null : ((EitherOps)x$1).cats$syntax$EitherOps$$eab();
        Either<A, B> either2 = $this;
        Either either3 = either;
        if (either2 != null) {
            if (!either2.equals(either3)) return false;
            return true;
        }
        if (either3 == null) return true;
        return false;
    }

    private EitherOps$() {
    }
}

