/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.mail;

import java.io.Serializable;
import javax.inject.Inject;
import org.apache.james.jmap.api.model.Size$;
import org.apache.james.jmap.core.UTCDate;
import org.apache.james.jmap.core.UTCDate$;
import org.apache.james.jmap.mail.BlobId;
import org.apache.james.jmap.mail.BlobId$;
import org.apache.james.jmap.mail.Email$;
import org.apache.james.jmap.mail.EmailGetRequest;
import org.apache.james.jmap.mail.EmailHeaderView;
import org.apache.james.jmap.mail.EmailHeaders$;
import org.apache.james.jmap.mail.EmailMetadata;
import org.apache.james.jmap.mail.EmailViewFactory;
import org.apache.james.jmap.mail.Keywords;
import org.apache.james.jmap.mail.KeywordsFactory$;
import org.apache.james.jmap.mail.MailboxIds;
import org.apache.james.jmap.method.ZoneIdProvider;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.util.html.HtmlTextExtractor;
import scala.Function0;
import scala.Function1;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u00154A\u0001B\u0003\u0005!!Aa\u0004\u0001B\u0001B\u0003%q\u0004C\u0003&\u0001\u0011\u0005a\u0005C\u00033\u0001\u0011\u00053G\u0001\fF[\u0006LG\u000eS3bI\u0016\u0014h+[3x\r\u0006\u001cGo\u001c:z\u0015\t1q!\u0001\u0003nC&d'B\u0001\u0005\n\u0003\u0011QW.\u00199\u000b\u0005)Y\u0011!\u00026b[\u0016\u001c(B\u0001\u0007\u000e\u0003\u0019\t\u0007/Y2iK*\ta\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001#]\u0001\"AE\u000b\u000e\u0003MQ\u0011\u0001F\u0001\u0006g\u000e\fG.Y\u0005\u0003-M\u0011a!\u00118z%\u00164\u0007c\u0001\r\u001a75\tQ!\u0003\u0002\u001b\u000b\t\u0001R)\\1jYZKWm\u001e$bGR|'/\u001f\t\u00031qI!!H\u0003\u0003\u001f\u0015k\u0017-\u001b7IK\u0006$WM\u001d,jK^\faB_8oK&#\u0007K]8wS\u0012,'\u000f\u0005\u0002!G5\t\u0011E\u0003\u0002#\u000f\u00051Q.\u001a;i_\u0012L!\u0001J\u0011\u0003\u001di{g.Z%e!J|g/\u001b3fe\u00061A(\u001b8jiz\"\"a\n\u0015\u0011\u0005a\u0001\u0001\"\u0002\u0010\u0003\u0001\u0004y\u0002F\u0001\u0002+!\tY\u0003'D\u0001-\u0015\tic&\u0001\u0004j]*,7\r\u001e\u0006\u0002_\u0005)!.\u0019<bq&\u0011\u0011\u0007\f\u0002\u0007\u0013:TWm\u0019;\u0002\u000fQ|W)\\1jYR\u0019Ag\u00161\u0015\u0005UZ\u0004c\u0001\u001c:75\tqG\u0003\u00029'\u0005!Q\u000f^5m\u0013\tQtGA\u0002UefDQ\u0001P\u0002A\u0002u\nq!\\3tg\u0006<W\r\u0005\u0003\u0013}\u0001C\u0015BA \u0014\u0005\u0019!V\u000f\u001d7feA\u0011\u0011IR\u0007\u0002\u0005*\u00111\tR\u0001\u0006[>$W\r\u001c\u0006\u0003\u000b&\tq!\\1jY\n|\u00070\u0003\u0002H\u0005\nIQ*Z:tC\u001e,\u0017\n\u001a\t\u0004\u0013F#fB\u0001&P\u001d\tYe*D\u0001M\u0015\tiu\"\u0001\u0004=e>|GOP\u0005\u0002)%\u0011\u0001kE\u0001\ba\u0006\u001c7.Y4f\u0013\t\u00116KA\u0002TKFT!\u0001U\n\u0011\u0005\u0005+\u0016B\u0001,C\u00055iUm]:bO\u0016\u0014Vm];mi\")\u0001l\u0001a\u00013\u0006\t\u0002\u000e^7m)\u0016DH/\u0012=ue\u0006\u001cGo\u001c:\u0011\u0005isV\"A.\u000b\u0005qk\u0016\u0001\u00025u[2T!\u0001O\u0005\n\u0005}[&!\u0005%u[2$V\r\u001f;FqR\u0014\u0018m\u0019;pe\")\u0011m\u0001a\u0001E\u00069!/Z9vKN$\bC\u0001\rd\u0013\t!WAA\bF[\u0006LGnR3u%\u0016\fX/Z:u\u0001")
public class EmailHeaderViewFactory
implements EmailViewFactory<EmailHeaderView> {
    private final ZoneIdProvider zoneIdProvider;

    @Override
    public Try<EmailHeaderView> toEmail(HtmlTextExtractor htmlTextExtractor, EmailGetRequest request, Tuple2<MessageId, Seq<MessageResult>> message) {
        MessageId messageId = (MessageId)message._1();
        MailboxIds mailboxIds = new MailboxIds((List<MailboxId>)((IterableOnceOps)((IterableOps)message._2()).map((Function1 & Serializable)x$12 -> x$12.getMailboxId())).toList());
        String threadId = ((MessageResult)((IterableOps)message._2()).head()).getThreadId().serialize();
        return ((Try)((IterableOps)message._2()).headOption().map((Function1 & Serializable)x$13 -> new Success(x$13)).getOrElse((Function0 & Serializable)() -> new Failure((Throwable)new IllegalArgumentException("No message supplied")))).flatMap((Function1 & Serializable)firstMessage -> Email$.MODULE$.parseAsMime4JMessage((MessageResult)firstMessage).flatMap((Function1 & Serializable)mime4JMessage -> BlobId$.MODULE$.of(messageId).flatMap((Function1 & Serializable)blobId -> KeywordsFactory$.MODULE$.LENIENT_KEYWORDS_FACTORY().fromFlags(firstMessage.getFlags()).map((Function1 & Serializable)keywords -> {
            MessageId x$1 = messageId;
            BlobId x$2 = blobId;
            String x$3 = threadId;
            MailboxIds x$4 = mailboxIds;
            UTCDate x$5 = UTCDate$.MODULE$.from(firstMessage.getInternalDate(), $this.zoneIdProvider.get());
            Long x$6 = Size$.MODULE$.sanitizeSize(firstMessage.getSize());
            Keywords x$7 = keywords;
            return new EmailHeaderView(new EmailMetadata(x$1, x$2, x$3, x$7, x$4, x$6, x$5), EmailHeaders$.MODULE$.from($this.zoneIdProvider.get(), (Message)mime4JMessage), EmailHeaders$.MODULE$.extractSpecificHeaders(request.properties(), $this.zoneIdProvider.get(), (Message)mime4JMessage));
        }))));
    }

    @Inject
    public EmailHeaderViewFactory(ZoneIdProvider zoneIdProvider) {
        this.zoneIdProvider = zoneIdProvider;
    }
}

