/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Collection;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.mail.Flags;
import org.apache.james.jmap.core.SetError;
import org.apache.james.jmap.core.SetError$;
import org.apache.james.jmap.json.EmailSetSerializer;
import org.apache.james.jmap.mail.EmailSet$;
import org.apache.james.jmap.mail.EmailSetRequest;
import org.apache.james.jmap.mail.Keywords;
import org.apache.james.jmap.mail.KeywordsFactory$;
import org.apache.james.jmap.mail.MailboxIds;
import org.apache.james.jmap.mail.UnparsedMessageId;
import org.apache.james.jmap.mail.ValidatedEmailSetUpdate;
import org.apache.james.jmap.method.EmailSetUpdatePerformer$EmailUpdateSuccess$;
import org.apache.james.jmap.method.MessageNotFoundException;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.exception.OverQuotaException;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageRange;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsValue;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scheduler.Schedulers;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0011]s!\u0002.\\\u0011\u00031g!\u00025\\\u0011\u0003I\u0007\"\u00029\u0002\t\u0003\tha\u0002:\u0002!\u0003\r\na\u001d\u0004\u0005i\u0006\u0001U\u000f\u0003\u0006\u0002\u0010\u0011\u0011)\u001a!C\u0001\u0003#A!\"a\t\u0005\u0005#\u0005\u000b\u0011BA\n\u0011\u0019\u0001H\u0001\"\u0001\u0002&!I\u00111\u0006\u0003\u0002\u0002\u0013\u0005\u0011Q\u0006\u0005\n\u0003c!\u0011\u0013!C\u0001\u0003gA\u0011\"!\u0013\u0005\u0003\u0003%\t%a\u0013\t\u0013\u0005uC!!A\u0005\u0002\u0005}\u0003\"CA4\t\u0005\u0005I\u0011AA5\u0011%\t)\bBA\u0001\n\u0003\t9\bC\u0005\u0002\u0002\u0012\t\t\u0011\"\u0011\u0002\u0004\"I\u0011q\u0011\u0003\u0002\u0002\u0013\u0005\u0013\u0011\u0012\u0005\n\u0003\u0017#\u0011\u0011!C!\u0003\u001bC\u0011\"a$\u0005\u0003\u0003%\t%!%\b\u0013\u0005U\u0015!!A\t\u0002\u0005]e\u0001\u0003;\u0002\u0003\u0003E\t!!'\t\rA\u001cB\u0011AAY\u0011%\tYiEA\u0001\n\u000b\ni\tC\u0005\u00024N\t\t\u0011\"!\u00026\"I\u0011\u0011X\n\u0002\u0002\u0013\u0005\u00151\u0018\u0005\n\u0003\u000f\u001c\u0012\u0011!C\u0005\u0003\u00134a!!5\u0002\u0001\u0006M\u0007BCAk3\tU\r\u0011\"\u0001\u0002X\"Q\u0011Q]\r\u0003\u0012\u0003\u0006I!!7\t\u0015\u0005\u001d\u0018D!f\u0001\n\u0003\tI\u000f\u0003\u0006\u0002rf\u0011\t\u0012)A\u0005\u0003WDa\u0001]\r\u0005\u0002\u0005M\bbBA~3\u0011\u0005\u0011Q \u0005\n\u0003WI\u0012\u0011!C\u0001\u0005\u0017A\u0011\"!\r\u001a#\u0003%\tA!\u0005\t\u0013\tU\u0011$%A\u0005\u0002\t]\u0001\"CA%3\u0005\u0005I\u0011IA&\u0011%\ti&GA\u0001\n\u0003\ty\u0006C\u0005\u0002he\t\t\u0011\"\u0001\u0003\u001c!I\u0011QO\r\u0002\u0002\u0013\u0005!q\u0004\u0005\n\u0003\u0003K\u0012\u0011!C!\u0005GA\u0011\"a\"\u001a\u0003\u0003%\t%!#\t\u0013\u0005-\u0015$!A\u0005B\u00055\u0005\"CAH3\u0005\u0005I\u0011\tB\u0014\u000f%\u0011Y#AA\u0001\u0012\u0003\u0011iCB\u0005\u0002R\u0006\t\t\u0011#\u0001\u00030!1\u0001\u000f\fC\u0001\u0005oA\u0011\"a#-\u0003\u0003%)%!$\t\u0013\u0005MF&!A\u0005\u0002\ne\u0002\"CA]Y\u0005\u0005I\u0011\u0011B \u0011%\t9\rLA\u0001\n\u0013\tIM\u0002\u0004\u0003L\u0005\u0001%Q\n\u0005\u000b\u0005\u001f\u0012$Q3A\u0005\u0002\tE\u0003B\u0003B-e\tE\t\u0015!\u0003\u0003T!1\u0001O\rC\u0001\u00057BqA!\u00193\t\u0003\u0011\u0019\u0007C\u0004\u0003~I\"\tAa \t\u0013\u0005-\"'!A\u0005\u0002\t\u0015\u0005\"CA\u0019eE\u0005I\u0011\u0001BE\u0011%\tIEMA\u0001\n\u0003\nY\u0005C\u0005\u0002^I\n\t\u0011\"\u0001\u0002`!I\u0011q\r\u001a\u0002\u0002\u0013\u0005!Q\u0012\u0005\n\u0003k\u0012\u0014\u0011!C\u0001\u0005#C\u0011\"!!3\u0003\u0003%\tE!&\t\u0013\u0005\u001d%'!A\u0005B\u0005%\u0005\"CAFe\u0005\u0005I\u0011IAG\u0011%\tyIMA\u0001\n\u0003\u0012IjB\u0005\u0003\u001e\u0006\t\t\u0011#\u0001\u0003 \u001aI!1J\u0001\u0002\u0002#\u0005!\u0011\u0015\u0005\u0007a\u000e#\tA!*\t\u0013\u0005-5)!A\u0005F\u00055\u0005\"CAZ\u0007\u0006\u0005I\u0011\u0011BT\u0011%\tIlQA\u0001\n\u0003\u0013Y\u000bC\u0005\u0002H\u000e\u000b\t\u0011\"\u0003\u0002J\u001a)\u0001n\u0017\u0001\u00032\"Q!1W%\u0003\u0002\u0003\u0006IA!.\t\u0015\t\u0005\u0017J!A!\u0002\u0013\u0011\u0019\r\u0003\u0006\u0003L&\u0013\t\u0011)A\u0005\u0005\u001bD!Ba5J\u0005\u0003\u0005\u000b\u0011\u0002Bk\u0011\u0019\u0001\u0018\n\"\u0001\u0003d\"91\u0011A%\u0005\u0002\r\r\u0001bBB\u0001\u0013\u0012%1Q\t\u0005\b\u0007OJE\u0011BB5\u0011\u001d\u00199*\u0013C\u0005\u00073Cqa!-J\t\u0013\u0019\u0019\fC\u0004\u0004n&#Iaa<\t\u000f\rm\u0018\n\"\u0003\u0004~\"9AqC%\u0005\n\u0011e\u0001b\u0002C\u0011\u0013\u0012%A1\u0005\u0005\b\tgIE\u0011\u0002C\u001b\u0011\u001d!9%\u0013C\u0005\t\u0013\nq#R7bS2\u001cV\r^+qI\u0006$X\rU3sM>\u0014X.\u001a:\u000b\u0005qk\u0016AB7fi\"|GM\u0003\u0002_?\u0006!!.\\1q\u0015\t\u0001\u0017-A\u0003kC6,7O\u0003\u0002cG\u00061\u0011\r]1dQ\u0016T\u0011\u0001Z\u0001\u0004_J<7\u0001\u0001\t\u0003O\u0006i\u0011a\u0017\u0002\u0018\u000b6\f\u0017\u000e\\*fiV\u0003H-\u0019;f!\u0016\u0014hm\u001c:nKJ\u001c\"!\u00016\u0011\u0005-tW\"\u00017\u000b\u00035\fQa]2bY\u0006L!a\u001c7\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\taMA\tF[\u0006LG.\u00169eCR,'+Z:vYR\u001c\"a\u00016\u0003%\u0015k\u0017-\u001b7Va\u0012\fG/Z*vG\u000e,7o]\n\u0006\t)4\bp\u001f\t\u0003o\u000ei\u0011!\u0001\t\u0003WfL!A\u001f7\u0003\u000fA\u0013x\u000eZ;diB\u0019A0!\u0003\u000f\u0007u\f)AD\u0002\u007f\u0003\u0007i\u0011a \u0006\u0004\u0003\u0003)\u0017A\u0002\u001fs_>$h(C\u0001n\u0013\r\t9\u0001\\\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY!!\u0004\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0007\u0005\u001dA.A\u0005nKN\u001c\u0018mZ3JIV\u0011\u00111\u0003\t\u0005\u0003+\ty\"\u0004\u0002\u0002\u0018)!\u0011\u0011DA\u000e\u0003\u0015iw\u000eZ3m\u0015\r\tibX\u0001\b[\u0006LGNY8y\u0013\u0011\t\t#a\u0006\u0003\u00135+7o]1hK&#\u0017AC7fgN\fw-Z%eAQ!\u0011qEA\u0015!\t9H\u0001C\u0004\u0002\u0010\u001d\u0001\r!a\u0005\u0002\t\r|\u0007/\u001f\u000b\u0005\u0003O\ty\u0003C\u0005\u0002\u0010!\u0001\n\u00111\u0001\u0002\u0014\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u001bU\u0011\t\u0019\"a\u000e,\u0005\u0005e\u0002\u0003BA\u001e\u0003\u000bj!!!\u0010\u000b\t\u0005}\u0012\u0011I\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0011m\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u000f\niDA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA'!\u0011\ty%!\u0017\u000e\u0005\u0005E#\u0002BA*\u0003+\nA\u0001\\1oO*\u0011\u0011qK\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\\\u0005E#AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002bA\u00191.a\u0019\n\u0007\u0005\u0015DNA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002l\u0005E\u0004cA6\u0002n%\u0019\u0011q\u000e7\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002t1\t\t\u00111\u0001\u0002b\u0005\u0019\u0001\u0010J\u0019\u0002\u0011\r\fg.R9vC2$B!!\u001f\u0002\u0000A\u00191.a\u001f\n\u0007\u0005uDNA\u0004C_>dW-\u00198\t\u0013\u0005MT\"!AA\u0002\u0005-\u0014A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!!\u0014\u0002\u0006\"I\u00111\u000f\b\u0002\u0002\u0003\u0007\u0011\u0011M\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011\u0011M\u0001\ti>\u001cFO]5oOR\u0011\u0011QJ\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005e\u00141\u0013\u0005\n\u0003g\n\u0012\u0011!a\u0001\u0003W\n!#R7bS2,\u0006\u000fZ1uKN+8mY3tgB\u0011qoE\n\u0006'\u0005m\u0015q\u0015\t\t\u0003;\u000b\u0019+a\u0005\u0002(5\u0011\u0011q\u0014\u0006\u0004\u0003Cc\u0017a\u0002:v]RLW.Z\u0005\u0005\u0003K\u000byJA\tBEN$(/Y2u\rVt7\r^5p]F\u0002B!!+\u000206\u0011\u00111\u0016\u0006\u0005\u0003[\u000b)&\u0001\u0002j_&!\u00111BAV)\t\t9*A\u0003baBd\u0017\u0010\u0006\u0003\u0002(\u0005]\u0006bBA\b-\u0001\u0007\u00111C\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\ti,a1\u0011\u000b-\fy,a\u0005\n\u0007\u0005\u0005GN\u0001\u0004PaRLwN\u001c\u0005\n\u0003\u000b<\u0012\u0011!a\u0001\u0003O\t1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\tY\r\u0005\u0003\u0002P\u00055\u0017\u0002BAh\u0003#\u0012aa\u00142kK\u000e$(AE#nC&dW\u000b\u001d3bi\u00164\u0015-\u001b7ve\u0016\u001cR!\u00076wqn\f\u0011#\u001e8qCJ\u001cX\rZ'fgN\fw-Z%e+\t\tI\u000e\u0005\u0003\u0002\\\u0006\u0005XBAAo\u0015\r\ty.X\u0001\u0005[\u0006LG.\u0003\u0003\u0002d\u0006u'!E+oa\u0006\u00148/\u001a3NKN\u001c\u0018mZ3JI\u0006\u0011RO\u001c9beN,G-T3tg\u0006<W-\u00133!\u0003\u0005)WCAAv!\ra\u0018Q^\u0005\u0005\u0003_\fiAA\u0005UQJ|w/\u00192mK\u0006\u0011Q\r\t\u000b\u0007\u0003k\f90!?\u0011\u0005]L\u0002bBAk=\u0001\u0007\u0011\u0011\u001c\u0005\b\u0003Ot\u0002\u0019AAv\u0003E\t7/T3tg\u0006<WmU3u\u000bJ\u0014xN]\u000b\u0003\u0003\u007f\u0004BA!\u0001\u0003\b5\u0011!1\u0001\u0006\u0004\u0005\u000bi\u0016\u0001B2pe\u0016LAA!\u0003\u0003\u0004\tA1+\u001a;FeJ|'\u000f\u0006\u0004\u0002v\n5!q\u0002\u0005\n\u0003+\u0004\u0003\u0013!a\u0001\u00033D\u0011\"a:!!\u0003\u0005\r!a;\u0016\u0005\tM!\u0006BAm\u0003o\tabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0003\u001a)\"\u00111^A\u001c)\u0011\tYG!\b\t\u0013\u0005MT%!AA\u0002\u0005\u0005D\u0003BA=\u0005CA\u0011\"a\u001d'\u0003\u0003\u0005\r!a\u001b\u0015\t\u00055#Q\u0005\u0005\n\u0003g:\u0013\u0011!a\u0001\u0003C\"B!!\u001f\u0003*!I\u00111\u000f\u0016\u0002\u0002\u0003\u0007\u00111N\u0001\u0013\u000b6\f\u0017\u000e\\+qI\u0006$XMR1jYV\u0014X\r\u0005\u0002xYM)AF!\r\u0002(BQ\u0011Q\u0014B\u001a\u00033\fY/!>\n\t\tU\u0012q\u0014\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014DC\u0001B\u0017)\u0019\t)Pa\u000f\u0003>!9\u0011Q[\u0018A\u0002\u0005e\u0007bBAt_\u0001\u0007\u00111\u001e\u000b\u0005\u0005\u0003\u0012I\u0005E\u0003l\u0003\u007f\u0013\u0019\u0005E\u0004l\u0005\u000b\nI.a;\n\u0007\t\u001dCN\u0001\u0004UkBdWM\r\u0005\n\u0003\u000b\u0004\u0014\u0011!a\u0001\u0003k\u0014!#R7bS2,\u0006\u000fZ1uKJ+7/\u001e7ugN!!G\u001b=|\u0003\u001d\u0011Xm];miN,\"Aa\u0015\u0011\tq\u0014)F^\u0005\u0005\u0005/\niAA\u0002TKF\f\u0001B]3tk2$8\u000f\t\u000b\u0005\u0005;\u0012y\u0006\u0005\u0002xe!9!qJ\u001bA\u0002\tM\u0013aB;qI\u0006$X\rZ\u000b\u0003\u0005K\u0002Ra[A`\u0005O\u0002\u0002B!\u001b\u0003r\u0005M!q\u000f\b\u0005\u0005W\u0012i\u0007\u0005\u0002\u007fY&\u0019!q\u000e7\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011\u0019H!\u001e\u0003\u00075\u000b\u0007OC\u0002\u0003p1\u00042a\u001bB=\u0013\r\u0011Y\b\u001c\u0002\u0005+:LG/\u0001\u0006o_R,\u0006\u000fZ1uK\u0012,\"A!!\u0011\u000b-\fyLa!\u0011\u0011\t%$\u0011OAm\u0003\u007f$BA!\u0018\u0003\b\"I!q\n\u001d\u0011\u0002\u0003\u0007!1K\u000b\u0003\u0005\u0017SCAa\u0015\u00028Q!\u00111\u000eBH\u0011%\t\u0019\bPA\u0001\u0002\u0004\t\t\u0007\u0006\u0003\u0002z\tM\u0005\"CA:{\u0005\u0005\t\u0019AA6)\u0011\tiEa&\t\u0013\u0005Md(!AA\u0002\u0005\u0005D\u0003BA=\u00057C\u0011\"a\u001dB\u0003\u0003\u0005\r!a\u001b\u0002%\u0015k\u0017-\u001b7Va\u0012\fG/\u001a*fgVdGo\u001d\t\u0003o\u000e\u001bRa\u0011BR\u0003O\u0003\u0002\"!(\u0002$\nM#Q\f\u000b\u0003\u0005?#BA!\u0018\u0003*\"9!q\n$A\u0002\tMC\u0003\u0002BW\u0005_\u0003Ra[A`\u0005'B\u0011\"!2H\u0003\u0003\u0005\rA!\u0018\u0014\u0005%S\u0017AC:fe&\fG.\u001b>feB!!q\u0017B_\u001b\t\u0011ILC\u0002\u0003<v\u000bAA[:p]&!!q\u0018B]\u0005I)U.Y5m'\u0016$8+\u001a:jC2L'0\u001a:\u0002!5,7o]1hK&#W*\u00198bO\u0016\u0014\b\u0003\u0002Bc\u0005\u000fl!!a\u0007\n\t\t%\u00171\u0004\u0002\u0011\u001b\u0016\u001c8/Y4f\u0013\u0012l\u0015M\\1hKJ\fa\"\\1jY\n|\u00070T1oC\u001e,'\u000f\u0005\u0003\u0003F\n=\u0017\u0002\u0002Bi\u00037\u0011a\"T1jY\n|\u00070T1oC\u001e,'/\u0001\tnKN\u001c\u0018mZ3JI\u001a\u000b7\r^8ssB!!q\u001bBo\u001d\u0011\t)B!7\n\t\tm\u0017qC\u0001\n\u001b\u0016\u001c8/Y4f\u0013\u0012LAAa8\u0003b\n9a)Y2u_JL(\u0002\u0002Bn\u0003/!\"B!:\u0003h\n%(1\u001eBw!\t9\u0017\nC\u0004\u00034:\u0003\rA!.\t\u000f\t\u0005g\n1\u0001\u0003D\"9!1\u001a(A\u0002\t5\u0007b\u0002Bj\u001d\u0002\u0007!Q\u001b\u0015\u0004\u001d\nE\b\u0003\u0002Bz\u0005{l!A!>\u000b\t\t](\u0011`\u0001\u0007S:TWm\u0019;\u000b\u0005\tm\u0018!\u00026bm\u0006D\u0018\u0002\u0002B\u0000\u0005k\u0014a!\u00138kK\u000e$\u0018AB;qI\u0006$X\r\u0006\u0004\u0004\u0006\rE21\b\t\u0007\u0007\u000f\u0019)b!\u0007\u000e\u0005\r%!\u0002BB\u0006\u0007\u001b\t\u0011\u0002];cY&\u001c\b.\u001a:\u000b\u00075\u001cyA\u0003\u0003\u0003\u0006\rE!BAB\n\u0003\u001d\u0011X-Y2u_JLAaa\u0006\u0004\n\t)1+T8o_B\u001911\u0004\u001a\u000f\u0007\ru\u0001A\u0004\u0003\u0004 \r=b\u0002BB\u0011\u0007[qAaa\t\u0004,9!1QEB\u0015\u001d\rq8qE\u0005\u0002I&\u0011!mY\u0005\u0003A\u0006L!AX0\n\u0005qk\u0006bBB\u001a\u001f\u0002\u00071QG\u0001\u0010K6\f\u0017\u000e\\*fiJ+\u0017/^3tiB!\u00111\\B\u001c\u0013\u0011\u0019I$!8\u0003\u001f\u0015k\u0017-\u001b7TKR\u0014V-];fgRDqa!\u0010P\u0001\u0004\u0019y$\u0001\bnC&d'm\u001c=TKN\u001c\u0018n\u001c8\u0011\t\t\u00157\u0011I\u0005\u0005\u0007\u0007\nYB\u0001\bNC&d'm\u001c=TKN\u001c\u0018n\u001c8\u0015\r\r\u00151qIB2\u0011\u001d\u0019I\u0005\u0015a\u0001\u0007\u0017\nq!\u001e9eCR,7\u000f\u0005\u0005\u0003j\tE\u0014\u0011\\B'!\u0011\u0019yea\u0018\u000e\u0005\rE#\u0002\u0002B^\u0007'RAa!\u0016\u0004X\u0005!A.\u001b2t\u0015\u0011\u0019Ifa\u0017\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u0004^\u0005!\u0001\u000f\\1z\u0013\u0011\u0019\tg!\u0015\u0003\u0011)\u001bxJ\u00196fGRDqa!\u001aQ\u0001\u0004\u0019y$A\u0004tKN\u001c\u0018n\u001c8\u0002\u0011\u0011|W\u000b\u001d3bi\u0016$\u0002ba\u001b\u0004r\r\r5Q\u0013\t\u0007\u0007\u000f\u0019)b!\u001c\u0011\u000bq\u0014)fa\u001c\u0011\u0007\rm1\u0001C\u0004\u0004tE\u0003\ra!\u001e\u0002\u0019Y\fG.\u001b3Va\u0012\fG/Z:\u0011\u000bq\u001c9ha\u001f\n\t\re\u0014Q\u0002\u0002\u0005\u0019&\u001cH\u000fE\u0004l\u0005\u000b\n\u0019b! \u0011\t\u0005m7qP\u0005\u0005\u0007\u0003\u000biNA\fWC2LG-\u0019;fI\u0016k\u0017-\u001b7TKR,\u0006\u000fZ1uK\"91QQ)A\u0002\r\u001d\u0015\u0001C7fi\u0006$\u0015\r^1\u0011\u0011\t%$\u0011OA\n\u0007\u0013\u0003R\u0001`BF\u0007\u001fKAa!$\u0002\u000e\tYAK]1wKJ\u001c\u0018M\u00197f!\u0011\t)b!%\n\t\rM\u0015q\u0003\u0002\u001e\u0007>l\u0007o\\:fI6+7o]1hK&#w+\u001b;i\u001b\u0016$\u0018\rR1uC\"91QM)A\u0002\r}\u0012\u0001C1t%\u0006tw-Z:\u0015\t\rm5q\u0016\t\u0007\u0007;\u001b9k!+\u000e\u0005\r}%\u0002BBQ\u0007G\u000b\u0011\"[7nkR\f'\r\\3\u000b\u0007\r\u0015F.\u0001\u0006d_2dWm\u0019;j_:LAa!\u001f\u0004 B!\u0011QCBV\u0013\u0011\u0019i+a\u0006\u0003\u00195+7o]1hKJ\u000bgnZ3\t\u000f\r\u0015%\u000b1\u0001\u0004\b\u0006\u0011R\u000f\u001d3bi\u00164E.Y4t\u0005f\u0014\u0016M\\4f)9\u0019Yg!.\u0004@\u000e571[Bk\u0007WDqaa.T\u0001\u0004\u0019I,A\u0005nC&d'm\u001c=JIB!\u0011QCB^\u0013\u0011\u0019i,a\u0006\u0003\u00135\u000b\u0017\u000e\u001c2pq&#\u0007bBBa'\u0002\u000711Y\u0001\u0006M2\fwm\u001d\t\u0005\u0007\u000b\u001cI-\u0004\u0002\u0004H*!\u0011q\u001cB}\u0013\u0011\u0019Yma2\u0003\u000b\u0019c\u0017mZ:\t\u000f\r=7\u000b1\u0001\u0004R\u00061!/\u00198hKN\u0004R\u0001`B<\u0007SCqa!\"T\u0001\u0004\u00199\tC\u0004\u0004XN\u0003\ra!7\u0002\u0015U\u0004H-\u0019;f\u001b>$W\r\u0005\u0003\u0004\\\u000e\u0015h\u0002BBo\u0007CtAa!\t\u0004`&\u0019\u0011QD0\n\t\r\r\u00181D\u0001\u000f\u001b\u0016\u001c8/Y4f\u001b\u0006t\u0017mZ3s\u0013\u0011\u00199o!;\u0003\u001f\u0019c\u0017mZ:Va\u0012\fG/Z'pI\u0016TAaa9\u0002\u001c!91QM*A\u0002\r}\u0012aC7pm\u0016\u0014\u0015PU1oO\u0016$Bba\u001b\u0004r\u000eM8Q_B|\u0007sDqaa.U\u0001\u0004\u0019I\fC\u0004\u0004\u0002Q\u0003\ra! \t\u000f\r=G\u000b1\u0001\u0004R\"91Q\u0011+A\u0002\r\u001d\u0005bBB3)\u0002\u00071qH\u0001\u000ekB$\u0017\r^3CsJ\u000bgnZ3\u0015\u0011\r-4q C\u0001\t\u0007Aqaa4V\u0001\u0004\u0019\t\u000eC\u0004\u0004\u0006V\u0003\raa\"\t\u000f\u0011\u0015Q\u000b1\u0001\u0005\b\u0005Iq\u000e]3sCRLwN\u001c\t\u0007\t\u0013!\u0019b!+\u000e\u0005\u0011-!\u0002\u0002C\u0007\t\u001f\t\u0001BZ;oGRLwN\u001c\u0006\u0005\t#\t)&\u0001\u0003vi&d\u0017\u0002\u0002C\u000b\t\u0017\u0011\u0001bQ8ogVlWM]\u0001\u0012kB$\u0017\r^3FC\u000eDW*Z:tC\u001e,G\u0003CB6\t7!i\u0002b\b\t\u000f\rMd\u000b1\u0001\u0004v!91Q\u0011,A\u0002\r\u001d\u0005bBB3-\u0002\u00071qH\u0001\u0014kB$\u0017\r^3TS:<G.Z'fgN\fw-\u001a\u000b\u000b\tK!9\u0003\"\u000b\u0005,\u0011E\u0002CBB\u0004\u0007+\u0019y\u0007C\u0004\u0002\u0010]\u0003\r!a\u0005\t\u000f\r\u0005q\u000b1\u0001\u0004~!9AQF,A\u0002\u0011=\u0012AD:u_J,G-T3uC\u0012\u000bG/\u0019\t\u0006y\u000e]4q\u0012\u0005\b\u0007K:\u0006\u0019AB \u0003A)\b\u000fZ1uK6\u000b\u0017\u000e\u001c2pq&#7\u000f\u0006\u0006\u0005&\u0011]B\u0011\bC\u001e\t\u000bBq!a\u0004Y\u0001\u0004\t\u0019\u0002C\u0004\u0004\u0002a\u0003\ra! \t\u000f\u0011u\u0002\f1\u0001\u0005@\u0005QQ.Y5mE>D\u0018\nZ:\u0011\t\u0005mG\u0011I\u0005\u0005\t\u0007\niN\u0001\u0006NC&d'm\u001c=JINDqa!\u001aY\u0001\u0004\u0019y$A\u0006va\u0012\fG/\u001a$mC\u001e\u001cH\u0003\u0004C\u0013\t\u0017\"i\u0005b\u0014\u0005R\u0011U\u0003bBA\b3\u0002\u0007\u00111\u0003\u0005\b\u0007\u0003I\u0006\u0019AB?\u0011\u001d!i$\u0017a\u0001\t\u007fAq\u0001b\u0015Z\u0001\u0004\u0019\u0019-A\u0007pe&<\u0017N\\1m\r2\fwm\u001d\u0005\b\u0007KJ\u0006\u0019AB \u0001")
public class EmailSetUpdatePerformer {
    private final EmailSetSerializer serializer;
    private final MessageIdManager messageIdManager;
    private final MailboxManager mailboxManager;
    private final MessageId.Factory messageIdFactory;

    public SMono<EmailUpdateResults> update(EmailSetRequest emailSetRequest, MailboxSession mailboxSession) {
        return (SMono)emailSetRequest.update().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.nonEmpty())).map((Function1 & Serializable)x$4 -> this.update((Map<UnparsedMessageId, JsObject>)x$4, mailboxSession)).getOrElse((Function0 & Serializable)() -> SMono$.MODULE$.just((Object)new EmailUpdateResults((scala.collection.immutable.Seq<EmailUpdateResult>)((scala.collection.immutable.Seq)Nil$.MODULE$))));
    }

    private SMono<EmailUpdateResults> update(Map<UnparsedMessageId, JsObject> updates2, MailboxSession session) {
        List validatedUpdates = ((IterableOnceOps)updates2.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                UnparsedMessageId unparsedMessageId = (UnparsedMessageId)tuple2._1();
                JsObject json = (JsObject)tuple2._2();
                return EmailSet$.MODULE$.parse($this.messageIdFactory, unparsedMessageId).toEither().left().map((Function1 & Serializable)e -> new EmailUpdateFailure(unparsedMessageId, (Throwable)e)).flatMap((Function1 & Serializable)id -> (Either)$this.serializer.deserializeEmailSetUpdate((JsValue)json).asEither().left().map((Function1 & Serializable)e -> new IllegalArgumentException(e.toString())).flatMap((Function1 & Serializable)x$5 -> x$5.validate()).fold((Function1 & Serializable)e -> package$.MODULE$.Left().apply((Object)new EmailUpdateFailure(unparsedMessageId, (Throwable)e)), (Function1 & Serializable)emailSetUpdate -> package$.MODULE$.Right().apply((Object)new Tuple2(id, emailSetUpdate))));
            }
            throw new MatchError((Object)tuple2);
        })).toList();
        List failures = validatedUpdates.flatMap((Function1 & Serializable)x0$2 -> {
            Either either = x0$2;
            if (either instanceof Left) {
                Left left = (Left)either;
                EmailUpdateFailure e = (EmailUpdateFailure)left.value();
                return new Some((Object)e);
            }
            return None$.MODULE$;
        });
        List validUpdates = validatedUpdates.flatMap((Function1 & Serializable)x0$3 -> {
            Either either = x0$3;
            if (either instanceof Right) {
                Right right = (Right)either;
                Tuple2 pair = (Tuple2)right.value();
                return new Some((Object)pair);
            }
            return None$.MODULE$;
        });
        return SFlux$.MODULE$.fromPublisher(this.messageIdManager.messagesMetadata(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)validUpdates.map((Function1 & Serializable)x$6 -> (MessageId)x$6._1())).asJavaCollection(), session)).collectMultimap((Function1 & Serializable)metaData -> metaData.getComposedMessageId().getMessageId()).flatMap((Function1 & Serializable)x$7 -> this.doUpdate((List<Tuple2<MessageId, ValidatedEmailSetUpdate>>)validUpdates, (Map<MessageId, Iterable<ComposedMessageIdWithMetaData>>)x$7, session)).map((Function1 & Serializable)updates -> new EmailUpdateResults((scala.collection.immutable.Seq<EmailUpdateResult>)((scala.collection.immutable.Seq)updates.$plus$plus((IterableOnce)failures))));
    }

    private SMono<scala.collection.immutable.Seq<EmailUpdateResult>> doUpdate(List<Tuple2<MessageId, ValidatedEmailSetUpdate>> validUpdates, Map<MessageId, Iterable<ComposedMessageIdWithMetaData>> metaData, MailboxSession session) {
        boolean singleMailbox;
        boolean sameUpdate = ((SeqOps)validUpdates.map((Function1 & Serializable)x$8 -> (ValidatedEmailSetUpdate)x$8._2()).distinctBy((Function1 & Serializable)x$9 -> x$9.update())).size() == 1;
        boolean bl = singleMailbox = ((IterableOnceOps)((IterableOps)metaData.values().flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)x$10 -> x$10.getComposedMessageId().getMailboxId())).toSet().size() == 1;
        if (sameUpdate && singleMailbox && validUpdates.size() > 3) {
            ValidatedEmailSetUpdate update = (ValidatedEmailSetUpdate)validUpdates.map((Function1 & Serializable)x$11 -> (ValidatedEmailSetUpdate)x$11._2()).headOption().get();
            List<MessageRange> ranges = this.asRanges(metaData);
            MailboxId mailboxId = (MailboxId)((IterableOps)((IterableOps)metaData.values().flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)x$12 -> x$12.getComposedMessageId().getMailboxId())).headOption().get();
            if (update.update().isOnlyFlagAddition()) {
                return this.updateFlagsByRange(mailboxId, ((Keywords)update.update().keywordsToAdd().get()).asFlags(), ranges, metaData, MessageManager.FlagsUpdateMode.ADD, session);
            }
            if (update.update().isOnlyFlagRemoval()) {
                return this.updateFlagsByRange(mailboxId, ((Keywords)update.update().keywordsToRemove().get()).asFlags(), ranges, metaData, MessageManager.FlagsUpdateMode.REMOVE, session);
            }
            if (update.update().isOnlyMove()) {
                return this.moveByRange(mailboxId, update, ranges, metaData, session);
            }
            return this.updateEachMessage(validUpdates, metaData, session);
        }
        return this.updateEachMessage(validUpdates, metaData, session);
    }

    private List<MessageRange> asRanges(Map<MessageId, Iterable<ComposedMessageIdWithMetaData>> metaData) {
        return CollectionConverters$.MODULE$.ListHasAsScala(MessageRange.toRanges((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)((IterableOps)metaData.values().flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)x$13 -> x$13.getComposedMessageId().getUid())).toList().distinct()).asJava())).asScala().toList();
    }

    private SMono<scala.collection.immutable.Seq<EmailUpdateResult>> updateFlagsByRange(MailboxId mailboxId, Flags flags, List<MessageRange> ranges, Map<MessageId, Iterable<ComposedMessageIdWithMetaData>> metaData, MessageManager.FlagsUpdateMode updateMode, MailboxSession session) {
        SMono mailboxMono = SMono$.MODULE$.fromCallable(() -> $this.mailboxManager.getMailbox(mailboxId, session));
        return mailboxMono.flatMap((Function1 & Serializable)mailbox -> this.updateByRange(ranges, metaData, range -> mailbox.setFlags(flags, updateMode, range, session))).subscribeOn(Schedulers.elastic());
    }

    private SMono<scala.collection.immutable.Seq<EmailUpdateResult>> moveByRange(MailboxId mailboxId, ValidatedEmailSetUpdate update, List<MessageRange> ranges, Map<MessageId, Iterable<ComposedMessageIdWithMetaData>> metaData, MailboxSession session) {
        MailboxId targetId = (MailboxId)((MailboxIds)update.update().mailboxIds().get()).value().headOption().get();
        return this.updateByRange(ranges, metaData, range -> $this.mailboxManager.moveMessages(range, mailboxId, targetId, session));
    }

    private SMono<scala.collection.immutable.Seq<EmailUpdateResult>> updateByRange(List<MessageRange> ranges, Map<MessageId, Iterable<ComposedMessageIdWithMetaData>> metaData, Consumer<MessageRange> operation) {
        SFlux qual$1 = SFlux$.MODULE$.fromIterable(ranges);
        Function1 & Serializable x$1 = (Function1 & Serializable)range -> {
            scala.collection.immutable.Seq messageIds = ((MapOps)metaData.filter((Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)EmailSetUpdatePerformer.$anonfun$updateByRange$2(range, entry)))).keys().toSeq();
            return SMono$.MODULE$.fromCallable(() -> {
                operation.accept((MessageRange)range);
                return (scala.collection.immutable.Seq)messageIds.map((Function1)EmailSetUpdatePerformer$EmailUpdateSuccess$.MODULE$);
            }).onErrorResume((Function1 & Serializable)e -> SMono$.MODULE$.just(messageIds.map((Function1 & Serializable)id -> new EmailUpdateFailure(EmailSet$.MODULE$.asUnparsed((MessageId)id), (Throwable)e)))).subscribeOn(Schedulers.elastic());
        };
        int x$2 = qual$1.concatMap$default$2();
        return qual$1.concatMap((Function1)x$1, x$2).reduce((Object)Nil$.MODULE$, (Function2 & Serializable)(x$14, x$15) -> (scala.collection.immutable.Seq)x$14.$plus$plus((IterableOnce)x$15));
    }

    private SMono<scala.collection.immutable.Seq<EmailUpdateResult>> updateEachMessage(List<Tuple2<MessageId, ValidatedEmailSetUpdate>> validUpdates, Map<MessageId, Iterable<ComposedMessageIdWithMetaData>> metaData, MailboxSession session) {
        SFlux qual$1 = SFlux$.MODULE$.fromIterable(validUpdates);
        Function1 & Serializable x$1 = (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                MessageId messageId = (MessageId)tuple2._1();
                ValidatedEmailSetUpdate updatePatch = (ValidatedEmailSetUpdate)tuple2._2();
                return this.updateSingleMessage(messageId, updatePatch, (List<ComposedMessageIdWithMetaData>)((List)metaData.get((Object)messageId).toList().flatten(Predef$.MODULE$.$conforms())), session);
            }
            throw new MatchError((Object)tuple2);
        };
        int x$2 = qual$1.concatMap$default$2();
        return qual$1.concatMap((Function1)x$1, x$2).collectSeq();
    }

    private SMono<EmailUpdateResult> updateSingleMessage(MessageId messageId, ValidatedEmailSetUpdate update, List<ComposedMessageIdWithMetaData> storedMetaData, MailboxSession session) {
        MailboxIds mailboxIds = new MailboxIds((List<MailboxId>)storedMetaData.map((Function1 & Serializable)metaData -> metaData.getComposedMessageId().getMailboxId()));
        Flags originFlags = (Flags)storedMetaData.foldLeft((Object)new Flags(), (Function2 & Serializable)(flags, m) -> {
            flags.add(m.getFlags());
            return flags;
        });
        if (mailboxIds.value().isEmpty()) {
            return SMono$.MODULE$.just((Object)new EmailUpdateFailure(EmailSet$.MODULE$.asUnparsed(messageId), new MessageNotFoundException(messageId)));
        }
        return this.updateFlags(messageId, update, mailboxIds, originFlags, session).flatMap((Function1 & Serializable)x0$1 -> {
            EmailUpdateResult emailUpdateResult = x0$1;
            if (emailUpdateResult instanceof EmailUpdateFailure) {
                EmailUpdateFailure emailUpdateFailure = (EmailUpdateFailure)emailUpdateResult;
                return SMono$.MODULE$.just((Object)emailUpdateFailure);
            }
            if (emailUpdateResult instanceof EmailUpdateSuccess) {
                return this.updateMailboxIds(messageId, update, mailboxIds, session);
            }
            throw new MatchError((Object)emailUpdateResult);
        }).onErrorResume((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)new EmailUpdateFailure(EmailSet$.MODULE$.asUnparsed(messageId), (Throwable)e))).switchIfEmpty(SMono$.MODULE$.just((Object)new EmailUpdateSuccess(messageId)));
    }

    private SMono<EmailUpdateResult> updateMailboxIds(MessageId messageId, ValidatedEmailSetUpdate update, MailboxIds mailboxIds, MailboxSession session) {
        MailboxIds targetIds = (MailboxIds)update.mailboxIdsTransformation().apply((Object)mailboxIds);
        if (targetIds.equals(mailboxIds)) {
            return SMono$.MODULE$.just((Object)new EmailUpdateSuccess(messageId));
        }
        return SMono$.MODULE$.apply(this.messageIdManager.setInMailboxesReactive(messageId, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava(targetIds.value()).asJava(), session)).then(SMono$.MODULE$.just((Object)new EmailUpdateSuccess(messageId))).onErrorResume((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)new EmailUpdateFailure(EmailSet$.MODULE$.asUnparsed(messageId), (Throwable)e))).switchIfEmpty(SMono$.MODULE$.just((Object)new EmailUpdateSuccess(messageId))).subscribeOn(Schedulers.elastic());
    }

    private SMono<EmailUpdateResult> updateFlags(MessageId messageId, ValidatedEmailSetUpdate update, MailboxIds mailboxIds, Flags originalFlags, MailboxSession session) {
        Flags newFlags = ((Keywords)update.keywordsTransformation().apply(KeywordsFactory$.MODULE$.LENIENT_KEYWORDS_FACTORY().fromFlags(originalFlags).get())).asFlagsWithRecentAndDeletedFrom(originalFlags);
        if (newFlags.equals((Object)originalFlags)) {
            return SMono$.MODULE$.just((Object)new EmailUpdateSuccess(messageId));
        }
        return SMono$.MODULE$.apply(this.messageIdManager.setFlagsReactive(newFlags, MessageManager.FlagsUpdateMode.REPLACE, messageId, (java.util.List)ImmutableList.copyOf((Collection)CollectionConverters$.MODULE$.IterableHasAsJava(mailboxIds.value()).asJavaCollection()), session)).then(SMono$.MODULE$.just((Object)new EmailUpdateSuccess(messageId))).subscribeOn(Schedulers.elastic());
    }

    public static final /* synthetic */ boolean $anonfun$updateByRange$2(MessageRange range$1, Tuple2 entry) {
        return ((IterableOnceOps)entry._2()).exists((Function1 & Serializable)composedId -> BoxesRunTime.boxToBoolean((boolean)range$1.includes(composedId.getComposedMessageId().getUid())));
    }

    @Inject
    public EmailSetUpdatePerformer(EmailSetSerializer serializer, MessageIdManager messageIdManager, MailboxManager mailboxManager, MessageId.Factory messageIdFactory) {
        this.serializer = serializer;
        this.messageIdManager = messageIdManager;
        this.mailboxManager = mailboxManager;
        this.messageIdFactory = messageIdFactory;
    }

    public static class EmailUpdateFailure
    implements EmailUpdateResult,
    Product,
    Serializable {
        private final UnparsedMessageId unparsedMessageId;
        private final Throwable e;

        public Iterator<Object> productIterator() {
            return Product.productIterator$((Product)this);
        }

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public UnparsedMessageId unparsedMessageId() {
            return this.unparsedMessageId;
        }

        public Throwable e() {
            return this.e;
        }

        public SetError asMessageSetError() {
            Throwable throwable = this.e();
            if (throwable instanceof IllegalArgumentException) {
                IllegalArgumentException illegalArgumentException = (IllegalArgumentException)throwable;
                return SetError$.MODULE$.invalidPatch(new StringBuilder(27).append("Message update is invalid: ").append(illegalArgumentException.getMessage()).toString());
            }
            if (throwable instanceof MailboxNotFoundException) {
                return SetError$.MODULE$.notFound("Mailbox not found");
            }
            if (throwable instanceof MessageNotFoundException) {
                MessageNotFoundException messageNotFoundException = (MessageNotFoundException)throwable;
                return SetError$.MODULE$.notFound(new StringBuilder(36).append("Cannot find message with messageId: ").append(messageNotFoundException.messageId().serialize()).toString());
            }
            if (throwable instanceof OverQuotaException) {
                OverQuotaException overQuotaException = (OverQuotaException)throwable;
                return SetError$.MODULE$.overQuota(overQuotaException.getMessage());
            }
            return SetError$.MODULE$.serverFail(this.e().getMessage());
        }

        public EmailUpdateFailure copy(UnparsedMessageId unparsedMessageId, Throwable e) {
            return new EmailUpdateFailure(unparsedMessageId, e);
        }

        public UnparsedMessageId copy$default$1() {
            return this.unparsedMessageId();
        }

        public Throwable copy$default$2() {
            return this.e();
        }

        public String productPrefix() {
            return "EmailUpdateFailure";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.unparsedMessageId();
                }
                case 1: {
                    return this.e();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof EmailUpdateFailure;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "unparsedMessageId";
                }
                case 1: {
                    return "e";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof EmailUpdateFailure)) return false;
            boolean bl = true;
            if (!bl) return false;
            EmailUpdateFailure emailUpdateFailure = (EmailUpdateFailure)x$1;
            UnparsedMessageId unparsedMessageId = this.unparsedMessageId();
            UnparsedMessageId unparsedMessageId2 = emailUpdateFailure.unparsedMessageId();
            if (unparsedMessageId == null) {
                if (unparsedMessageId2 != null) {
                    return false;
                }
            } else if (!((Object)unparsedMessageId).equals(unparsedMessageId2)) return false;
            Throwable throwable = this.e();
            Throwable throwable2 = emailUpdateFailure.e();
            if (throwable == null) {
                if (throwable2 != null) {
                    return false;
                }
            } else if (!throwable.equals(throwable2)) return false;
            if (!emailUpdateFailure.canEqual(this)) return false;
            return true;
        }

        public EmailUpdateFailure(UnparsedMessageId unparsedMessageId, Throwable e) {
            this.unparsedMessageId = unparsedMessageId;
            this.e = e;
            Product.$init$((Product)this);
        }
    }

    public static interface EmailUpdateResult {
    }

    public static class EmailUpdateResults
    implements Product,
    Serializable {
        private final scala.collection.immutable.Seq<EmailUpdateResult> results;

        public Iterator<Object> productIterator() {
            return Product.productIterator$((Product)this);
        }

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public scala.collection.immutable.Seq<EmailUpdateResult> results() {
            return this.results;
        }

        public Option<Map<MessageId, BoxedUnit>> updated() {
            return Option$.MODULE$.apply((Object)((IterableOnceOps)this.results().flatMap((Function1 & Serializable)x0$1 -> {
                EmailUpdateResult emailUpdateResult = x0$1;
                if (emailUpdateResult instanceof EmailUpdateSuccess) {
                    EmailUpdateSuccess emailUpdateSuccess = (EmailUpdateSuccess)emailUpdateResult;
                    return new Some((Object)new Tuple2((Object)emailUpdateSuccess.messageId(), (Object)BoxedUnit.UNIT));
                }
                return None$.MODULE$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.nonEmpty()));
        }

        public Option<Map<UnparsedMessageId, SetError>> notUpdated() {
            return Option$.MODULE$.apply((Object)((IterableOnceOps)this.results().flatMap((Function1 & Serializable)x0$1 -> {
                EmailUpdateResult emailUpdateResult = x0$1;
                if (emailUpdateResult instanceof EmailUpdateFailure) {
                    EmailUpdateFailure emailUpdateFailure = (EmailUpdateFailure)emailUpdateResult;
                    return new Some((Object)new Tuple2((Object)emailUpdateFailure.unparsedMessageId(), (Object)emailUpdateFailure.asMessageSetError()));
                }
                return None$.MODULE$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.nonEmpty()));
        }

        public EmailUpdateResults copy(scala.collection.immutable.Seq<EmailUpdateResult> results) {
            return new EmailUpdateResults(results);
        }

        public scala.collection.immutable.Seq<EmailUpdateResult> copy$default$1() {
            return this.results();
        }

        public String productPrefix() {
            return "EmailUpdateResults";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.results();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof EmailUpdateResults;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "results";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof EmailUpdateResults)) return false;
            boolean bl = true;
            if (!bl) return false;
            EmailUpdateResults emailUpdateResults = (EmailUpdateResults)x$1;
            scala.collection.immutable.Seq<EmailUpdateResult> seq = this.results();
            scala.collection.immutable.Seq<EmailUpdateResult> seq2 = emailUpdateResults.results();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!emailUpdateResults.canEqual(this)) return false;
            return true;
        }

        public EmailUpdateResults(scala.collection.immutable.Seq<EmailUpdateResult> results) {
            this.results = results;
            Product.$init$((Product)this);
        }
    }

    public static class EmailUpdateSuccess
    implements EmailUpdateResult,
    Product,
    Serializable {
        private final MessageId messageId;

        public Iterator<Object> productIterator() {
            return Product.productIterator$((Product)this);
        }

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public MessageId messageId() {
            return this.messageId;
        }

        public EmailUpdateSuccess copy(MessageId messageId) {
            return new EmailUpdateSuccess(messageId);
        }

        public MessageId copy$default$1() {
            return this.messageId();
        }

        public String productPrefix() {
            return "EmailUpdateSuccess";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.messageId();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof EmailUpdateSuccess;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "messageId";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof EmailUpdateSuccess)) return false;
            boolean bl = true;
            if (!bl) return false;
            EmailUpdateSuccess emailUpdateSuccess = (EmailUpdateSuccess)x$1;
            MessageId messageId = this.messageId();
            MessageId messageId2 = emailUpdateSuccess.messageId();
            if (messageId == null) {
                if (messageId2 != null) {
                    return false;
                }
            } else if (!messageId.equals(messageId2)) return false;
            if (!emailUpdateSuccess.canEqual(this)) return false;
            return true;
        }

        public EmailUpdateSuccess(MessageId messageId) {
            this.messageId = messageId;
            Product.$init$((Product)this);
        }
    }
}

