/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.commons.shaded.johnzon.core;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.activemq.artemis.commons.shaded.johnzon.core.BufferStrategy;
import org.apache.activemq.artemis.commons.shaded.johnzon.core.HStack;
import org.apache.activemq.artemis.commons.shaded.johnzon.core.JsonChars;
import org.apache.activemq.artemis.commons.shaded.json.JsonArray;
import org.apache.activemq.artemis.commons.shaded.json.JsonException;
import org.apache.activemq.artemis.commons.shaded.json.JsonNumber;
import org.apache.activemq.artemis.commons.shaded.json.JsonObject;
import org.apache.activemq.artemis.commons.shaded.json.JsonString;
import org.apache.activemq.artemis.commons.shaded.json.JsonValue;
import org.apache.activemq.artemis.commons.shaded.json.stream.JsonGenerationException;
import org.apache.activemq.artemis.commons.shaded.json.stream.JsonGenerator;

class JsonGeneratorImpl
implements JsonGenerator,
JsonChars,
Serializable {
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private final transient Writer writer;
    private final BufferStrategy.BufferProvider<char[]> bufferProvider;
    private final char[] buffer;
    private int bufferPos = 0;
    private final boolean prettyPrint;
    private static final String INDENT = "  ";
    private int depth = 0;
    private final HStack<GeneratorState> state = new HStack();
    private static final String UNICODE_PREFIX = "\\u";
    private static final String UNICODE_PREFIX_HELPER = "000";

    JsonGeneratorImpl(Writer writer, BufferStrategy.BufferProvider<char[]> bufferProvider, ConcurrentMap<String, String> cache, boolean prettyPrint) {
        this.writer = writer;
        this.buffer = bufferProvider.newBuffer();
        this.bufferProvider = bufferProvider;
        this.prettyPrint = prettyPrint;
        this.state.push(GeneratorState.INITIAL);
    }

    JsonGeneratorImpl(OutputStream out, BufferStrategy.BufferProvider<char[]> bufferProvider, ConcurrentMap<String, String> cache, boolean prettyPrint) {
        this(new OutputStreamWriter(out, UTF8_CHARSET), bufferProvider, cache, prettyPrint);
    }

    JsonGeneratorImpl(OutputStream out, Charset encoding, BufferStrategy.BufferProvider<char[]> bufferProvider, ConcurrentMap<String, String> cache, boolean prettyPrint) {
        this(new OutputStreamWriter(out, encoding), bufferProvider, cache, prettyPrint);
    }

    private void writeEol() {
        if (this.prettyPrint) {
            this.justWrite('\n');
        }
    }

    private void writeIndent() {
        if (this.prettyPrint && this.depth > 0) {
            for (int i = 0; i < this.depth; ++i) {
                this.justWrite(INDENT);
            }
        }
    }

    private void writeCachedKey(String name) {
        this.justWrite('\"');
        this.writeEscaped0(name);
        this.justWrite('\"');
        this.justWrite(':');
    }

    @Override
    public JsonGenerator writeStartObject() {
        this.prepareValue();
        this.state.push(GeneratorState.START_OBJECT);
        this.writeIndent();
        ++this.depth;
        this.justWrite('{');
        this.writeEol();
        return this;
    }

    @Override
    public JsonGenerator writeStartObject(String name) {
        this.checkObject(false);
        this.writeKey(name);
        this.justWrite('{');
        this.writeEol();
        this.state.push(GeneratorState.START_OBJECT);
        ++this.depth;
        return this;
    }

    @Override
    public JsonGenerator writeStartArray() {
        this.prepareValue();
        this.writeIndent();
        this.state.push(GeneratorState.START_ARRAY);
        this.justWrite('[');
        ++this.depth;
        this.writeEol();
        return this;
    }

    @Override
    public JsonGenerator writeStartArray(String name) {
        this.checkObject(false);
        this.writeKey(name);
        this.justWrite('[');
        this.writeEol();
        this.state.push(GeneratorState.START_ARRAY);
        ++this.depth;
        return this;
    }

    private void writeJsonValue(String name, JsonValue value) {
        this.checkObject(false);
        switch (value.getValueType()) {
            case ARRAY: {
                this.writeStartArray(name);
                JsonArray array = (JsonArray)JsonArray.class.cast(value);
                Iterator ait = array.iterator();
                while (ait.hasNext()) {
                    this.write((JsonValue)ait.next());
                }
                this.writeEnd();
                break;
            }
            case OBJECT: {
                this.writeStartObject(name);
                JsonObject object = (JsonObject)JsonObject.class.cast(value);
                for (Map.Entry keyval : object.entrySet()) {
                    this.write((String)keyval.getKey(), (JsonValue)keyval.getValue());
                }
                this.writeEnd();
                break;
            }
            case STRING: {
                this.write(name, ((JsonString)JsonString.class.cast(value)).getString());
                break;
            }
            case NUMBER: {
                JsonNumber number = (JsonNumber)JsonNumber.class.cast(value);
                if (number.isIntegral()) {
                    this.write(name, number.longValueExact());
                    break;
                }
                this.write(name, number.bigDecimalValue());
                break;
            }
            case TRUE: {
                this.write(name, true);
                break;
            }
            case FALSE: {
                this.write(name, false);
                break;
            }
            case NULL: {
                this.writeNull(name);
                break;
            }
            default: {
                throw new JsonGenerationException("Unknown JsonValue type");
            }
        }
    }

    private void writeJsonValue(JsonValue value) {
        this.checkArray(true);
        switch (value.getValueType()) {
            case ARRAY: {
                this.writeStartArray();
                JsonArray array = (JsonArray)JsonArray.class.cast(value);
                Iterator ait = array.iterator();
                while (ait.hasNext()) {
                    this.write((JsonValue)ait.next());
                }
                this.writeEnd();
                break;
            }
            case OBJECT: {
                this.writeStartObject();
                JsonObject object = (JsonObject)JsonObject.class.cast(value);
                for (Map.Entry keyval : object.entrySet()) {
                    this.write((String)keyval.getKey(), (JsonValue)keyval.getValue());
                }
                this.writeEnd();
                break;
            }
            case STRING: {
                this.write(((JsonString)JsonString.class.cast(value)).getString());
                break;
            }
            case NUMBER: {
                JsonNumber number = (JsonNumber)JsonNumber.class.cast(value);
                if (number.isIntegral()) {
                    this.write(number.longValueExact());
                    break;
                }
                this.write(number.bigDecimalValue());
                break;
            }
            case TRUE: {
                this.write(true);
                break;
            }
            case FALSE: {
                this.write(false);
                break;
            }
            case NULL: {
                this.writeNull();
                break;
            }
            default: {
                throw new JsonGenerationException("Unknown JsonValue type");
            }
        }
    }

    @Override
    public JsonGenerator write(String name, JsonValue value) {
        this.checkObject(false);
        this.writeJsonValue(name, value);
        return this;
    }

    @Override
    public JsonGenerator write(String name, String value) {
        this.checkObject(false);
        this.writeKey(name);
        this.writeValueAsJsonString(value);
        return this;
    }

    @Override
    public JsonGenerator write(String name, BigInteger value) {
        this.checkObject(false);
        this.writeKey(name);
        this.writeValue(String.valueOf(value));
        return this;
    }

    @Override
    public JsonGenerator write(String name, BigDecimal value) {
        this.checkObject(false);
        this.writeKey(name);
        this.writeValue(String.valueOf(value));
        return this;
    }

    @Override
    public JsonGenerator write(String name, int value) {
        this.checkObject(false);
        this.writeKey(name);
        this.writeValue(value);
        return this;
    }

    @Override
    public JsonGenerator write(String name, long value) {
        this.checkObject(false);
        this.writeKey(name);
        this.writeValue(value);
        return this;
    }

    @Override
    public JsonGenerator write(String name, double value) {
        this.checkObject(false);
        JsonGeneratorImpl.checkDoubleRange(value);
        this.writeKey(name);
        this.writeValue(String.valueOf(value));
        return this;
    }

    @Override
    public JsonGenerator write(String name, boolean value) {
        this.checkObject(false);
        this.writeKey(name);
        this.writeValue(String.valueOf(value));
        return this;
    }

    @Override
    public JsonGenerator writeNull(String name) {
        this.checkObject(false);
        this.writeKey(name);
        this.writeValue(NULL);
        return this;
    }

    @Override
    public JsonGenerator writeEnd() {
        this.checkArrayOrObject(false);
        GeneratorState last = this.state.pop();
        --this.depth;
        if (last != GeneratorState.START_ARRAY) {
            this.writeEol();
        }
        this.writeIndent();
        if (last == GeneratorState.IN_ARRAY || last == GeneratorState.START_ARRAY) {
            this.justWrite(']');
        } else {
            this.justWrite('}');
        }
        this.alignState();
        return this;
    }

    @Override
    public JsonGenerator write(JsonValue value) {
        this.checkArray(true);
        this.writeJsonValue(value);
        return this;
    }

    @Override
    public JsonGenerator write(String value) {
        this.checkArray(false);
        this.writeValueAsJsonString(value);
        return this;
    }

    @Override
    public JsonGenerator write(BigDecimal value) {
        this.checkArray(false);
        this.writeValue(String.valueOf(value));
        return this;
    }

    @Override
    public JsonGenerator write(BigInteger value) {
        this.checkArray(false);
        this.writeValue(String.valueOf(value));
        return this;
    }

    @Override
    public JsonGenerator write(int value) {
        this.checkArray(false);
        this.writeValue(value);
        return this;
    }

    @Override
    public JsonGenerator write(long value) {
        this.checkArray(false);
        this.writeValue(value);
        return this;
    }

    @Override
    public JsonGenerator write(double value) {
        this.checkArray(false);
        JsonGeneratorImpl.checkDoubleRange(value);
        this.writeValue(String.valueOf(value));
        return this;
    }

    @Override
    public JsonGenerator write(boolean value) {
        this.checkArray(false);
        this.writeValue(String.valueOf(value));
        return this;
    }

    @Override
    public JsonGenerator writeNull() {
        this.checkArray(false);
        this.writeValue(NULL);
        return this;
    }

    @Override
    public void close() {
        try {
            if (this.currentState() != GeneratorState.END) {
                throw new JsonGenerationException("Invalid json");
            }
        }
        finally {
            this.flushBuffer();
            try {
                this.writer.close();
            }
            catch (IOException e) {
                throw new JsonException(e.getMessage(), e);
            }
            this.bufferProvider.release(this.buffer);
        }
    }

    @Override
    public void flush() {
        this.flushBuffer();
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new JsonException(e.getMessage(), e);
        }
    }

    private void flushBuffer() {
        if (this.bufferPos > 0) {
            try {
                this.writer.write(this.buffer, 0, this.bufferPos);
                this.bufferPos = 0;
            }
            catch (IOException e) {
                throw new JsonException(e.getMessage(), e);
            }
        }
    }

    private void writeEscaped0(String value) {
        int len = 0;
        if (value == null || (len = value.length()) == 0) {
            return;
        }
        block10: for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            while (c != '\\' && c != '\"' && c >= ' ') {
                this.justWrite(c);
                if (i >= len - 1) {
                    return;
                }
                c = value.charAt(++i);
            }
            switch (c) {
                case '\"': 
                case '\\': {
                    this.justWrite('\\');
                    this.justWrite(c);
                    continue block10;
                }
                default: {
                    if (c < ' ') {
                        switch (c) {
                            case '\n': {
                                this.justWrite("\\n");
                                continue block10;
                            }
                            case '\r': {
                                this.justWrite("\\r");
                                continue block10;
                            }
                            case '\t': {
                                this.justWrite("\\t");
                                continue block10;
                            }
                            case '\b': {
                                this.justWrite("\\b");
                                continue block10;
                            }
                            case '\f': {
                                this.justWrite("\\f");
                                continue block10;
                            }
                        }
                        this.justWrite(JsonGeneratorImpl.toUnicode(c));
                        continue block10;
                    }
                    if (c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        this.justWrite(JsonGeneratorImpl.toUnicode(c));
                        continue block10;
                    }
                    this.justWrite(c);
                }
            }
        }
    }

    private static String toUnicode(char c) {
        String hex = UNICODE_PREFIX_HELPER + Integer.toHexString(c);
        String s = UNICODE_PREFIX + hex.substring(hex.length() - 4);
        return s;
    }

    private void justWrite(String value) {
        int valueLength = value.length();
        if (this.bufferPos + valueLength >= this.buffer.length) {
            int start = 0;
            int len = this.buffer.length - this.bufferPos;
            while (true) {
                int end;
                if ((end = start + len) > valueLength) {
                    end = valueLength;
                }
                value.getChars(start, end, this.buffer, this.bufferPos);
                this.bufferPos += end - start;
                if ((start += len) >= valueLength) {
                    return;
                }
                if (this.bufferPos < this.buffer.length) continue;
                this.flushBuffer();
                len = this.buffer.length;
            }
        }
        value.getChars(0, valueLength, this.buffer, this.bufferPos);
        this.bufferPos += valueLength;
    }

    private void justWrite(char value) {
        if (this.bufferPos >= this.buffer.length) {
            this.flushBuffer();
        }
        this.buffer[this.bufferPos++] = value;
    }

    private void checkObject(boolean allowInitial) {
        GeneratorState currentState = this.currentState();
        if (!(currentState == GeneratorState.IN_OBJECT || currentState == GeneratorState.START_OBJECT || allowInitial && currentState == GeneratorState.INITIAL)) {
            throw new JsonGenerationException("write(name, param) is only valid in objects");
        }
    }

    private void checkArray(boolean allowInitial) {
        GeneratorState currentState = this.currentState();
        if (!(currentState == GeneratorState.IN_ARRAY || currentState == GeneratorState.START_ARRAY || allowInitial && currentState == GeneratorState.INITIAL)) {
            throw new JsonGenerationException("write(param) is only valid in arrays");
        }
    }

    private void checkArrayOrObject(boolean allowInitial) {
        GeneratorState currentState = this.currentState();
        if (!(currentState == GeneratorState.IN_ARRAY || currentState == GeneratorState.START_ARRAY || currentState == GeneratorState.IN_OBJECT || currentState == GeneratorState.START_OBJECT || allowInitial && currentState == GeneratorState.INITIAL)) {
            throw new JsonGenerationException("only valid within array or object");
        }
    }

    private static void checkDoubleRange(double value) {
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            throw new NumberFormatException("double can't be infinite or NaN");
        }
    }

    private void prepareValue() {
        GeneratorState currentState = this.currentState();
        if (!currentState.acceptsValue) {
            throw new JsonGenerationException("state " + (Object)((Object)currentState) + " does not accept a value");
        }
        if (currentState == GeneratorState.IN_ARRAY) {
            this.justWrite(',');
            this.writeEol();
        }
    }

    private void alignState() {
        if (this.currentState() == GeneratorState.AFTER_KEY) {
            this.state.pop();
        }
        switch (this.currentState()) {
            case START_ARRAY: {
                this.swapState(GeneratorState.IN_ARRAY);
                break;
            }
            case START_OBJECT: {
                this.swapState(GeneratorState.IN_OBJECT);
                break;
            }
            case INITIAL: {
                this.swapState(GeneratorState.END);
                break;
            }
        }
    }

    private void swapState(GeneratorState newState) {
        this.state.pop();
        this.state.push(newState);
    }

    private GeneratorState currentState() {
        return this.state.peek();
    }

    private void writeKey(String key) {
        GeneratorState currentState = this.currentState();
        if (!currentState.acceptsKey) {
            throw new IllegalStateException("state " + (Object)((Object)currentState) + " does not accept a key");
        }
        if (currentState == GeneratorState.IN_OBJECT) {
            this.justWrite(',');
            this.writeEol();
        }
        this.writeIndent();
        this.writeCachedKey(key);
        this.state.push(GeneratorState.AFTER_KEY);
    }

    private void writeValueAsJsonString(String value) {
        this.prepareValue();
        GeneratorState peek = this.state.peek();
        if (peek == GeneratorState.START_ARRAY || peek == GeneratorState.IN_ARRAY) {
            this.writeIndent();
        }
        this.justWrite('\"');
        this.writeEscaped0(value);
        this.justWrite('\"');
        this.alignState();
    }

    private void writeValue(String value) {
        this.prepareValue();
        GeneratorState peek = this.state.peek();
        if (peek == GeneratorState.START_ARRAY || peek == GeneratorState.IN_ARRAY) {
            this.writeIndent();
        }
        this.justWrite(String.valueOf(value));
        this.alignState();
    }

    private void writeValue(int value) {
        this.prepareValue();
        GeneratorState peek = this.state.peek();
        if (peek == GeneratorState.START_ARRAY || peek == GeneratorState.IN_ARRAY) {
            this.writeIndent();
        }
        this.writeInt0(value);
        this.alignState();
    }

    private void writeValue(long value) {
        this.prepareValue();
        GeneratorState peek = this.state.peek();
        if (peek == GeneratorState.START_ARRAY || peek == GeneratorState.IN_ARRAY) {
            this.writeIndent();
        }
        this.writeLong0(value);
        this.alignState();
    }

    private void writeLong0(long i) {
        this.justWrite(String.valueOf(i));
    }

    private void writeInt0(int i) {
        this.justWrite(String.valueOf(i));
    }

    private static enum GeneratorState {
        INITIAL(false, true),
        START_OBJECT(true, false),
        IN_OBJECT(true, false),
        AFTER_KEY(false, true),
        START_ARRAY(false, true),
        IN_ARRAY(false, true),
        END(false, false);

        private final boolean acceptsKey;
        private final boolean acceptsValue;

        private GeneratorState(boolean acceptsKey, boolean acceptsValue) {
            this.acceptsKey = acceptsKey;
            this.acceptsValue = acceptsValue;
        }
    }
}

