/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.memory;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Table;
import com.google.common.io.ByteSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStoreDAO;
import org.apache.james.blob.api.BucketName;
import org.apache.james.blob.api.ObjectNotFoundException;
import org.apache.james.blob.api.ObjectStoreIOException;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MemoryBlobStoreDAO
implements BlobStoreDAO {
    private final Table<BucketName, BlobId, byte[]> blobs = HashBasedTable.create();

    public InputStream read(BucketName bucketName, BlobId blobId) throws ObjectStoreIOException, ObjectNotFoundException {
        return (InputStream)this.readBytes(bucketName, blobId).map(ByteArrayInputStream::new).block();
    }

    public Publisher<InputStream> readReactive(BucketName bucketName, BlobId blobId) {
        return this.readBytes(bucketName, blobId).map(ByteArrayInputStream::new);
    }

    public Mono<byte[]> readBytes(BucketName bucketName, BlobId blobId) {
        return Mono.fromCallable(() -> (byte[])this.blobs.get((Object)bucketName, (Object)blobId)).switchIfEmpty(Mono.error(() -> new ObjectNotFoundException(String.format("blob '%s' not found in bucket '%s'", blobId.asString(), bucketName.asString()))));
    }

    public Mono<Void> save(BucketName bucketName, BlobId blobId, byte[] data) {
        return Mono.fromRunnable(() -> {
            Table<BucketName, BlobId, byte[]> table = this.blobs;
            synchronized (table) {
                this.blobs.put((Object)bucketName, (Object)blobId, (Object)data);
            }
        });
    }

    public Mono<Void> save(BucketName bucketName, BlobId blobId, InputStream inputStream) {
        Preconditions.checkNotNull((Object)inputStream);
        return Mono.fromCallable(() -> {
            try {
                return IOUtils.toByteArray((InputStream)inputStream);
            }
            catch (IOException e) {
                throw new ObjectStoreIOException("IOException occured", (Throwable)e);
            }
        }).flatMap(bytes -> this.save(bucketName, blobId, (byte[])bytes));
    }

    public Mono<Void> save(BucketName bucketName, BlobId blobId, ByteSource content) {
        return Mono.fromCallable(() -> {
            try {
                return content.read();
            }
            catch (IOException e) {
                throw new ObjectStoreIOException("IOException occured", (Throwable)e);
            }
        }).flatMap(bytes -> this.save(bucketName, blobId, (byte[])bytes));
    }

    public Mono<Void> delete(BucketName bucketName, BlobId blobId) {
        Preconditions.checkNotNull((Object)bucketName);
        return Mono.fromRunnable(() -> {
            Table<BucketName, BlobId, byte[]> table = this.blobs;
            synchronized (table) {
                this.blobs.remove((Object)bucketName, (Object)blobId);
            }
        });
    }

    public Publisher<Void> delete(BucketName bucketName, Collection<BlobId> blobIds) {
        return Flux.fromIterable(blobIds).flatMap(id -> this.delete(bucketName, (BlobId)id)).then();
    }

    public Mono<Void> deleteBucket(BucketName bucketName) {
        return Mono.fromRunnable(() -> {
            Table<BucketName, BlobId, byte[]> table = this.blobs;
            synchronized (table) {
                this.blobs.row((Object)bucketName).clear();
            }
        });
    }

    public Publisher<BucketName> listBuckets() {
        return Flux.fromIterable((Iterable)ImmutableSet.copyOf((Collection)this.blobs.rowKeySet()));
    }

    public Publisher<BlobId> listBlobs(BucketName bucketName) {
        return Flux.fromIterable((Iterable)ImmutableSet.copyOf(this.blobs.row((Object)bucketName).keySet()));
    }
}

