/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.opensearch.query;

import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.mail.Flags;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.opensearch.query.DateResolutionFormatter;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.query_dsl.BoolQuery;
import org.opensearch.client.opensearch._types.query_dsl.ChildScoreMode;
import org.opensearch.client.opensearch._types.query_dsl.MatchAllQuery;
import org.opensearch.client.opensearch._types.query_dsl.MatchQuery;
import org.opensearch.client.opensearch._types.query_dsl.NestedQuery;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.RangeQuery;
import org.opensearch.client.opensearch._types.query_dsl.TermQuery;

public class CriterionConverter {
    private final Map<Class<?>, Function<SearchQuery.Criterion, Query>> criterionConverterMap = new HashMap();
    private final Map<Class<?>, BiFunction<String, SearchQuery.HeaderOperator, Query>> headerOperatorConverterMap = new HashMap();

    public CriterionConverter() {
        this.registerCriterionConverters();
        this.registerHeaderOperatorConverters();
    }

    private void registerCriterionConverters() {
        this.registerCriterionConverter(SearchQuery.FlagCriterion.class, this::convertFlag);
        this.registerCriterionConverter(SearchQuery.UidCriterion.class, this::convertUid);
        this.registerCriterionConverter(SearchQuery.MessageIdCriterion.class, this::convertMessageId);
        this.registerCriterionConverter(SearchQuery.ConjunctionCriterion.class, this::convertConjunction);
        this.registerCriterionConverter(SearchQuery.HeaderCriterion.class, this::convertHeader);
        this.registerCriterionConverter(SearchQuery.SubjectCriterion.class, this::convertSubject);
        this.registerCriterionConverter(SearchQuery.TextCriterion.class, this::convertTextCriterion);
        this.registerCriterionConverter(SearchQuery.CustomFlagCriterion.class, this::convertCustomFlagCriterion);
        this.registerCriterionConverter(SearchQuery.AllCriterion.class, criterion -> new MatchAllQuery.Builder().build()._toQuery());
        this.registerCriterionConverter(SearchQuery.ModSeqCriterion.class, criterion -> this.createNumericFilter("modSeq", criterion.getOperator()));
        this.registerCriterionConverter(SearchQuery.SizeCriterion.class, criterion -> this.createNumericFilter("size", criterion.getOperator()));
        this.registerCriterionConverter(SearchQuery.InternalDateCriterion.class, criterion -> this.dateRangeFilter("date", criterion.getOperator()));
        this.registerCriterionConverter(SearchQuery.SaveDateCriterion.class, criterion -> this.dateRangeFilter("saveDate", criterion.getOperator()));
        this.registerCriterionConverter(SearchQuery.AttachmentCriterion.class, this::convertAttachmentCriterion);
        this.registerCriterionConverter(SearchQuery.MimeMessageIDCriterion.class, this::convertMimeMessageIDCriterion);
        this.registerCriterionConverter(SearchQuery.ThreadIdCriterion.class, this::convertThreadIdCriterion);
    }

    private <T extends SearchQuery.Criterion> void registerCriterionConverter(Class<T> type, Function<T, Query> f) {
        this.criterionConverterMap.put(type, f);
    }

    private void registerHeaderOperatorConverters() {
        this.registerHeaderOperatorConverter(SearchQuery.ExistsOperator.class, (headerName, operator) -> new NestedQuery.Builder().path("headers").query(new TermQuery.Builder().field("headers.name").value((FieldValue)new FieldValue.Builder().stringValue(headerName).build()).build()._toQuery()).scoreMode(ChildScoreMode.Avg).build()._toQuery());
        this.registerHeaderOperatorConverter(SearchQuery.AddressOperator.class, (headerName, operator) -> this.manageAddressFields((String)headerName, operator.getAddress()));
        this.registerHeaderOperatorConverter(SearchQuery.DateOperator.class, (headerName, operator) -> this.dateRangeFilter("sentDate", (SearchQuery.DateOperator)operator));
        this.registerHeaderOperatorConverter(SearchQuery.ContainsOperator.class, (headerName, operator) -> new NestedQuery.Builder().path("headers").query(new BoolQuery.Builder().must(new TermQuery.Builder().field("headers.name").value((FieldValue)new FieldValue.Builder().stringValue(headerName).build()).build()._toQuery(), new Query[0]).must(new MatchQuery.Builder().field("headers.value").query((FieldValue)new FieldValue.Builder().stringValue(operator.getValue()).build()).build()._toQuery(), new Query[0]).build()._toQuery()).scoreMode(ChildScoreMode.Avg).build()._toQuery());
    }

    private <T extends SearchQuery.HeaderOperator> void registerHeaderOperatorConverter(Class<T> type, BiFunction<String, T, Query> f) {
        this.headerOperatorConverterMap.put(type, f);
    }

    public Query convertCriterion(SearchQuery.Criterion criterion) {
        return this.criterionConverterMap.get(criterion.getClass()).apply(criterion);
    }

    private Query convertAttachmentCriterion(SearchQuery.AttachmentCriterion criterion) {
        return new TermQuery.Builder().field("hasAttachment").value((FieldValue)new FieldValue.Builder().booleanValue(criterion.getOperator().isSet()).build()).build()._toQuery();
    }

    private Query convertMimeMessageIDCriterion(SearchQuery.MimeMessageIDCriterion criterion) {
        return new TermQuery.Builder().field("mimeMessageID").value((FieldValue)new FieldValue.Builder().stringValue(criterion.getMessageID()).build()).build()._toQuery();
    }

    private Query convertThreadIdCriterion(SearchQuery.ThreadIdCriterion criterion) {
        return new TermQuery.Builder().field("threadId").value((FieldValue)new FieldValue.Builder().stringValue(criterion.getThreadId().serialize()).build()).build()._toQuery();
    }

    private Query convertCustomFlagCriterion(SearchQuery.CustomFlagCriterion criterion) {
        Query termQuery = new TermQuery.Builder().field("userFlags").value((FieldValue)new FieldValue.Builder().stringValue(criterion.getFlag()).build()).build()._toQuery();
        if (criterion.getOperator().isSet()) {
            return termQuery;
        }
        return new BoolQuery.Builder().mustNot(termQuery, new Query[0]).build()._toQuery();
    }

    private Query convertTextCriterion(SearchQuery.TextCriterion textCriterion) {
        switch (textCriterion.getType()) {
            case BODY: {
                return new BoolQuery.Builder().should(new MatchQuery.Builder().field("textBody").query((FieldValue)new FieldValue.Builder().stringValue(textCriterion.getOperator().getValue()).build()).build()._toQuery(), new Query[0]).should(new MatchQuery.Builder().field("htmlBody").query((FieldValue)new FieldValue.Builder().stringValue(textCriterion.getOperator().getValue()).build()).build()._toQuery(), new Query[0]).build()._toQuery();
            }
            case FULL: {
                return new BoolQuery.Builder().should(new MatchQuery.Builder().field("textBody").query((FieldValue)new FieldValue.Builder().stringValue(textCriterion.getOperator().getValue()).build()).build()._toQuery(), new Query[0]).should(new MatchQuery.Builder().field("htmlBody").query((FieldValue)new FieldValue.Builder().stringValue(textCriterion.getOperator().getValue()).build()).build()._toQuery(), new Query[0]).should(new MatchQuery.Builder().field("attachments.textContent").query((FieldValue)new FieldValue.Builder().stringValue(textCriterion.getOperator().getValue()).build()).build()._toQuery(), new Query[0]).build()._toQuery();
            }
            case ATTACHMENTS: {
                return new BoolQuery.Builder().should(new MatchQuery.Builder().field("attachments.textContent").query((FieldValue)new FieldValue.Builder().stringValue(textCriterion.getOperator().getValue()).build()).build()._toQuery(), new Query[0]).build()._toQuery();
            }
            case ATTACHMENT_FILE_NAME: {
                return new BoolQuery.Builder().should(new MatchQuery.Builder().field("attachments.fileName").query((FieldValue)new FieldValue.Builder().stringValue(textCriterion.getOperator().getValue()).build()).build()._toQuery(), new Query[0]).build()._toQuery();
            }
        }
        throw new RuntimeException("Unknown SCOPE for text criterion");
    }

    private Query dateRangeFilter(String field, SearchQuery.DateOperator dateOperator) {
        return new BoolQuery.Builder().filter(this.convertDateOperator(field, dateOperator.getType(), DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(DateResolutionFormatter.computeLowerDate(DateResolutionFormatter.convertDateToZonedDateTime(dateOperator.getDate()), dateOperator.getDateResultion())), DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(DateResolutionFormatter.computeUpperDate(DateResolutionFormatter.convertDateToZonedDateTime(dateOperator.getDate()), dateOperator.getDateResultion()))), new Query[0]).build()._toQuery();
    }

    private Query convertConjunction(SearchQuery.ConjunctionCriterion criterion) {
        return this.convertToBoolQuery(criterion.getCriteria().stream().map(this::convertCriterion), this.convertConjunctionType(criterion.getType()));
    }

    private BiFunction<BoolQuery.Builder, Query, BoolQuery.Builder> convertConjunctionType(SearchQuery.Conjunction type) {
        switch (type) {
            case AND: {
                return (rec$, x$0) -> ((BoolQuery.Builder)rec$).must(x$0, new Query[0]);
            }
            case OR: {
                return (rec$, x$0) -> ((BoolQuery.Builder)rec$).should(x$0, new Query[0]);
            }
            case NOR: {
                return (rec$, x$0) -> ((BoolQuery.Builder)rec$).mustNot(x$0, new Query[0]);
            }
        }
        throw new RuntimeException("Unexpected conjunction criteria " + type);
    }

    private Query convertToBoolQuery(Stream<Query> stream, BiFunction<BoolQuery.Builder, Query, BoolQuery.Builder> addCriterionToBoolQuery) {
        BoolQuery.Builder builder = new BoolQuery.Builder();
        stream.forEach(query -> addCriterionToBoolQuery.apply(builder, (Query)query));
        return builder.build()._toQuery();
    }

    private Query convertFlag(SearchQuery.FlagCriterion flagCriterion) {
        SearchQuery.BooleanOperator operator = flagCriterion.getOperator();
        Flags.Flag flag = flagCriterion.getFlag();
        if (flag.equals(Flags.Flag.DELETED)) {
            return new BoolQuery.Builder().filter(new TermQuery.Builder().field("isDeleted").value((FieldValue)new FieldValue.Builder().booleanValue(operator.isSet()).build()).build()._toQuery(), new Query[0]).build()._toQuery();
        }
        if (flag.equals(Flags.Flag.ANSWERED)) {
            return new BoolQuery.Builder().filter(new TermQuery.Builder().field("isAnswered").value((FieldValue)new FieldValue.Builder().booleanValue(operator.isSet()).build()).build()._toQuery(), new Query[0]).build()._toQuery();
        }
        if (flag.equals(Flags.Flag.DRAFT)) {
            return new BoolQuery.Builder().filter(new TermQuery.Builder().field("isDraft").value((FieldValue)new FieldValue.Builder().booleanValue(operator.isSet()).build()).build()._toQuery(), new Query[0]).build()._toQuery();
        }
        if (flag.equals(Flags.Flag.SEEN)) {
            return new BoolQuery.Builder().filter(new TermQuery.Builder().field("isUnread").value((FieldValue)new FieldValue.Builder().booleanValue(!operator.isSet()).build()).build()._toQuery(), new Query[0]).build()._toQuery();
        }
        if (flag.equals(Flags.Flag.RECENT)) {
            return new BoolQuery.Builder().filter(new TermQuery.Builder().field("isRecent").value((FieldValue)new FieldValue.Builder().booleanValue(operator.isSet()).build()).build()._toQuery(), new Query[0]).build()._toQuery();
        }
        if (flag.equals(Flags.Flag.FLAGGED)) {
            return new BoolQuery.Builder().filter(new TermQuery.Builder().field("isFlagged").value((FieldValue)new FieldValue.Builder().booleanValue(operator.isSet()).build()).build()._toQuery(), new Query[0]).build()._toQuery();
        }
        throw new RuntimeException("Unknown flag used in Flag search criterion");
    }

    private Query createNumericFilter(String fieldName, SearchQuery.NumericOperator operator) {
        switch (operator.getType()) {
            case EQUALS: {
                return new BoolQuery.Builder().filter(new RangeQuery.Builder().field(fieldName).gte(JsonData.of((Object)operator.getValue())).lte(JsonData.of((Object)operator.getValue())).build()._toQuery(), new Query[0]).build()._toQuery();
            }
            case GREATER_THAN: {
                return new BoolQuery.Builder().filter(new RangeQuery.Builder().field(fieldName).gt(JsonData.of((Object)operator.getValue())).build()._toQuery(), new Query[0]).build()._toQuery();
            }
            case LESS_THAN: {
                return new BoolQuery.Builder().filter(new RangeQuery.Builder().field(fieldName).lt(JsonData.of((Object)operator.getValue())).build()._toQuery(), new Query[0]).build()._toQuery();
            }
        }
        throw new RuntimeException("A non existing numeric operator was triggered");
    }

    private Query convertUid(SearchQuery.UidCriterion uidCriterion) {
        if (uidCriterion.getOperator().getRange().length == 0) {
            return new BoolQuery.Builder().build()._toQuery();
        }
        return new BoolQuery.Builder().filter(this.convertToBoolQuery(Arrays.stream(uidCriterion.getOperator().getRange()).map(this::uidRangeFilter), (rec$, x$0) -> ((BoolQuery.Builder)rec$).should(x$0, new Query[0])), new Query[0]).build()._toQuery();
    }

    private Query convertMessageId(SearchQuery.MessageIdCriterion messageIdCriterion) {
        return new TermQuery.Builder().field("messageId").value((FieldValue)new FieldValue.Builder().stringValue(messageIdCriterion.getMessageId().serialize()).build()).build()._toQuery();
    }

    private Query uidRangeFilter(SearchQuery.UidRange numericRange) {
        return new RangeQuery.Builder().field("uid").lte(JsonData.of((Object)numericRange.getHighValue().asLong())).gte(JsonData.of((Object)numericRange.getLowValue().asLong())).build()._toQuery();
    }

    private Query convertHeader(SearchQuery.HeaderCriterion headerCriterion) {
        return this.headerOperatorConverterMap.get(headerCriterion.getOperator().getClass()).apply(headerCriterion.getHeaderName().toLowerCase(Locale.US), headerCriterion.getOperator());
    }

    private Query convertSubject(SearchQuery.SubjectCriterion headerCriterion) {
        return new MatchQuery.Builder().field("subject").query((FieldValue)new FieldValue.Builder().stringValue(headerCriterion.getSubject()).build()).build()._toQuery();
    }

    private Query manageAddressFields(String headerName, String value) {
        return new BoolQuery.Builder().should(new MatchQuery.Builder().field(this.getFieldNameFromHeaderName(headerName) + ".name").query((FieldValue)new FieldValue.Builder().stringValue(value).build()).build()._toQuery(), new Query[0]).should(new MatchQuery.Builder().field(this.getFieldNameFromHeaderName(headerName) + ".address").query((FieldValue)new FieldValue.Builder().stringValue(value).build()).build()._toQuery(), new Query[0]).should(new MatchQuery.Builder().field(this.getFieldNameFromHeaderName(headerName) + ".domain").query((FieldValue)new FieldValue.Builder().stringValue(value).build()).build()._toQuery(), new Query[0]).should(new MatchQuery.Builder().field(this.getFieldNameFromHeaderName(headerName) + ".address.raw").query((FieldValue)new FieldValue.Builder().stringValue(value).build()).build()._toQuery(), new Query[0]).build()._toQuery();
    }

    private String getFieldNameFromHeaderName(String headerName) {
        switch (headerName.toLowerCase(Locale.US)) {
            case "to": {
                return "to";
            }
            case "cc": {
                return "cc";
            }
            case "bcc": {
                return "bcc";
            }
            case "from": {
                return "from";
            }
        }
        throw new RuntimeException("Header not recognized as Addess Header : " + headerName);
    }

    private Query convertDateOperator(String field, SearchQuery.DateComparator dateComparator, String lowDateString, String upDateString) {
        switch (dateComparator) {
            case BEFORE: {
                return new RangeQuery.Builder().field(field).lt(JsonData.of((Object)lowDateString)).build()._toQuery();
            }
            case AFTER: {
                return new RangeQuery.Builder().field(field).gte(JsonData.of((Object)upDateString)).build()._toQuery();
            }
            case ON: {
                return new RangeQuery.Builder().field(field).lt(JsonData.of((Object)upDateString)).gte(JsonData.of((Object)lowDateString)).build()._toQuery();
            }
        }
        throw new RuntimeException("Unknown date operator");
    }
}

