/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.vault;

import com.google.inject.AbstractModule;
import com.google.inject.ConfigurationException;
import com.google.inject.Provides;
import java.io.FileNotFoundException;
import javax.inject.Singleton;
import org.apache.commons.configuration2.Configuration;
import org.apache.james.utils.PropertiesProvider;
import org.apache.james.vault.VaultConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeletedMessageVaultConfigurationModule
extends AbstractModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeletedMessageVaultConfigurationModule.class);

    @Provides
    @Singleton
    VaultConfiguration providesVaultConfiguration(PropertiesProvider propertiesProvider) throws ConfigurationException, org.apache.commons.configuration2.ex.ConfigurationException {
        try {
            Configuration configuration = propertiesProvider.getConfiguration("deletedMessageVault");
            return VaultConfiguration.from((Configuration)configuration);
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Error encountered while retrieving Deleted message vault configuration. Using default RetentionTime (1 year) and RestoreLocation (Restored-Messages) instead.");
            return VaultConfiguration.DEFAULT;
        }
    }
}

