/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.api.filtering.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.EventId;
import org.apache.james.eventsourcing.EventWithState;
import org.apache.james.eventsourcing.ImmutableState;
import org.apache.james.eventsourcing.eventstore.History;
import org.apache.james.jmap.api.exception.StateMismatchException;
import org.apache.james.jmap.api.filtering.Rule;
import org.apache.james.jmap.api.filtering.Rules;
import org.apache.james.jmap.api.filtering.Version;
import org.apache.james.jmap.api.filtering.impl.DefineRulesCommand;
import org.apache.james.jmap.api.filtering.impl.FilteringAggregateId;
import org.apache.james.jmap.api.filtering.impl.IncrementalRuleChange;
import org.apache.james.jmap.api.filtering.impl.RuleSetDefined;
import scala.Option;
import scala.Some;

public class FilteringAggregate {
    private static final boolean ENABLE_INCREMENTS = Boolean.parseBoolean(System.getProperty("james.jmap.filters.eventsource.increments.enabled", "true"));
    private static final boolean ENABLE_SNAPSHOTS = Boolean.parseBoolean(System.getProperty("james.jmap.filters.eventsource.snapshots.enabled", "true"));
    private final FilteringAggregateId aggregateId;
    private final History history;
    private State state;

    public static FilteringAggregate load(FilteringAggregateId aggregateId, History eventsOfAggregate) {
        return new FilteringAggregate(aggregateId, eventsOfAggregate);
    }

    private FilteringAggregate(FilteringAggregateId aggregateId, History history) {
        this.aggregateId = aggregateId;
        this.state = State.initial();
        history.getEventsJava().forEach(this::apply);
        this.history = history;
    }

    public List<EventWithState> defineRules(DefineRulesCommand storeCommand) {
        Preconditions.checkArgument((boolean)this.shouldNotContainDuplicates(storeCommand.getRules()));
        StateMismatchException.checkState(this.expectedState(storeCommand.getIfInState()), "Provided state must be as same as the current state");
        Event event = this.generateEvent(storeCommand);
        this.apply(event);
        return ImmutableList.of((Object)new EventWithState(event, (Option)Some.apply((Object)new FilterState(this.state.rules))));
    }

    private Event generateEvent(DefineRulesCommand storeCommand) {
        EventId nextEventId = this.history.getNextEventId();
        if (ENABLE_INCREMENTS) {
            if (ENABLE_SNAPSHOTS && this.history.getEvents().size() >= 100) {
                return new RuleSetDefined(this.aggregateId, nextEventId, (ImmutableList<Rule>)ImmutableList.copyOf(storeCommand.getRules()));
            }
            return IncrementalRuleChange.ofDiff(this.aggregateId, this.history.getNextEventId(), this.state.rules, storeCommand.getRules()).map(Event.class::cast).orElseGet(() -> new RuleSetDefined(this.aggregateId, this.history.getNextEventId(), (ImmutableList<Rule>)ImmutableList.copyOf(storeCommand.getRules())));
        }
        return new RuleSetDefined(this.aggregateId, this.history.getNextEventId(), (ImmutableList<Rule>)ImmutableList.copyOf(storeCommand.getRules()));
    }

    private boolean shouldNotContainDuplicates(List<Rule> rules) {
        long uniqueIdCount = rules.stream().map(Rule::getId).distinct().count();
        return uniqueIdCount == (long)rules.size();
    }

    private boolean expectedState(Optional<Version> ifInState) {
        return ifInState.map(requestedVersion -> this.history.getVersionAsJava().map(eventId -> new Version(eventId.value())).orElse(Version.INITIAL).equals(requestedVersion)).orElse(true);
    }

    public Rules listRules() {
        return new Rules((List<Rule>)this.state.rules, this.history.getVersionAsJava().map(EventId::value).map(Version::new).orElse(Version.INITIAL));
    }

    private void apply(Event event) {
        if (event instanceof RuleSetDefined) {
            this.state = this.state.set(((RuleSetDefined)event).getRules());
        }
        if (event instanceof IncrementalRuleChange) {
            this.state = this.state.set(((IncrementalRuleChange)event).apply(this.state.rules));
        }
    }

    public static class FilterState
    implements ImmutableState {
        private final ImmutableList<Rule> rules;

        public FilterState(ImmutableList<Rule> rules) {
            this.rules = rules;
        }

        public ImmutableList<Rule> getRules() {
            return this.rules;
        }
    }

    private static class State {
        final ImmutableList<Rule> rules;

        static State initial() {
            return new State((ImmutableList<Rule>)ImmutableList.of());
        }

        private State(ImmutableList<Rule> rules) {
            this.rules = rules;
        }

        State set(ImmutableList<Rule> rules) {
            return new State(rules);
        }
    }
}

