/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail.migration;

import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.migration.Migration;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.mail.CassandraACLMapper;
import org.apache.james.mailbox.cassandra.mail.CassandraMailboxDAO;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AclV2Migration
implements Migration {
    private static final int CONCURRENCY = 20;
    public static final Logger LOGGER = LoggerFactory.getLogger(AclV2Migration.class);
    public static final TaskType TYPE = TaskType.of((String)"acl-v2-migration");
    private final CassandraMailboxDAO mailboxDAO;
    private final CassandraACLMapper.StoreV1 storeV1;
    private final CassandraACLMapper.StoreV2 storeV2;

    @Inject
    public AclV2Migration(CassandraMailboxDAO mailboxDAO, CassandraACLMapper.StoreV1 storeV1, CassandraACLMapper.StoreV2 storeV2) {
        this.mailboxDAO = mailboxDAO;
        this.storeV1 = storeV1;
        this.storeV2 = storeV2;
    }

    public void apply() {
        this.mailboxDAO.retrieveAllMailboxes().flatMap(mailbox -> {
            CassandraId id = (CassandraId)mailbox.getMailboxId();
            return this.storeV1.getACL(id).flatMap(acl -> this.storeV2.setACL(id, (MailboxACL)acl));
        }, 20).doOnError(t -> LOGGER.error("Error while performing migration", t)).blockLast();
    }

    public Task asTask() {
        return new AclV2MigrationTask(this);
    }

    AdditionalInformation getAdditionalInformation() {
        return new AdditionalInformation(Clock.systemUTC().instant());
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final Instant timestamp;

        public AdditionalInformation(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public Instant timestamp() {
            return this.timestamp;
        }
    }

    static class AclV2MigrationTask
    implements Task {
        private final AclV2Migration migration;

        AclV2MigrationTask(AclV2Migration migration) {
            this.migration = migration;
        }

        public Task.Result run() throws InterruptedException {
            return this.migration.runTask();
        }

        public TaskType type() {
            return TYPE;
        }

        public Optional<TaskExecutionDetails.AdditionalInformation> details() {
            return Optional.of(this.migration.getAdditionalInformation());
        }
    }
}

