/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq;

import javax.inject.Inject;
import org.apache.james.backends.rabbitmq.RabbitMQConfiguration;
import org.apache.james.backends.rabbitmq.RabbitMQManagementAPI;
import org.apache.james.core.healthcheck.ComponentName;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.core.healthcheck.Result;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.queue.rabbitmq.MailQueueName;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class RabbitMQMailQueueDeadLetterQueueHealthCheck
implements HealthCheck {
    public static final MailQueueName JAMES_MAIL_QUEUE_NAME = MailQueueName.fromString(MailQueueFactory.SPOOL.asString());
    public static final ComponentName COMPONENT_NAME = new ComponentName("RabbitMQMailQueueDeadLetterQueueHealthCheck");
    private static final String DEFAULT_VHOST = "/";
    private final RabbitMQConfiguration configuration;
    private final RabbitMQManagementAPI api;

    @Inject
    public RabbitMQMailQueueDeadLetterQueueHealthCheck(RabbitMQConfiguration configuration) {
        this.configuration = configuration;
        this.api = RabbitMQManagementAPI.from((RabbitMQConfiguration)configuration);
    }

    public ComponentName componentName() {
        return COMPONENT_NAME;
    }

    public Mono<Result> check() {
        return Mono.fromCallable(() -> this.api.queueDetails(this.configuration.getVhost().orElse(DEFAULT_VHOST), JAMES_MAIL_QUEUE_NAME.toDeadLetterQueueName())).map(queueDetails -> {
            if (queueDetails.getQueueLength() != 0L) {
                return Result.degraded((ComponentName)COMPONENT_NAME, (String)"RabbitMQ dead letter queue of the mail queue contain messages. This might indicate transient failure on mail processing.");
            }
            return Result.healthy((ComponentName)COMPONENT_NAME);
        }).onErrorResume(e -> Mono.just((Object)Result.unhealthy((ComponentName)COMPONENT_NAME, (String)"Error checking RabbitMQMailQueueDeadLetterQueueHealthCheck", (Throwable)e))).subscribeOn(Schedulers.boundedElastic());
    }
}

