/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailetcontainer.impl.jmx;

import java.util.concurrent.atomic.AtomicLong;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.james.mailetcontainer.api.jmx.MatcherManagementMBean;
import org.apache.mailet.MatcherConfig;

public final class MatcherManagement
extends StandardMBean
implements MatcherManagementMBean {
    private final MatcherConfig matcherConfig;
    private final AtomicLong errorCount = new AtomicLong(0L);
    private final AtomicLong successCount = new AtomicLong(0L);
    private final AtomicLong fastestProcessing = new AtomicLong(-1L);
    private final AtomicLong slowestProcessing = new AtomicLong(-1L);
    private final AtomicLong matchedCount = new AtomicLong(0L);
    private final AtomicLong notMatchedCount = new AtomicLong(0L);
    private final AtomicLong lastProcessing = new AtomicLong(-1L);

    public MatcherManagement(MatcherConfig matcherConfig) throws NotCompliantMBeanException {
        super(MatcherManagementMBean.class);
        this.matcherConfig = matcherConfig;
    }

    public void update(long processTime, boolean success, boolean matched) {
        long fastest = this.fastestProcessing.get();
        if (fastest > processTime || fastest == -1L) {
            this.fastestProcessing.set(processTime);
        }
        if (this.slowestProcessing.get() < processTime) {
            this.slowestProcessing.set(processTime);
        }
        if (success) {
            this.successCount.incrementAndGet();
        } else {
            this.errorCount.incrementAndGet();
        }
        if (matched) {
            this.matchedCount.incrementAndGet();
        } else {
            this.notMatchedCount.incrementAndGet();
        }
        this.lastProcessing.set(processTime);
    }

    public String getMatcherName() {
        return this.matcherConfig.getMatcherName();
    }

    public String getMatcherCondition() {
        return this.matcherConfig.getCondition();
    }

    public long getErrorCount() {
        return this.errorCount.get();
    }

    public long getFastestProcessing() {
        return this.fastestProcessing.get();
    }

    public long getHandledMailCount() {
        return this.getSuccessCount() + this.getErrorCount();
    }

    public long getSlowestProcessing() {
        return this.slowestProcessing.get();
    }

    public long getSuccessCount() {
        return this.successCount.get();
    }

    public long getMatchedCount() {
        return this.matchedCount.get();
    }

    public long getNotMatchedCount() {
        return this.notMatchedCount.get();
    }

    public long getLastProcessing() {
        return this.lastProcessing.get();
    }
}

