/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.ExperienceEndpoint;
import com.amazonaws.services.kendra.model.ExperienceStatus;
import com.amazonaws.services.kendra.model.transform.ExperiencesSummaryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ExperiencesSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String id;
    private Date createdAt;
    private String status;
    private List<ExperienceEndpoint> endpoints;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ExperiencesSummary withName(String name) {
        this.setName(name);
        return this;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public ExperiencesSummary withId(String id) {
        this.setId(id);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public ExperiencesSummary withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public ExperiencesSummary withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public ExperiencesSummary withStatus(ExperienceStatus status) {
        this.status = status.toString();
        return this;
    }

    public List<ExperienceEndpoint> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(Collection<ExperienceEndpoint> endpoints) {
        if (endpoints == null) {
            this.endpoints = null;
            return;
        }
        this.endpoints = new ArrayList<ExperienceEndpoint>(endpoints);
    }

    public ExperiencesSummary withEndpoints(ExperienceEndpoint ... endpoints) {
        if (this.endpoints == null) {
            this.setEndpoints(new ArrayList<ExperienceEndpoint>(endpoints.length));
        }
        for (ExperienceEndpoint ele : endpoints) {
            this.endpoints.add(ele);
        }
        return this;
    }

    public ExperiencesSummary withEndpoints(Collection<ExperienceEndpoint> endpoints) {
        this.setEndpoints(endpoints);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getEndpoints() != null) {
            sb.append("Endpoints: ").append(this.getEndpoints());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperiencesSummary)) {
            return false;
        }
        ExperiencesSummary other = (ExperiencesSummary)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getEndpoints() == null ^ this.getEndpoints() == null) {
            return false;
        }
        return other.getEndpoints() == null || other.getEndpoints().equals(this.getEndpoints());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getEndpoints() == null ? 0 : this.getEndpoints().hashCode());
        return hashCode;
    }

    public ExperiencesSummary clone() {
        try {
            return (ExperiencesSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExperiencesSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

