/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.juneau.utils.IdGenerator;

public class IdGenerators {
    public static IdGenerator<Integer> createIntGenerator(final int initValue) {
        return new IdGenerator<Integer>(){
            private final AtomicInteger i;
            {
                this.i = new AtomicInteger(initValue);
            }

            @Override
            public synchronized Integer next() {
                return this.i.getAndIncrement();
            }

            @Override
            public synchronized void lb(Integer k) {
                this.i.set(Math.max(k + 1, this.i.get()));
            }
        };
    }

    public static IdGenerator<Integer> createIntGenerator() {
        return IdGenerators.createIntGenerator(1);
    }

    public static IdGenerator<Long> createLongGenerator(final long initValue) {
        return new IdGenerator<Long>(){
            private final AtomicLong l;
            {
                this.l = new AtomicLong(initValue);
            }

            @Override
            public synchronized Long next() {
                return this.l.getAndIncrement();
            }

            @Override
            public synchronized void lb(Long k) {
                this.l.set(Math.max(k + 1L, this.l.get()));
            }
        };
    }

    public static IdGenerator<Long> createLongGenerator() {
        return IdGenerators.createLongGenerator(1L);
    }
}

