/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.List;
import java.util.function.Supplier;
import org.apache.juneau.http.BasicHeader;
import org.apache.juneau.http.StringRange;
import org.apache.juneau.http.StringRanges;
import org.apache.juneau.internal.StringUtils;

public class BasicStringRangeArrayHeader
extends BasicHeader {
    private static final long serialVersionUID = 1L;
    private StringRanges parsed;

    public static BasicStringRangeArrayHeader of(String name, Object value) {
        if (StringUtils.isEmpty(name) || value == null) {
            return null;
        }
        return new BasicStringRangeArrayHeader(name, value);
    }

    public static BasicStringRangeArrayHeader of(String name, Supplier<?> value) {
        if (StringUtils.isEmpty(name) || value == null) {
            return null;
        }
        return new BasicStringRangeArrayHeader(name, value);
    }

    public BasicStringRangeArrayHeader(String name, Object value) {
        super(name, value);
        if (!this.isSupplier(value)) {
            this.parsed = this.parse();
        }
    }

    @Override
    public String getValue() {
        Object o = this.getRawValue();
        if (o == null) {
            return null;
        }
        return StringUtils.stringify(this.asRanges());
    }

    public StringRanges asRanges() {
        return this.parse();
    }

    public int match(List<String> names) {
        return this.asRanges().match(names);
    }

    public StringRange getRange(int index) {
        return this.asRanges().getRange(index);
    }

    public List<StringRange> getRanges() {
        return this.asRanges().getRanges();
    }

    private StringRanges parse() {
        if (this.parsed != null) {
            return this.parsed;
        }
        Object o = this.getRawValue();
        if (o == null) {
            o = "";
        }
        return StringRanges.of(o.toString());
    }
}

