/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.microservice.jetty.resources;

import java.io.FileWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.apache.juneau.html.annotation.HtmlDocConfig;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.microservice.jetty.JettyMicroservice;
import org.apache.juneau.rest.BasicRestServlet;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.annotation.Rest;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.rest.helper.ResourceDescriptions;

@Rest(path="/debug", title={"Debug"}, description={"Debug Utilities."}, allowedMethodParams="OPTIONS,POST")
@HtmlDocConfig(navlinks={"up: request:/..", "jetty-thread-dump: servlet:/jetty/dump?method=POST", "options: servlet:/?method=OPTIONS", "stats: servlet:/stats"})
public class DebugResource
extends BasicRestServlet {
    private static final long serialVersionUID = 1L;

    @RestMethod(name="GET", path="/", description={"Show contents of config file."})
    public ResourceDescriptions getChildren() throws Exception {
        return new ResourceDescriptions().append("jetty/dump", "Jetty thread dump");
    }

    @RestMethod(name="GET", path="/jetty/dump", description={"Generates and retrieves the jetty thread dump."})
    public Reader getJettyDump(RestRequest req, RestResponse res) {
        res.setContentType("text/plain");
        return new StringReader(JettyMicroservice.getInstance().getServer().dump());
    }

    @RestMethod(name="POST", path="/jetty/dump", description={"Generates and saves the jetty thread dump file to jetty-thread-dump.log."})
    public String createJettyDump(RestRequest req, RestResponse res) throws Exception {
        String dump = JettyMicroservice.getInstance().getServer().dump();
        try (FileWriter fw = new FileWriter(req.getConfig().getString("Logging/logDir") + "/jetty-thread-dump.log");){
            IOUtils.pipe((Object)dump, (Writer)fw);
        }
        return "OK";
    }
}

