/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.mock2;

import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.BackoffManager;
import org.apache.http.client.ConnectionBackoffStrategy;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.UserTokenHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.InputStreamFactory;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Lookup;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.util.PublicSuffixMatcher;
import org.apache.http.cookie.CookieSpecProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.juneau.Context;
import org.apache.juneau.DetailLevel;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.UriContext;
import org.apache.juneau.UriRelativity;
import org.apache.juneau.UriResolution;
import org.apache.juneau.Visibility;
import org.apache.juneau.collections.AMap;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.httppart.HttpPartCollectionFormat;
import org.apache.juneau.httppart.HttpPartFormat;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.marshall.Marshall;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.reflect.AnnotationList;
import org.apache.juneau.rest.client2.RestCallHandler;
import org.apache.juneau.rest.client2.RestClientBuilder;
import org.apache.juneau.rest.client2.RestRequest;
import org.apache.juneau.rest.client2.RestResponse;
import org.apache.juneau.rest.mock2.MockHttpClientConnectionManager;
import org.apache.juneau.rest.mock2.MockRestClient;
import org.apache.juneau.rest.util.RestUtils;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.transform.BeanInterceptor;
import org.apache.juneau.uon.ParamFormat;

public class MockRestClientBuilder
extends RestClientBuilder {
    protected MockRestClientBuilder(PropertyStore ps) {
        super(ps);
    }

    protected MockRestClientBuilder() {
        super(null);
    }

    public MockRestClientBuilder restBean(Object bean) {
        return this.set("RestClient.restBean.o", bean);
    }

    public MockRestClientBuilder contextPath(String value) {
        return this.set("RestClient.contextPath.s", RestUtils.toValidContextPath((String)value));
    }

    public MockRestClientBuilder servletPath(String value) {
        return this.set("RestClient.servletPath.s", RestUtils.toValidContextPath((String)value));
    }

    public MockRestClientBuilder pathVars(Map<String, String> value) {
        return this.putAllTo("RestClient.pathVars.oms", value);
    }

    public MockRestClientBuilder pathVars(String ... pairs) {
        return this.pathVars((Map<String, String>)AMap.ofPairs((Object[])pairs));
    }

    public MockRestClient build() {
        return this.build(MockRestClient.class);
    }

    public <T extends Context> T build(Class<T> c) {
        MockHttpClientConnectionManager cm = new MockHttpClientConnectionManager();
        this.set("RestClient.mockHttpClientConnectionManager.o", cm);
        this.connectionManager(cm);
        return (T)super.build(c);
    }

    public MockRestClientBuilder add(Map<String, Object> properties) {
        super.add(properties);
        return this;
    }

    public MockRestClientBuilder addTo(String name, Object value) {
        super.addTo(name, value);
        return this;
    }

    public MockRestClientBuilder appendTo(String name, Object value) {
        super.appendTo(name, value);
        return this;
    }

    public MockRestClientBuilder apply(PropertyStore copyFrom) {
        super.apply(copyFrom);
        return this;
    }

    public MockRestClientBuilder applyAnnotations(Class<?> ... fromClasses) {
        super.applyAnnotations((Class[])fromClasses);
        return this;
    }

    public MockRestClientBuilder applyAnnotations(Method ... fromMethods) {
        super.applyAnnotations(fromMethods);
        return this;
    }

    public MockRestClientBuilder applyAnnotations(AnnotationList al, VarResolverSession r) {
        super.applyAnnotations(al, r);
        return this;
    }

    public MockRestClientBuilder debug() {
        super.debug();
        return this;
    }

    public MockRestClientBuilder locale(Locale value) {
        super.locale(value);
        return this;
    }

    public MockRestClientBuilder mediaType(MediaType value) {
        super.mediaType(value);
        return this;
    }

    public MockRestClientBuilder prependTo(String name, Object value) {
        super.prependTo(name, value);
        return this;
    }

    public MockRestClientBuilder putAllTo(String name, Object value) {
        super.putAllTo(name, value);
        return this;
    }

    public MockRestClientBuilder putTo(String name, String key, Object value) {
        super.putTo(name, key, value);
        return this;
    }

    public MockRestClientBuilder removeFrom(String name, Object value) {
        super.removeFrom(name, value);
        return this;
    }

    public MockRestClientBuilder set(Map<String, Object> properties) {
        super.set(properties);
        return this;
    }

    public MockRestClientBuilder set(String name, Object value) {
        super.set(name, value);
        return this;
    }

    public MockRestClientBuilder timeZone(TimeZone value) {
        super.timeZone(value);
        return this;
    }

    public MockRestClientBuilder annotations(Annotation ... values) {
        super.annotations(values);
        return this;
    }

    public MockRestClientBuilder beanClassVisibility(Visibility value) {
        super.beanClassVisibility(value);
        return this;
    }

    public MockRestClientBuilder beanConstructorVisibility(Visibility value) {
        super.beanConstructorVisibility(value);
        return this;
    }

    public MockRestClientBuilder beanFieldVisibility(Visibility value) {
        super.beanFieldVisibility(value);
        return this;
    }

    public MockRestClientBuilder beanInterceptor(Class<?> on, Class<? extends BeanInterceptor<?>> value) {
        super.beanInterceptor(on, value);
        return this;
    }

    public MockRestClientBuilder beanMethodVisibility(Visibility value) {
        super.beanMethodVisibility(value);
        return this;
    }

    public MockRestClientBuilder beansDontRequireSomeProperties() {
        super.beansDontRequireSomeProperties();
        return this;
    }

    public MockRestClientBuilder beansRequireDefaultConstructor() {
        super.beansRequireDefaultConstructor();
        return this;
    }

    public MockRestClientBuilder beansRequireSerializable() {
        super.beansRequireSerializable();
        return this;
    }

    public MockRestClientBuilder beansRequireSettersForGetters() {
        super.beansRequireSettersForGetters();
        return this;
    }

    public MockRestClientBuilder bpi(Map<String, Object> values) {
        super.bpi(values);
        return this;
    }

    public MockRestClientBuilder bpi(Class<?> beanClass, String properties) {
        super.bpi(beanClass, properties);
        return this;
    }

    public MockRestClientBuilder bpi(String beanClassName, String properties) {
        super.bpi(beanClassName, properties);
        return this;
    }

    public MockRestClientBuilder bpro(Map<String, Object> values) {
        super.bpro(values);
        return this;
    }

    public MockRestClientBuilder bpro(Class<?> beanClass, String properties) {
        super.bpro(beanClass, properties);
        return this;
    }

    public MockRestClientBuilder bpro(String beanClassName, String properties) {
        super.bpro(beanClassName, properties);
        return this;
    }

    public MockRestClientBuilder bpwo(Map<String, Object> values) {
        super.bpwo(values);
        return this;
    }

    public MockRestClientBuilder bpwo(Class<?> beanClass, String properties) {
        super.bpwo(beanClass, properties);
        return this;
    }

    public MockRestClientBuilder bpwo(String beanClassName, String properties) {
        super.bpwo(beanClassName, properties);
        return this;
    }

    public MockRestClientBuilder bpx(Map<String, Object> values) {
        super.bpx(values);
        return this;
    }

    public MockRestClientBuilder bpx(Class<?> beanClass, String properties) {
        super.bpx(beanClass, properties);
        return this;
    }

    public MockRestClientBuilder bpx(String beanClassName, String properties) {
        super.bpx(beanClassName, properties);
        return this;
    }

    public MockRestClientBuilder dictionary(Object ... values) {
        super.dictionary(values);
        return this;
    }

    public MockRestClientBuilder dictionaryOn(Class<?> on, Class<?> ... values) {
        super.dictionaryOn(on, (Class[])values);
        return this;
    }

    public MockRestClientBuilder dontIgnorePropertiesWithoutSetters() {
        super.dontIgnorePropertiesWithoutSetters();
        return this;
    }

    public MockRestClientBuilder dontIgnoreTransientFields() {
        super.dontIgnoreTransientFields();
        return this;
    }

    public MockRestClientBuilder dontIgnoreUnknownNullBeanProperties() {
        super.dontIgnoreUnknownNullBeanProperties();
        return this;
    }

    public MockRestClientBuilder dontUseInterfaceProxies() {
        super.dontUseInterfaceProxies();
        return this;
    }

    public MockRestClientBuilder fluentSetters() {
        super.fluentSetters();
        return this;
    }

    public MockRestClientBuilder fluentSetters(Class<?> on) {
        super.fluentSetters(on);
        return this;
    }

    public MockRestClientBuilder ignoreInvocationExceptionsOnGetters() {
        super.ignoreInvocationExceptionsOnGetters();
        return this;
    }

    public MockRestClientBuilder ignoreInvocationExceptionsOnSetters() {
        super.ignoreInvocationExceptionsOnSetters();
        return this;
    }

    public MockRestClientBuilder ignoreUnknownBeanProperties() {
        super.ignoreUnknownBeanProperties();
        return this;
    }

    public MockRestClientBuilder implClass(Class<?> interfaceClass, Class<?> implClass) {
        super.implClass(interfaceClass, implClass);
        return this;
    }

    public MockRestClientBuilder implClasses(Map<Class<?>, Class<?>> values) {
        super.implClasses(values);
        return this;
    }

    public MockRestClientBuilder interfaceClass(Class<?> on, Class<?> value) {
        super.interfaceClass(on, value);
        return this;
    }

    public MockRestClientBuilder interfaces(Class<?> ... value) {
        super.interfaces((Class[])value);
        return this;
    }

    public MockRestClientBuilder notBeanClasses(Object ... values) {
        super.notBeanClasses(values);
        return this;
    }

    public MockRestClientBuilder notBeanPackages(Object ... values) {
        super.notBeanPackages(values);
        return this;
    }

    public MockRestClientBuilder propertyNamer(Class<? extends PropertyNamer> value) {
        super.propertyNamer(value);
        return this;
    }

    public MockRestClientBuilder propertyNamer(Class<?> on, Class<? extends PropertyNamer> value) {
        super.propertyNamer(on, value);
        return this;
    }

    public MockRestClientBuilder sortProperties() {
        super.sortProperties();
        return this;
    }

    public MockRestClientBuilder sortProperties(Class<?> ... on) {
        super.sortProperties((Class[])on);
        return this;
    }

    public MockRestClientBuilder stopClass(Class<?> on, Class<?> value) {
        super.stopClass(on, value);
        return this;
    }

    public MockRestClientBuilder swaps(Object ... values) {
        super.swaps(values);
        return this;
    }

    public MockRestClientBuilder typeName(Class<?> on, String value) {
        super.typeName(on, value);
        return this;
    }

    public MockRestClientBuilder typePropertyName(String value) {
        super.typePropertyName(value);
        return this;
    }

    public MockRestClientBuilder typePropertyName(Class<?> on, String value) {
        super.typePropertyName(on, value);
        return this;
    }

    public MockRestClientBuilder useEnumNames() {
        super.useEnumNames();
        return this;
    }

    public MockRestClientBuilder useJavaBeanIntrospector() {
        super.useJavaBeanIntrospector();
        return this;
    }

    public MockRestClientBuilder accept(Object value) {
        super.accept(value);
        return this;
    }

    public MockRestClientBuilder acceptCharset(Object value) {
        super.acceptCharset(value);
        return this;
    }

    public MockRestClientBuilder acceptEncoding(Object value) {
        super.acceptEncoding(value);
        return this;
    }

    public MockRestClientBuilder acceptLanguage(Object value) {
        super.acceptLanguage(value);
        return this;
    }

    public MockRestClientBuilder addBeanTypes() {
        super.addBeanTypes();
        return this;
    }

    public MockRestClientBuilder addInterceptorFirst(HttpRequestInterceptor itcp) {
        super.addInterceptorFirst(itcp);
        return this;
    }

    public MockRestClientBuilder addInterceptorFirst(HttpResponseInterceptor itcp) {
        super.addInterceptorFirst(itcp);
        return this;
    }

    public MockRestClientBuilder addInterceptorLast(HttpRequestInterceptor itcp) {
        super.addInterceptorLast(itcp);
        return this;
    }

    public MockRestClientBuilder addInterceptorLast(HttpResponseInterceptor itcp) {
        super.addInterceptorLast(itcp);
        return this;
    }

    public MockRestClientBuilder addRootType() {
        super.addRootType();
        return this;
    }

    public MockRestClientBuilder authorization(Object value) {
        super.authorization(value);
        return this;
    }

    public MockRestClientBuilder backoffManager(BackoffManager backoffManager) {
        super.backoffManager(backoffManager);
        return this;
    }

    public MockRestClientBuilder basicAuth(String host, int port, String user, String pw) {
        super.basicAuth(host, port, user, pw);
        return this;
    }

    public MockRestClientBuilder cacheControl(Object value) {
        super.cacheControl(value);
        return this;
    }

    public MockRestClientBuilder callHandler(Class<? extends RestCallHandler> value) {
        super.callHandler(value);
        return this;
    }

    public MockRestClientBuilder callHandler(RestCallHandler value) {
        super.callHandler(value);
        return this;
    }

    public MockRestClientBuilder clientVersion(Object value) {
        super.clientVersion(value);
        return this;
    }

    public MockRestClientBuilder connection(Object value) {
        super.connection(value);
        return this;
    }

    public MockRestClientBuilder connectionBackoffStrategy(ConnectionBackoffStrategy connectionBackoffStrategy) {
        super.connectionBackoffStrategy(connectionBackoffStrategy);
        return this;
    }

    public MockRestClientBuilder connectionManager(HttpClientConnectionManager connManager) {
        super.connectionManager(connManager);
        return this;
    }

    public MockRestClientBuilder connectionManagerShared(boolean shared) {
        super.connectionManagerShared(shared);
        return this;
    }

    public MockRestClientBuilder connectionReuseStrategy(ConnectionReuseStrategy reuseStrategy) {
        super.connectionReuseStrategy(reuseStrategy);
        return this;
    }

    public MockRestClientBuilder connectionTimeToLive(long connTimeToLive, TimeUnit connTimeToLiveTimeUnit) {
        super.connectionTimeToLive(connTimeToLive, connTimeToLiveTimeUnit);
        return this;
    }

    public MockRestClientBuilder console(PrintStream value) {
        super.console(value);
        return this;
    }

    public MockRestClientBuilder console(Class<? extends PrintStream> value) {
        super.console(value);
        return this;
    }

    public MockRestClientBuilder contentDecoderRegistry(Map<String, InputStreamFactory> contentDecoderMap) {
        super.contentDecoderRegistry(contentDecoderMap);
        return this;
    }

    public MockRestClientBuilder contentEncoding(Object value) {
        super.contentEncoding(value);
        return this;
    }

    public MockRestClientBuilder contentLength(Object value) {
        super.contentLength(value);
        return this;
    }

    public MockRestClientBuilder contentType(Object value) {
        super.contentType(value);
        return this;
    }

    public MockRestClientBuilder date(Object value) {
        super.date(value);
        return this;
    }

    public MockRestClientBuilder debugOutputLines(int value) {
        super.debugOutputLines(value);
        return this;
    }

    public MockRestClientBuilder defaultAuthSchemeRegistry(Lookup<AuthSchemeProvider> authSchemeRegistry) {
        super.defaultAuthSchemeRegistry(authSchemeRegistry);
        return this;
    }

    public MockRestClientBuilder defaultConnectionConfig(ConnectionConfig config) {
        super.defaultConnectionConfig(config);
        return this;
    }

    public MockRestClientBuilder defaultCookieSpecRegistry(Lookup<CookieSpecProvider> cookieSpecRegistry) {
        super.defaultCookieSpecRegistry(cookieSpecRegistry);
        return this;
    }

    public MockRestClientBuilder defaultCookieStore(CookieStore cookieStore) {
        super.defaultCookieStore(cookieStore);
        return this;
    }

    public MockRestClientBuilder defaultCredentialsProvider(CredentialsProvider credentialsProvider) {
        super.defaultCredentialsProvider(credentialsProvider);
        return this;
    }

    public MockRestClientBuilder defaultHeaders(Collection<? extends Header> defaultHeaders) {
        super.defaultHeaders(defaultHeaders);
        return this;
    }

    public MockRestClientBuilder defaultRequestConfig(RequestConfig config) {
        super.defaultRequestConfig(config);
        return this;
    }

    public MockRestClientBuilder defaultSocketConfig(SocketConfig config) {
        super.defaultSocketConfig(config);
        return this;
    }

    public MockRestClientBuilder detectRecursions() {
        super.detectRecursions();
        return this;
    }

    public MockRestClientBuilder disableAuthCaching() {
        super.disableAuthCaching();
        return this;
    }

    public MockRestClientBuilder disableAutomaticRetries() {
        super.disableAutomaticRetries();
        return this;
    }

    public MockRestClientBuilder disableConnectionState() {
        super.disableConnectionState();
        return this;
    }

    public MockRestClientBuilder disableContentCompression() {
        super.disableContentCompression();
        return this;
    }

    public MockRestClientBuilder disableCookieManagement() {
        super.disableCookieManagement();
        return this;
    }

    public MockRestClientBuilder disableRedirectHandling() {
        super.disableRedirectHandling();
        return this;
    }

    public MockRestClientBuilder errorCodes(Predicate<Integer> value) {
        super.errorCodes(value);
        return this;
    }

    public MockRestClientBuilder evictExpiredConnections() {
        super.evictExpiredConnections();
        return this;
    }

    public MockRestClientBuilder evictIdleConnections(long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        super.evictIdleConnections(maxIdleTime, maxIdleTimeUnit);
        return this;
    }

    public MockRestClientBuilder executorService(ExecutorService executorService, boolean shutdownOnClose) {
        super.executorService(executorService, shutdownOnClose);
        return this;
    }

    public MockRestClientBuilder expect(Object value) {
        super.expect(value);
        return this;
    }

    public MockRestClientBuilder formData(NameValuePair pair) {
        super.formData(pair);
        return this;
    }

    public MockRestClientBuilder formData(String name, Object value) {
        super.formData(name, value);
        return this;
    }

    public MockRestClientBuilder formData(String name, Supplier<?> value) {
        super.formData(name, value);
        return this;
    }

    public MockRestClientBuilder formData(String name, Object value, HttpPartSchema schema) {
        super.formData(name, value, schema);
        return this;
    }

    public MockRestClientBuilder formData(String name, Supplier<?> value, HttpPartSchema schema) {
        super.formData(name, value, schema);
        return this;
    }

    public MockRestClientBuilder formData(String name, Object value, HttpPartSchema schema, HttpPartSerializer serializer) {
        super.formData(name, value, schema, serializer);
        return this;
    }

    public MockRestClientBuilder formData(String name, Supplier<?> value, HttpPartSchema schema, HttpPartSerializer serializer) {
        super.formData(name, value, schema, serializer);
        return this;
    }

    public MockRestClientBuilder formDataPairs(Object ... pairs) {
        super.formDataPairs(pairs);
        return this;
    }

    public MockRestClientBuilder formDatas(Object ... params) {
        super.formDatas(params);
        return this;
    }

    public MockRestClientBuilder forwarded(Object value) {
        super.forwarded(value);
        return this;
    }

    public MockRestClientBuilder from(Object value) {
        super.from(value);
        return this;
    }

    public MockRestClientBuilder header(Header header) {
        super.header(header);
        return this;
    }

    public MockRestClientBuilder header(String name, Object value) {
        super.header(name, value);
        return this;
    }

    public MockRestClientBuilder header(String name, Supplier<?> value) {
        super.header(name, value);
        return this;
    }

    public MockRestClientBuilder header(String name, Object value, HttpPartSchema schema) {
        super.header(name, value, schema);
        return this;
    }

    public MockRestClientBuilder header(String name, Supplier<?> value, HttpPartSchema schema) {
        super.header(name, value, schema);
        return this;
    }

    public MockRestClientBuilder header(String name, Object value, HttpPartSchema schema, HttpPartSerializer serializer) {
        super.header(name, value, schema, serializer);
        return this;
    }

    public MockRestClientBuilder header(String name, Supplier<?> value, HttpPartSchema schema, HttpPartSerializer serializer) {
        super.header(name, value, schema, serializer);
        return this;
    }

    public MockRestClientBuilder headerPairs(Object ... pairs) {
        super.headerPairs(pairs);
        return this;
    }

    public MockRestClientBuilder headers(Object ... headers) {
        super.headers(headers);
        return this;
    }

    public MockRestClientBuilder host(Object value) {
        super.host(value);
        return this;
    }

    public MockRestClientBuilder html() {
        super.html();
        return this;
    }

    public MockRestClientBuilder htmlDoc() {
        super.htmlDoc();
        return this;
    }

    public MockRestClientBuilder htmlStrippedDoc() {
        super.htmlStrippedDoc();
        return this;
    }

    public MockRestClientBuilder httpClient(CloseableHttpClient value) {
        super.httpClient(value);
        return this;
    }

    public MockRestClientBuilder httpClientBuilder(HttpClientBuilder value) {
        super.httpClientBuilder(value);
        return this;
    }

    public MockRestClientBuilder httpProcessor(HttpProcessor httpprocessor) {
        super.httpProcessor(httpprocessor);
        return this;
    }

    public MockRestClientBuilder ifMatch(Object value) {
        super.ifMatch(value);
        return this;
    }

    public MockRestClientBuilder ifModifiedSince(Object value) {
        super.ifModifiedSince(value);
        return this;
    }

    public MockRestClientBuilder ifNoneMatch(Object value) {
        super.ifNoneMatch(value);
        return this;
    }

    public MockRestClientBuilder ifRange(Object value) {
        super.ifRange(value);
        return this;
    }

    public MockRestClientBuilder ifUnmodifiedSince(Object value) {
        super.ifUnmodifiedSince(value);
        return this;
    }

    public MockRestClientBuilder ignoreErrors() {
        super.ignoreErrors();
        return this;
    }

    public MockRestClientBuilder ignoreErrors(boolean value) {
        super.ignoreErrors(value);
        return this;
    }

    public MockRestClientBuilder ignoreRecursions() {
        super.ignoreRecursions();
        return this;
    }

    public MockRestClientBuilder initialDepth(int value) {
        super.initialDepth(value);
        return this;
    }

    public MockRestClientBuilder interceptors(Class<?> ... values) throws Exception {
        super.interceptors((Class[])values);
        return this;
    }

    public MockRestClientBuilder interceptors(Object ... value) {
        super.interceptors(value);
        return this;
    }

    public MockRestClientBuilder json() {
        super.json();
        return this;
    }

    public MockRestClientBuilder keepAliveStrategy(ConnectionKeepAliveStrategy keepAliveStrategy) {
        super.keepAliveStrategy(keepAliveStrategy);
        return this;
    }

    public MockRestClientBuilder keepHttpClientOpen() {
        super.keepHttpClientOpen();
        return this;
    }

    public MockRestClientBuilder keepNullProperties() {
        super.keepNullProperties();
        return this;
    }

    public MockRestClientBuilder leakDetection() {
        super.leakDetection();
        return this;
    }

    public MockRestClientBuilder logRequests(DetailLevel detail, Level level, BiPredicate<RestRequest, RestResponse> test) {
        super.logRequests(detail, level, test);
        return this;
    }

    public MockRestClientBuilder logToConsole() {
        super.logToConsole();
        return this;
    }

    public MockRestClientBuilder logger(Logger value) {
        super.logger(value);
        return this;
    }

    public MockRestClientBuilder marshall(Marshall value) {
        super.marshall(value);
        return this;
    }

    public MockRestClientBuilder marshalls(Marshall ... value) {
        super.marshalls(value);
        return this;
    }

    public MockRestClientBuilder maxConnPerRoute(int maxConnPerRoute) {
        super.maxConnPerRoute(maxConnPerRoute);
        return this;
    }

    public MockRestClientBuilder maxConnTotal(int maxConnTotal) {
        super.maxConnTotal(maxConnTotal);
        return this;
    }

    public MockRestClientBuilder maxDepth(int value) {
        super.maxDepth(value);
        return this;
    }

    public MockRestClientBuilder maxForwards(Object value) {
        super.maxForwards(value);
        return this;
    }

    public MockRestClientBuilder maxIndent(int value) {
        super.maxIndent(value);
        return this;
    }

    public MockRestClientBuilder msgPack() {
        super.msgPack();
        return this;
    }

    public MockRestClientBuilder noTrace() {
        super.noTrace();
        return this;
    }

    public MockRestClientBuilder oapiCollectionFormat(HttpPartCollectionFormat value) {
        super.oapiCollectionFormat(value);
        return this;
    }

    public MockRestClientBuilder oapiFormat(HttpPartFormat value) {
        super.oapiFormat(value);
        return this;
    }

    public MockRestClientBuilder openApi() {
        super.openApi();
        return this;
    }

    public MockRestClientBuilder origin(Object value) {
        super.origin(value);
        return this;
    }

    public MockRestClientBuilder paramFormat(ParamFormat value) {
        super.paramFormat(value);
        return this;
    }

    public MockRestClientBuilder paramFormatPlain() {
        super.paramFormatPlain();
        return this;
    }

    public MockRestClientBuilder parser(Class<? extends Parser> value) {
        super.parser(value);
        return this;
    }

    public MockRestClientBuilder parser(Parser value) {
        super.parser(value);
        return this;
    }

    public MockRestClientBuilder parsers(Class<? extends Parser> ... value) {
        super.parsers((Class[])value);
        return this;
    }

    public MockRestClientBuilder parsers(Parser ... value) {
        super.parsers(value);
        return this;
    }

    public MockRestClientBuilder partParser(Class<? extends HttpPartParser> value) {
        super.partParser(value);
        return this;
    }

    public MockRestClientBuilder partParser(HttpPartParser value) {
        super.partParser(value);
        return this;
    }

    public MockRestClientBuilder partSerializer(Class<? extends HttpPartSerializer> value) {
        super.partSerializer(value);
        return this;
    }

    public MockRestClientBuilder partSerializer(HttpPartSerializer value) {
        super.partSerializer(value);
        return this;
    }

    public MockRestClientBuilder plainText() {
        super.plainText();
        return this;
    }

    public MockRestClientBuilder pooled() {
        super.pooled();
        return this;
    }

    public MockRestClientBuilder pragma(Object value) {
        super.pragma(value);
        return this;
    }

    public MockRestClientBuilder proxy(HttpHost proxy) {
        super.proxy(proxy);
        return this;
    }

    public MockRestClientBuilder proxyAuthenticationStrategy(AuthenticationStrategy proxyAuthStrategy) {
        super.proxyAuthenticationStrategy(proxyAuthStrategy);
        return this;
    }

    public MockRestClientBuilder proxyAuthorization(Object value) {
        super.proxyAuthorization(value);
        return this;
    }

    public MockRestClientBuilder publicSuffixMatcher(PublicSuffixMatcher publicSuffixMatcher) {
        super.publicSuffixMatcher(publicSuffixMatcher);
        return this;
    }

    public MockRestClientBuilder queries(Object ... params) {
        super.queries(params);
        return this;
    }

    public MockRestClientBuilder query(NameValuePair pair) {
        super.query(pair);
        return this;
    }

    public MockRestClientBuilder query(String name, Object value) {
        super.query(name, value);
        return this;
    }

    public MockRestClientBuilder query(String name, Supplier<?> value) {
        super.query(name, value);
        return this;
    }

    public MockRestClientBuilder query(String name, Object value, HttpPartSchema schema) {
        super.query(name, value, schema);
        return this;
    }

    public MockRestClientBuilder query(String name, Supplier<?> value, HttpPartSchema schema) {
        super.query(name, value, schema);
        return this;
    }

    public MockRestClientBuilder query(String name, Object value, HttpPartSchema schema, HttpPartSerializer serializer) {
        super.query(name, value, schema, serializer);
        return this;
    }

    public MockRestClientBuilder query(String name, Supplier<?> value, HttpPartSchema schema, HttpPartSerializer serializer) {
        super.query(name, value, schema, serializer);
        return this;
    }

    public MockRestClientBuilder queryPairs(Object ... pairs) {
        super.queryPairs(pairs);
        return this;
    }

    public MockRestClientBuilder quoteChar(char value) {
        super.quoteChar(value);
        return this;
    }

    public MockRestClientBuilder range(Object value) {
        super.range(value);
        return this;
    }

    public MockRestClientBuilder redirectStrategy(RedirectStrategy redirectStrategy) {
        super.redirectStrategy(redirectStrategy);
        return this;
    }

    public MockRestClientBuilder referer(Object value) {
        super.referer(value);
        return this;
    }

    public MockRestClientBuilder requestExecutor(HttpRequestExecutor requestExec) {
        super.requestExecutor(requestExec);
        return this;
    }

    public MockRestClientBuilder retryHandler(HttpRequestRetryHandler retryHandler) {
        super.retryHandler(retryHandler);
        return this;
    }

    public MockRestClientBuilder rootUri(Object value) {
        super.rootUri(value);
        return this;
    }

    public MockRestClientBuilder routePlanner(HttpRoutePlanner routePlanner) {
        super.routePlanner(routePlanner);
        return this;
    }

    public MockRestClientBuilder schemePortResolver(SchemePortResolver schemePortResolver) {
        super.schemePortResolver(schemePortResolver);
        return this;
    }

    public MockRestClientBuilder serializer(Class<? extends Serializer> value) {
        super.serializer(value);
        return this;
    }

    public MockRestClientBuilder serializer(Serializer value) {
        super.serializer(value);
        return this;
    }

    public MockRestClientBuilder serializers(Class<? extends Serializer> ... value) {
        super.serializers((Class[])value);
        return this;
    }

    public MockRestClientBuilder serializers(Serializer ... value) {
        super.serializers(value);
        return this;
    }

    public MockRestClientBuilder serviceUnavailableRetryStrategy(ServiceUnavailableRetryStrategy serviceUnavailStrategy) {
        super.serviceUnavailableRetryStrategy(serviceUnavailStrategy);
        return this;
    }

    public MockRestClientBuilder simpleJson() {
        super.simpleJson();
        return this;
    }

    public MockRestClientBuilder sortCollections() {
        super.sortCollections();
        return this;
    }

    public MockRestClientBuilder sortMaps() {
        super.sortMaps();
        return this;
    }

    public MockRestClientBuilder sq() {
        super.sq();
        return this;
    }

    public MockRestClientBuilder sslContext(SSLContext sslContext) {
        super.sslContext(sslContext);
        return this;
    }

    public MockRestClientBuilder sslHostnameVerifier(HostnameVerifier hostnameVerifier) {
        super.sslHostnameVerifier(hostnameVerifier);
        return this;
    }

    public MockRestClientBuilder sslSocketFactory(LayeredConnectionSocketFactory sslSocketFactory) {
        super.sslSocketFactory(sslSocketFactory);
        return this;
    }

    public MockRestClientBuilder strict() {
        super.strict();
        return this;
    }

    public MockRestClientBuilder targetAuthenticationStrategy(AuthenticationStrategy targetAuthStrategy) {
        super.targetAuthenticationStrategy(targetAuthStrategy);
        return this;
    }

    public MockRestClientBuilder te(Object value) {
        super.te(value);
        return this;
    }

    public MockRestClientBuilder trimEmptyCollections() {
        super.trimEmptyCollections();
        return this;
    }

    public MockRestClientBuilder trimEmptyMaps() {
        super.trimEmptyMaps();
        return this;
    }

    public MockRestClientBuilder trimStringsOnRead() {
        super.trimStringsOnRead();
        return this;
    }

    public MockRestClientBuilder trimStringsOnWrite() {
        super.trimStringsOnWrite();
        return this;
    }

    public MockRestClientBuilder uon() {
        super.uon();
        return this;
    }

    public MockRestClientBuilder upgrade(Object value) {
        super.upgrade(value);
        return this;
    }

    public MockRestClientBuilder uriContext(UriContext value) {
        super.uriContext(value);
        return this;
    }

    public MockRestClientBuilder uriRelativity(UriRelativity value) {
        super.uriRelativity(value);
        return this;
    }

    public MockRestClientBuilder uriResolution(UriResolution value) {
        super.uriResolution(value);
        return this;
    }

    public MockRestClientBuilder urlEnc() {
        super.urlEnc();
        return this;
    }

    public MockRestClientBuilder useSystemProperties() {
        super.useSystemProperties();
        return this;
    }

    public MockRestClientBuilder useWhitespace() {
        super.useWhitespace();
        return this;
    }

    public MockRestClientBuilder userAgent(Object value) {
        super.userAgent(value);
        return this;
    }

    public MockRestClientBuilder userAgent(String userAgent) {
        super.userAgent(userAgent);
        return this;
    }

    public MockRestClientBuilder userTokenHandler(UserTokenHandler userTokenHandler) {
        super.userTokenHandler(userTokenHandler);
        return this;
    }

    public MockRestClientBuilder via(Object value) {
        super.via(value);
        return this;
    }

    public MockRestClientBuilder warning(Object value) {
        super.warning(value);
        return this;
    }

    public MockRestClientBuilder ws() {
        super.ws();
        return this;
    }

    public MockRestClientBuilder xml() {
        super.xml();
        return this;
    }
}

