/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.assertions;

import org.apache.juneau.BasicAssertionError;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.StringUtils;

public class Assertion {
    String msg;
    Object[] msgArgs;
    boolean stdout;
    boolean stderr;

    protected Assertion(Assertion creator) {
        if (creator != null) {
            this.msg = creator.msg;
            this.msgArgs = creator.msgArgs;
            this.stdout = creator.stdout;
            this.stderr = creator.stderr;
        }
    }

    @FluentSetter
    public Assertion msg(String msg, Object ... args) {
        this.msg = msg.replace("{msg}", "<<<MSG>>>");
        this.msgArgs = args;
        return this;
    }

    @FluentSetter
    public Assertion stdout() {
        this.stdout = true;
        return this;
    }

    @FluentSetter
    public Assertion stderr() {
        this.stderr = true;
        return this;
    }

    protected BasicAssertionError error(String msg, Object ... args) {
        msg = StringUtils.format(msg, args);
        if (this.msg != null) {
            msg = StringUtils.format(this.msg, this.msgArgs).replace("<<<MSG>>>", msg);
        }
        if (this.stdout) {
            System.out.println(msg);
        }
        if (this.stderr) {
            System.err.println(msg);
        }
        return new BasicAssertionError(msg, new Object[0]);
    }

    protected static String className(Object o) {
        return ClassUtils.className(o);
    }

    protected Object assertNotNull(Object value, String msg, Object ... args) {
        if (value == null) {
            throw new BasicAssertionError(StringUtils.format(msg, args), new Object[0]);
        }
        return value;
    }

    protected Object assertNotNull(String parameter, Object value) {
        return this.assertNotNull(value, "Parameter ''{0}'' cannot be null.", parameter);
    }
}

