/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.assertions;

import org.apache.juneau.assertions.Assertion;
import org.apache.juneau.assertions.FluentObjectAssertion;
import org.apache.juneau.internal.FluentSetters;

@FluentSetters(returns="FluentComparableAssertion<R>")
public class FluentComparableAssertion<R>
extends FluentObjectAssertion<R> {
    private final Comparable value;

    public FluentComparableAssertion(Comparable value, R returns) {
        this(null, value, returns);
    }

    public FluentComparableAssertion(Assertion creator, Comparable value, R returns) {
        super(creator, value, returns);
        this.value = value;
    }

    public R isGreaterThan(Comparable value) throws AssertionError {
        this.exists();
        this.assertNotNull("value", value);
        if (this.compareTo(value) <= 0) {
            throw this.error("Value was not greater than expected.\n\tExpected=[{0}]\n\tActual=[{1}]", value, this.value);
        }
        return this.returns();
    }

    public R isGt(Comparable value) throws AssertionError {
        return this.isGreaterThan(value);
    }

    public R isGreaterThanOrEqual(Comparable value) throws AssertionError {
        this.exists();
        this.assertNotNull("value", value);
        if (this.compareTo(value) < 0) {
            throw this.error("Value was not greater than or equals to expected.\n\tExpected=[{0}]\n\tActual=[{1}]", value, this.value);
        }
        return this.returns();
    }

    public R isGte(Comparable value) throws AssertionError {
        return this.isGreaterThanOrEqual(value);
    }

    public R isLessThan(Comparable value) throws AssertionError {
        this.exists();
        this.assertNotNull("value", value);
        if (this.compareTo(value) >= 0) {
            throw this.error("Value was not less than expected.\n\tExpected=[{0}]\n\tActual=[{1}]", value, this.value);
        }
        return this.returns();
    }

    public R isLt(Comparable value) throws AssertionError {
        return this.isLessThan(value);
    }

    public R isLessThanOrEqual(Comparable value) throws AssertionError {
        this.exists();
        this.assertNotNull("value", value);
        if (this.compareTo(value) > 0) {
            throw this.error("Value was not less than or equals to expected.\n\tExpected=[{0}]\n\tActual=[{1}]", value, this.value);
        }
        return this.returns();
    }

    public R isLte(Comparable value) throws AssertionError {
        return this.isLessThanOrEqual(value);
    }

    public R isBetween(Comparable lower, Comparable upper) throws AssertionError {
        this.exists();
        this.assertNotNull("lower", lower);
        this.assertNotNull("upper", upper);
        this.isLessThanOrEqual(upper);
        this.isGreaterThanOrEqual(lower);
        return this.returns();
    }

    protected int compareTo(Object value) {
        return this.value.compareTo(this.equivalent(value));
    }

    @Override
    public FluentComparableAssertion<R> msg(String msg, Object ... args) {
        super.msg(msg, args);
        return this;
    }

    @Override
    public FluentComparableAssertion<R> stderr() {
        super.stderr();
        return this;
    }

    @Override
    public FluentComparableAssertion<R> stdout() {
        super.stdout();
        return this;
    }
}

