/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http;

import java.io.Serializable;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.message.BasicHeaderValueParser;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.http.Headerable;
import org.apache.juneau.http.NameValuePairable;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.reflect.ClassInfo;

@BeanIgnore
public class BasicHeader
implements Header,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final HeaderElement[] EMPTY_HEADER_ELEMENTS = new HeaderElement[0];
    private final String name;
    private final Object value;
    private HeaderElement[] elements;

    public static BasicHeader of(String name, Object value) {
        return new BasicHeader(name, value);
    }

    public static BasicHeader ofPair(String pair) {
        if (pair == null) {
            return null;
        }
        int i = pair.indexOf(58);
        if (i == -1) {
            return BasicHeader.of(pair, "");
        }
        return BasicHeader.of(pair.substring(0, i).trim(), pair.substring(i + 1).trim());
    }

    public static Header of(NameValuePair o) {
        return new BasicHeader(o.getName(), o.getValue());
    }

    public static BasicHeader of(String name, Supplier<?> value) {
        return new BasicHeader(name, value);
    }

    public static Header cast(Object o) {
        if (o instanceof Header) {
            return (Header)o;
        }
        if (o instanceof Headerable) {
            return ((Headerable)o).asHeader();
        }
        if (o instanceof NameValuePair) {
            return BasicHeader.of((NameValuePair)o);
        }
        if (o instanceof NameValuePairable) {
            return BasicHeader.of(((NameValuePairable)o).asNameValuePair());
        }
        if (o instanceof Map.Entry) {
            Map.Entry e = (Map.Entry)o;
            return BasicHeader.of(StringUtils.stringify(e.getKey()), e.getValue());
        }
        throw new BasicRuntimeException("Object of type {0} could not be converted to a Header.", o == null ? null : o.getClass().getName());
    }

    public static boolean canCast(Object o) {
        ClassInfo ci = ClassInfo.of(o);
        return ci != null && ci.isChildOfAny(Header.class, Headerable.class, NameValuePair.class, NameValuePairable.class, Map.Entry.class);
    }

    public BasicHeader(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return StringUtils.stringify(this.getRawValue());
    }

    protected Object getRawValue() {
        return BasicHeader.unwrap(this.value);
    }

    public HeaderElement[] getElements() throws ParseException {
        if (this.elements == null) {
            HeaderElement[] x;
            String s = this.getValue();
            HeaderElement[] headerElementArray = x = s == null ? EMPTY_HEADER_ELEMENTS : BasicHeaderValueParser.parseElements((String)s, null);
            if (this.value instanceof Supplier) {
                return x;
            }
            this.elements = x;
        }
        return this.elements;
    }

    protected boolean eqIC(String compare) {
        return StringUtils.isEqualsIc(this.getValue(), compare);
    }

    public FluentStringAssertion<BasicHeader> assertName() {
        return new FluentStringAssertion<BasicHeader>(this.getName(), this);
    }

    public FluentStringAssertion<BasicHeader> assertValue() {
        return new FluentStringAssertion<BasicHeader>(this.getValue(), this);
    }

    protected boolean isSupplier(Object o) {
        return o instanceof Supplier;
    }

    protected static Object unwrap(Object o) {
        return ObjectUtils.unwrap(o);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Header)) {
            return false;
        }
        return ObjectUtils.eq(this, (Header)o, (x, y) -> ObjectUtils.eq(x.name, y.getName()) && ObjectUtils.eq(x.getValue(), y.getValue()));
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.name + ": " + this.getValue();
    }
}

