/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.cp;

import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.cp.Messages;
import org.apache.juneau.internal.ResourceBundleUtils;
import org.apache.juneau.internal.StringUtils;

public class MessagesBuilder {
    private Class<?> forClass;
    private Locale locale = Locale.getDefault();
    private String name;
    private Messages parent;
    private String[] baseNames = new String[]{"{package}.{name}", "{package}.i18n.{name}", "{package}.nls.{name}", "{package}.messages.{name}"};

    MessagesBuilder(Class<?> forClass) {
        this.forClass = forClass;
        this.name = forClass.getSimpleName();
    }

    public MessagesBuilder parent(Messages parent) {
        this.parent = parent;
        return this;
    }

    public MessagesBuilder name(String name) {
        this.name = StringUtils.isEmpty(name) ? this.forClass.getSimpleName() : name;
        return this;
    }

    public MessagesBuilder baseNames(String ... baseNames) {
        this.baseNames = baseNames == null ? new String[]{} : baseNames;
        return this;
    }

    public MessagesBuilder locale(Locale locale) {
        this.locale = locale == null ? Locale.getDefault() : locale;
        return this;
    }

    public Messages build() {
        return new Messages(this.forClass, this.getBundle(), this.locale, this.parent);
    }

    private ResourceBundle getBundle() {
        ClassLoader cl = this.forClass.getClassLoader();
        OMap m = OMap.of(new Object[]{"name", this.name, "package", this.forClass.getPackage().getName()});
        for (String bn : this.baseNames) {
            ResourceBundle rb = ResourceBundleUtils.findBundle(bn = StringUtils.replaceVars(bn, m), this.locale, cl);
            if (rb == null) continue;
            return rb;
        }
        return null;
    }
}

