/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.activation.MimetypesFileTypeMap;
import org.apache.juneau.cp.ResourceManager;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.rest.StaticFile;
import org.apache.juneau.rest.StaticFileMapping;

class StaticFiles {
    private final String path;
    private final String location;
    private final Map<String, Object> responseHeaders;
    private final ResourceManager staticResourceManager;
    private final MimetypesFileTypeMap mimetypesFileTypeMap;

    StaticFiles(StaticFileMapping sfm, ResourceManager staticResourceManager, MimetypesFileTypeMap mimetypesFileTypeMap, Map<String, Object> staticFileResponseHeaders) {
        this.path = sfm.path;
        this.location = sfm.location;
        this.responseHeaders = sfm.responseHeaders != null ? sfm.responseHeaders : staticFileResponseHeaders;
        this.staticResourceManager = staticResourceManager;
        this.mimetypesFileTypeMap = mimetypesFileTypeMap;
    }

    String getPath() {
        return this.path;
    }

    StaticFile resolve(String p) throws IOException {
        if (p.startsWith(this.path)) {
            String remainder;
            String string = remainder = p.equals(this.path) ? "" : p.substring(this.path.length());
            if (remainder.isEmpty() || remainder.startsWith("/")) {
                String p2 = this.location + remainder;
                try (InputStream is = this.staticResourceManager.getStream(p2, null);){
                    if (is != null) {
                        int i = p2.lastIndexOf(47);
                        String name = i == -1 ? p2 : p2.substring(i + 1);
                        String mediaType = this.mimetypesFileTypeMap.getContentType(name);
                        StaticFile staticFile = new StaticFile(IOUtils.readBytes(is), mediaType, this.responseHeaders);
                        return staticFile;
                    }
                }
            }
        }
        return null;
    }
}

