/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.assertions;

import java.io.PrintStream;
import java.lang.reflect.Array;
import org.apache.juneau.BasicAssertionError;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.cp.Messages;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.ThrowableUtils;

@FluentSetters
public class Assertion {
    private static final Messages MESSAGES = Messages.of(Assertion.class, "Messages");
    static final String MSG_parameterCannotBeNull = MESSAGES.getString("parameterCannotBeNull");
    static final String MSG_causedBy = MESSAGES.getString("causedBy");
    private String msg;
    private Object[] msgArgs;
    private PrintStream out = System.err;
    private Class<? extends RuntimeException> throwable;

    protected Assertion(Assertion creator) {
        if (creator != null) {
            this.msg = creator.msg;
            this.msgArgs = creator.msgArgs;
            this.out = creator.out;
            this.throwable = creator.throwable;
        }
    }

    @FluentSetter
    public Assertion setMsg(String msg, Object ... args) {
        this.msg = msg.replace("{msg}", "<<<MSG>>>");
        this.msgArgs = args;
        return this;
    }

    @FluentSetter
    public Assertion setStdOut() {
        return this.setOut(System.out);
    }

    @FluentSetter
    public Assertion setOut(PrintStream value) {
        this.out = value;
        return this;
    }

    @FluentSetter
    public Assertion setSilent() {
        return this.setOut(null);
    }

    @FluentSetter
    public Assertion setThrowable(Class<? extends RuntimeException> value) {
        this.throwable = value;
        return this;
    }

    protected BasicAssertionError error(String msg, Object ... args) {
        return this.error(null, msg, args);
    }

    protected BasicAssertionError error(Throwable cause, String msg, Object ... args) {
        msg = StringUtils.format(msg, args);
        if (this.msg != null) {
            msg = StringUtils.format(this.msg, this.msgArgs).replace("<<<MSG>>>", msg);
        }
        if (this.out != null) {
            this.out.println(msg);
        }
        if (this.throwable != null) {
            try {
                throw BeanStore.create().build().addBean(Throwable.class, cause).addBean(String.class, msg).addBean(Object[].class, new Object[0]).createBean(this.throwable).run();
            }
            catch (ExecutableException e) {
                throw ThrowableUtils.runtimeException(cause, msg, new Object[0]);
            }
        }
        return new BasicAssertionError(cause, msg, new Object[0]);
    }

    protected static String className(Object o) {
        return ClassUtils.className(o);
    }

    protected static <E> Class<E[]> arrayClass(Class<E> c) {
        return Array.newInstance(c, 0).getClass();
    }
}

