/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.juneau.AnnotationApplier;
import org.apache.juneau.BeanContext;
import org.apache.juneau.annotation.TargetedAnnotationTImpl;
import org.apache.juneau.annotation.TargetedAnnotationTMBuilder;
import org.apache.juneau.http.annotation.StatusCode;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.svl.VarResolverSession;

public class StatusCodeAnnotation {
    public static final StatusCode DEFAULT = StatusCodeAnnotation.create().build();

    public static Builder create() {
        return new Builder();
    }

    public static Builder create(Class<?> ... on) {
        return StatusCodeAnnotation.create().on((Class[])on);
    }

    public static Builder create(String ... on) {
        return StatusCodeAnnotation.create().on(on);
    }

    @Documented
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Array {
        public StatusCode[] value();
    }

    public static class Applier
    extends AnnotationApplier<StatusCode, BeanContext.Builder> {
        public Applier(VarResolverSession vr) {
            super(StatusCode.class, BeanContext.Builder.class, vr);
        }

        @Override
        public void apply(AnnotationInfo<StatusCode> ai, BeanContext.Builder b) {
            StatusCode a = ai.inner();
            if (ArrayUtils.isEmptyArray(a.on(), a.onClass())) {
                return;
            }
            b.annotations(a);
        }
    }

    private static class Impl
    extends TargetedAnnotationTImpl
    implements StatusCode {
        private final int[] value;

        Impl(Builder b) {
            super(b);
            this.value = Arrays.copyOf(b.value, b.value.length);
            this.postConstruct();
        }

        @Override
        public int[] value() {
            return this.value;
        }
    }

    public static class Builder
    extends TargetedAnnotationTMBuilder {
        int[] value = new int[0];

        protected Builder() {
            super(StatusCode.class);
        }

        public StatusCode build() {
            return new Impl(this);
        }

        public Builder value(int ... value) {
            this.value = value;
            return this;
        }

        @Override
        public Builder on(String ... values) {
            super.on(values);
            return this;
        }

        @Override
        public Builder on(Class<?> ... value) {
            super.on((Class[])value);
            return this;
        }

        @Override
        public Builder onClass(Class<?> ... value) {
            super.onClass((Class[])value);
            return this;
        }

        @Override
        public Builder on(Method ... value) {
            super.on(value);
            return this;
        }
    }
}

