/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.stats;

import java.lang.reflect.Method;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.juneau.BeanBuilder;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.rest.stats.ThrownStore;

public class MethodExecStats {
    private final long guid;
    private final Method method;
    private final ThrownStore thrownStore;
    private volatile int minTime = -1;
    private volatile int maxTime;
    private AtomicInteger starts = new AtomicInteger();
    private AtomicInteger finishes = new AtomicInteger();
    private AtomicInteger errors = new AtomicInteger();
    private AtomicLong totalTime = new AtomicLong();

    public static Builder create(BeanStore beanStore) {
        return new Builder(beanStore);
    }

    protected MethodExecStats(Builder builder) {
        this.guid = new Random().nextLong();
        this.method = builder.method;
        this.thrownStore = builder.thrownStore != null ? builder.thrownStore : new ThrownStore();
    }

    public MethodExecStats started() {
        this.starts.incrementAndGet();
        return this;
    }

    public MethodExecStats finished(long nanoTime) {
        this.finishes.incrementAndGet();
        int milliTime = (int)(nanoTime / 1000000L);
        this.totalTime.addAndGet(nanoTime);
        this.minTime = this.minTime == -1 ? milliTime : Math.min(this.minTime, milliTime);
        this.maxTime = Math.max(this.maxTime, milliTime);
        return this;
    }

    public MethodExecStats error(Throwable e) {
        this.errors.incrementAndGet();
        this.thrownStore.add(e);
        return this;
    }

    public long getGuid() {
        return this.guid;
    }

    public Method getMethod() {
        return this.method;
    }

    public int getRuns() {
        return this.starts.get();
    }

    public int getRunning() {
        return this.starts.get() - this.finishes.get();
    }

    public int getErrors() {
        return this.errors.get();
    }

    public int getMinTime() {
        return this.minTime == -1 ? 0 : this.minTime;
    }

    public int getMaxTime() {
        return this.maxTime;
    }

    public int getAvgTime() {
        int runs = this.finishes.get();
        return runs == 0 ? 0 : (int)(this.getTotalTime() / (long)runs);
    }

    public long getTotalTime() {
        return this.totalTime.get() / 1000000L;
    }

    public ThrownStore getThrownStore() {
        return this.thrownStore;
    }

    public String toString() {
        return StringUtils.json(this);
    }

    @FluentSetters
    public static class Builder
    extends BeanBuilder<MethodExecStats> {
        Method method;
        ThrownStore thrownStore;

        protected Builder(BeanStore beanStore) {
            super(MethodExecStats.class, beanStore);
        }

        @Override
        protected MethodExecStats buildDefault() {
            return new MethodExecStats(this);
        }

        @FluentSetter
        public Builder method(Method value) {
            this.method = value;
            return this;
        }

        @FluentSetter
        public Builder thrownStore(ThrownStore value) {
            this.thrownStore = value;
            return this;
        }

        public Builder impl(Object value) {
            super.impl(value);
            return this;
        }

        public Builder type(Class<?> value) {
            super.type(value);
            return this;
        }
    }
}

