/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.assertions;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.juneau.BeanMap;
import org.apache.juneau.assertions.Assertion;
import org.apache.juneau.assertions.FluentAnyAssertion;
import org.apache.juneau.assertions.FluentListAssertion;
import org.apache.juneau.assertions.FluentMapAssertion;
import org.apache.juneau.assertions.FluentObjectAssertion;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.StringUtils;

@FluentSetters(returns="FluentBeanAssertion<T,R>")
public class FluentBeanAssertion<T, R>
extends FluentObjectAssertion<T, R> {
    public FluentBeanAssertion(T value, R returns) {
        this(null, value, returns);
    }

    public FluentBeanAssertion(Assertion creator, T value, R returns) {
        super(creator, value, returns);
    }

    @Override
    public FluentBeanAssertion<T, R> asTransformed(Function<T, T> function) {
        return new FluentBeanAssertion(this, function.apply(this.orElse(null)), this.returns());
    }

    public FluentMapAssertion<String, Object, R> asPropertyMap(String ... names) {
        return new FluentMapAssertion((Assertion)this, this.toBeanMap().getProperties(StringUtils.split(names, ',')), this.returns());
    }

    public FluentAnyAssertion<Object, R> asProperty(String name) {
        return new FluentAnyAssertion(this, this.toBeanMap().get(name), this.returns());
    }

    public FluentListAssertion<Object, R> asProperties(String ... names) {
        BeanMap bm = this.toBeanMap();
        return new FluentListAssertion((Assertion)this, Arrays.stream(names).map((? super T x) -> bm.get(x)).collect(Collectors.toList()), this.returns());
    }

    @Override
    public FluentBeanAssertion<T, R> setMsg(String msg, Object ... args) {
        super.setMsg(msg, args);
        return this;
    }

    @Override
    public FluentBeanAssertion<T, R> setOut(PrintStream value) {
        super.setOut(value);
        return this;
    }

    @Override
    public FluentBeanAssertion<T, R> setSilent() {
        super.setSilent();
        return this;
    }

    @Override
    public FluentBeanAssertion<T, R> setStdOut() {
        super.setStdOut();
        return this;
    }

    @Override
    public FluentBeanAssertion<T, R> setThrowable(Class<? extends RuntimeException> value) {
        super.setThrowable((Class)value);
        return this;
    }

    private BeanMap<T> toBeanMap() {
        return BeanMap.of(this.value());
    }
}

