/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.response;

import java.util.List;
import java.util.Locale;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.ReasonPhraseCatalog;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.http.BasicStatusLine;
import org.apache.juneau.http.HttpEntities;
import org.apache.juneau.http.HttpHeaders;
import org.apache.juneau.http.header.HeaderList;
import org.apache.juneau.http.response.BasicHttpException;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.ThrowableUtils;

@FluentSetters(returns="HttpExceptionBuilder<T>")
public class HttpExceptionBuilder<T extends BasicHttpException>
extends BasicRuntimeException.Builder {
    BasicStatusLine statusLine;
    HeaderList headers = HeaderList.EMPTY;
    BasicStatusLine.Builder statusLineBuilder;
    HeaderList.Builder headersBuilder;
    HttpEntity content;
    private final Class<? extends BasicHttpException> implClass;

    public HttpExceptionBuilder(Class<T> implClass) {
        this.implClass = implClass;
    }

    public HttpExceptionBuilder(T copyFrom) {
        super((BasicRuntimeException)copyFrom);
        this.implClass = copyFrom.getClass();
        this.statusLine = ((BasicHttpException)copyFrom).statusLine;
        this.headers = ((BasicHttpException)copyFrom).headers;
        this.content = ((BasicHttpException)copyFrom).content;
    }

    public T build() {
        try {
            return (T)this.implClass.getConstructor(HttpExceptionBuilder.class).newInstance(this);
        }
        catch (Exception e) {
            throw ThrowableUtils.runtimeException(e);
        }
    }

    public HttpExceptionBuilder<?> copyFrom(HttpResponse response) {
        Header h = response.getLastHeader("Thrown");
        if (h != null) {
            this.message(HttpHeaders.thrown(h.getValue()).asParts().get().get(0).getMessage(), new Object[0]);
        }
        this.headers(response.getAllHeaders());
        this.content(response.getEntity());
        return this;
    }

    BasicStatusLine buildStatusLine() {
        if (this.statusLineBuilder != null) {
            return this.statusLineBuilder.build();
        }
        return this.statusLine;
    }

    HeaderList buildHeaders() {
        if (this.headersBuilder != null) {
            return (HeaderList)this.headersBuilder.build();
        }
        if (this.headers == null) {
            return HeaderList.EMPTY;
        }
        return this.headers;
    }

    public BasicStatusLine.Builder getStatusLine() {
        if (this.statusLineBuilder == null) {
            this.statusLineBuilder = this.statusLine == null ? BasicStatusLine.create() : this.statusLine.copy();
            this.statusLine = null;
        }
        return this.statusLineBuilder;
    }

    @FluentSetter
    public HttpExceptionBuilder<T> statusLine(BasicStatusLine value) {
        this.statusLine = value;
        this.statusLineBuilder = null;
        return this;
    }

    @FluentSetter
    public HttpExceptionBuilder<T> protocolVersion(ProtocolVersion value) {
        this.getStatusLine().protocolVersion(value);
        return this;
    }

    @FluentSetter
    public HttpExceptionBuilder<T> statusCode(int value) {
        this.getStatusLine().statusCode(value);
        return this;
    }

    @FluentSetter
    public HttpExceptionBuilder<T> reasonPhrase(String value) {
        this.getStatusLine().reasonPhrase(value);
        return this;
    }

    @FluentSetter
    public HttpExceptionBuilder<T> reasonPhraseCatalog(ReasonPhraseCatalog value) {
        this.getStatusLine().reasonPhraseCatalog(value);
        return this;
    }

    @FluentSetter
    public HttpExceptionBuilder<T> locale(Locale value) {
        this.getStatusLine().locale(value);
        return this;
    }

    public HeaderList.Builder getHeaders() {
        if (this.headersBuilder == null) {
            this.headersBuilder = this.headers == null ? HeaderList.create() : this.headers.copy();
            this.headers = null;
        }
        return this.headersBuilder;
    }

    @FluentSetter
    public HttpExceptionBuilder<T> headers(HeaderList value) {
        this.headers = value;
        this.headersBuilder = null;
        return this;
    }

    public HttpExceptionBuilder<T> header(Header value) {
        this.getHeaders().append(value);
        return this;
    }

    public HttpExceptionBuilder<T> header(String name, String value) {
        this.getHeaders().append(name, value);
        return this;
    }

    public HttpExceptionBuilder<T> headers(Header ... values) {
        this.getHeaders().append(values);
        return this;
    }

    public HttpExceptionBuilder<T> headers(List<Header> values) {
        this.getHeaders().append(values);
        return this;
    }

    public HttpExceptionBuilder<T> content(String value) {
        this.content(HttpEntities.stringEntity(value).build());
        return this;
    }

    public HttpExceptionBuilder<T> content(HttpEntity value) {
        this.content = value;
        return this;
    }

    @Override
    public HttpExceptionBuilder<T> causedBy(Throwable value) {
        super.causedBy(value);
        return this;
    }

    @Override
    public HttpExceptionBuilder<T> message(String msg, Object ... args) {
        super.message(msg, args);
        return this;
    }

    @Override
    public HttpExceptionBuilder<T> unmodifiable() {
        super.unmodifiable();
        return this;
    }
}

