/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.kex;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPairGenerator;
import java.util.concurrent.atomic.AtomicInteger;
import javax.crypto.spec.DHParameterSpec;
import org.apache.sshd.client.kex.DHGEX;
import org.apache.sshd.common.KeyExchange;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.util.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedDHGEX
extends DHGEX {
    public static final String MAX_DHGEX_KEY_SIZE_PROP = "org.apache.sshd.maxDHGexKeySize";
    public static final int MIN_DHGEX_KEY_SIZE = 1024;
    public static final int DEFAULT_DHGEX_KEY_SIZE = 1024;
    public static final int PREFERRED_DHGEX_KEY_SIZE = 4096;
    public static final int MAX_DHGEX_KEY_SIZE = 8192;
    private static final AtomicInteger MAX_DHG_KEY_SIZE_HOLDER = new AtomicInteger(0);

    public FixedDHGEX() {
        this.min = 1024;
        this.max = FixedDHGEX.getMaxDHGroupExchangeKeySize();
        this.prf = Math.min(4096, this.max);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getMaxDHGroupExchangeKeySize() {
        int maxSupportedKeySize;
        AtomicInteger atomicInteger = MAX_DHG_KEY_SIZE_HOLDER;
        synchronized (atomicInteger) {
            maxSupportedKeySize = MAX_DHG_KEY_SIZE_HOLDER.get();
            if (maxSupportedKeySize != 0) {
                return maxSupportedKeySize;
            }
            String propValue = System.getProperty(MAX_DHGEX_KEY_SIZE_PROP);
            if (propValue == null || propValue.isEmpty()) {
                maxSupportedKeySize = -1;
                for (int testKeySize = 8192; testKeySize >= 1024; testKeySize -= 1024) {
                    if (!FixedDHGEX.isDHGroupExchangeSupported(testKeySize)) continue;
                    maxSupportedKeySize = testKeySize;
                    break;
                }
            } else {
                Logger logger = LoggerFactory.getLogger(SecurityUtils.class);
                logger.info("Override max. DH group exchange key size: " + propValue);
                maxSupportedKeySize = Integer.parseInt(propValue);
            }
            MAX_DHG_KEY_SIZE_HOLDER.set(maxSupportedKeySize);
        }
        return maxSupportedKeySize;
    }

    static boolean isDHGroupExchangeSupported(int maxKeySize) {
        try {
            BigInteger r = new BigInteger("0").setBit(maxKeySize - 1);
            DHParameterSpec dhSkipParamSpec = new DHParameterSpec(r, r);
            KeyPairGenerator kpg = SecurityUtils.getKeyPairGenerator((String)"DH");
            kpg.initialize(dhSkipParamSpec);
            return true;
        }
        catch (GeneralSecurityException t) {
            return false;
        }
    }

    public static class Factory
    implements NamedFactory<KeyExchange> {
        public String getName() {
            return "diffie-hellman-group-exchange-sha1";
        }

        public KeyExchange create() {
            return new FixedDHGEX();
        }
    }
}

