/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.subsystem.sftp;

import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ObjectBuilder;
import org.apache.sshd.common.util.threads.ExecutorServiceConfigurer;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.subsystem.SubsystemFactory;
import org.apache.sshd.server.subsystem.sftp.AbstractSftpEventListenerManager;
import org.apache.sshd.server.subsystem.sftp.SftpEventListenerManager;
import org.apache.sshd.server.subsystem.sftp.SftpFileSystemAccessor;
import org.apache.sshd.server.subsystem.sftp.SftpFileSystemAccessorManager;
import org.apache.sshd.server.subsystem.sftp.SftpSubsystem;
import org.apache.sshd.server.subsystem.sftp.UnsupportedAttributePolicy;

public class SftpSubsystemFactory
extends AbstractSftpEventListenerManager
implements SubsystemFactory,
ExecutorServiceConfigurer,
SftpEventListenerManager,
SftpFileSystemAccessorManager {
    public static final String NAME = "sftp";
    public static final UnsupportedAttributePolicy DEFAULT_POLICY = UnsupportedAttributePolicy.Warn;
    private ExecutorService executors;
    private boolean shutdownExecutor;
    private UnsupportedAttributePolicy policy = DEFAULT_POLICY;
    private SftpFileSystemAccessor fileSystemAccessor = SftpFileSystemAccessor.DEFAULT;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executors;
    }

    @Override
    public void setExecutorService(ExecutorService service) {
        this.executors = service;
    }

    @Override
    public boolean isShutdownOnExit() {
        return this.shutdownExecutor;
    }

    @Override
    public void setShutdownOnExit(boolean shutdownOnExit) {
        this.shutdownExecutor = shutdownOnExit;
    }

    public UnsupportedAttributePolicy getUnsupportedAttributePolicy() {
        return this.policy;
    }

    public void setUnsupportedAttributePolicy(UnsupportedAttributePolicy p) {
        this.policy = Objects.requireNonNull(p, "No policy");
    }

    @Override
    public SftpFileSystemAccessor getFileSystemAccessor() {
        return this.fileSystemAccessor;
    }

    @Override
    public void setFileSystemAccessor(SftpFileSystemAccessor accessor) {
        this.fileSystemAccessor = Objects.requireNonNull(accessor, "No accessor");
    }

    @Override
    public Command create() {
        SftpSubsystem subsystem = new SftpSubsystem(this.getExecutorService(), this.isShutdownOnExit(), this.getUnsupportedAttributePolicy(), this.getFileSystemAccessor());
        GenericUtils.forEach(this.getRegisteredListeners(), subsystem::addSftpEventListener);
        return subsystem;
    }

    public static class Builder
    extends AbstractSftpEventListenerManager
    implements ObjectBuilder<SftpSubsystemFactory> {
        private ExecutorService executors;
        private boolean shutdownExecutor;
        private UnsupportedAttributePolicy policy = DEFAULT_POLICY;
        private SftpFileSystemAccessor fileSystemAccessor = SftpFileSystemAccessor.DEFAULT;

        public Builder withExecutorService(ExecutorService service) {
            this.executors = service;
            return this;
        }

        public Builder withShutdownOnExit(boolean shutdown) {
            this.shutdownExecutor = shutdown;
            return this;
        }

        public Builder withUnsupportedAttributePolicy(UnsupportedAttributePolicy p) {
            this.policy = Objects.requireNonNull(p, "No policy");
            return this;
        }

        public Builder withFileSystemAccessor(SftpFileSystemAccessor accessor) {
            this.fileSystemAccessor = Objects.requireNonNull(accessor, "No accessor");
            return this;
        }

        @Override
        public SftpSubsystemFactory build() {
            SftpSubsystemFactory factory = new SftpSubsystemFactory();
            factory.setExecutorService(this.executors);
            factory.setShutdownOnExit(this.shutdownExecutor);
            factory.setUnsupportedAttributePolicy(this.policy);
            factory.setFileSystemAccessor(this.fileSystemAccessor);
            GenericUtils.forEach(this.getRegisteredListeners(), factory::addSftpEventListener);
            return factory;
        }
    }
}

