/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.command;

import java.util.ArrayList;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.Repository;
import org.apache.karaf.features.command.FeaturesCommandSupport;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.MultiException;
import org.apache.karaf.shell.support.table.ShellTable;

@Command(scope="feature", name="repo-list", description="Displays a list of all defined repositories.")
@Service
public class RepoListCommand
extends FeaturesCommandSupport {
    @Option(name="-r", description="Reload all feature urls", required=false, multiValued=false)
    boolean reload;
    @Option(name="--no-format", description="Disable table rendered output", required=false, multiValued=false)
    boolean noFormat;

    @Override
    protected void doExecute(FeaturesService featuresService) throws Exception {
        Repository[] repos;
        if (this.reload) {
            this.reloadAllRepos(featuresService);
        }
        ShellTable table = new ShellTable();
        table.column("Repository");
        table.column("URL");
        table.emptyTableText("No repositories available");
        for (Repository repo : repos = featuresService.listRepositories()) {
            if (repo == null) continue;
            table.addRow().addContent(new Object[]{repo.getName(), repo.getURI().toString()});
        }
        table.print(System.out, !this.noFormat);
    }

    private void reloadAllRepos(FeaturesService featuresService) throws Exception {
        System.out.println("Reloading all repositories from their urls");
        System.out.println();
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (Repository repo : featuresService.listRepositories()) {
            try {
                featuresService.addRepository(repo.getURI());
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        MultiException.throwIf((String)"Unable to reload repositories", exceptions);
    }
}

