/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jms.service.internal;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanConfig {
    public static final Logger LOG = LoggerFactory.getLogger(BeanConfig.class);
    protected static final String POOL_PREFIX = "pool.";
    protected static final String FACTORY_PREFIX = "factory.";
    private Object bean;
    private Map<String, Method> setters;

    private BeanConfig(Object bean) {
        this.bean = bean;
        this.setters = BeanConfig.findSettersForBean(bean);
    }

    private static Map<String, Method> findSettersForBean(Object bean) {
        HashMap<String, Method> setters = new HashMap<String, Method>();
        for (Method method : bean.getClass().getMethods()) {
            String name = method.getName();
            if (!name.startsWith("set") || method.getParameterTypes().length != 1) continue;
            String key1 = name.substring(3, 4).toLowerCase() + name.substring(4);
            String key2 = name.substring(3, 4) + name.substring(4);
            setters.put(key1, method);
            setters.put(key2, method);
        }
        return setters;
    }

    public static void configure(Object bean, Properties props) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : props.stringPropertyNames()) {
            map.put(key, props.getProperty(key));
        }
        BeanConfig.configure(bean, map);
    }

    public static void configure(Object bean, Map<String, Object> props) {
        BeanConfig beanConfig = new BeanConfig(bean);
        for (String key : props.keySet()) {
            beanConfig.trySetProperty(key, (String)props.get(key));
        }
    }

    private void trySetProperty(String key, String value) {
        try {
            Method method = this.setters.get(key);
            if (method == null) {
                LOG.warn("No setter in " + this.bean.getClass() + " for property " + key);
                return;
            }
            Class<?> paramClass = method.getParameterTypes()[0];
            if (paramClass == Integer.TYPE || paramClass == Integer.class) {
                method.invoke(this.bean, Integer.parseInt(value));
            } else if (paramClass == Long.TYPE || paramClass == Long.class) {
                method.invoke(this.bean, Long.parseLong(value));
            } else if (paramClass == Boolean.TYPE || paramClass == Boolean.class) {
                method.invoke(this.bean, Boolean.parseBoolean(value));
            } else if (paramClass == String.class) {
                method.invoke(this.bean, value);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error setting property " + key + ":" + e.getMessage(), e);
        }
    }

    public static Map<String, Object> getNonPoolProps(Map<String, Object> props) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (String key : props.keySet()) {
            if (key.startsWith(POOL_PREFIX) || key.startsWith(FACTORY_PREFIX)) continue;
            properties.put(key, props.get(key));
        }
        properties.remove("name");
        return properties;
    }

    public static Map<String, Object> getPoolProps(Map<String, Object> props) {
        return BeanConfig.getPrefixed(props, POOL_PREFIX);
    }

    static Map<String, Object> getPrefixed(Map<String, Object> props, String prefix) {
        HashMap<String, Object> prefixedProps = new HashMap<String, Object>();
        for (String key : props.keySet()) {
            if (!key.startsWith(prefix)) continue;
            String strippedKey = key.substring(prefix.length());
            prefixedProps.put(strippedKey, props.get(key));
        }
        return prefixedProps;
    }
}

