/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.diagnostic.core.common;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.karaf.diagnostic.core.DumpDestination;
import org.apache.karaf.diagnostic.core.common.ClosingEntryOutputStreamWrapper;

public class ZipDumpDestination
implements DumpDestination {
    private ZipOutputStream outputStream;
    private File file;

    public ZipDumpDestination(File directory, String name) {
        this(new File(directory, name));
    }

    public ZipDumpDestination(File file) {
        try {
            this.file = file;
            this.outputStream = new ZipOutputStream(new FileOutputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Unable to create dump destination", e);
        }
    }

    @Override
    public OutputStream add(String name) throws Exception {
        ZipEntry zipEntry = new ZipEntry(name);
        this.outputStream.putNextEntry(zipEntry);
        return new ClosingEntryOutputStreamWrapper(this.outputStream);
    }

    @Override
    public void save() throws Exception {
        this.outputStream.close();
    }

    public String toString() {
        return "zip: " + String.valueOf(this.file);
    }
}

