/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.ambari;

import org.apache.knox.gateway.topology.discovery.ambari.AmbariCluster;
import org.apache.knox.gateway.topology.discovery.ambari.AmbariComponent;
import org.apache.knox.gateway.topology.discovery.ambari.ConditionalValueHandler;
import org.apache.knox.gateway.topology.discovery.ambari.ServiceURLPropertyConfig;

class PropertyEqualsHandler
implements ConditionalValueHandler {
    private String serviceName = null;
    private String propertyName = null;
    private String propertyValue = null;
    private ConditionalValueHandler affirmativeResult = null;
    private ConditionalValueHandler negativeResult = null;

    PropertyEqualsHandler(String serviceName, String propertyName, String propertyValue, ConditionalValueHandler affirmativeResult, ConditionalValueHandler negativeResult) {
        this.serviceName = serviceName;
        this.propertyName = propertyName;
        this.propertyValue = propertyValue;
        this.affirmativeResult = affirmativeResult;
        this.negativeResult = negativeResult;
    }

    @Override
    public String evaluate(ServiceURLPropertyConfig config, AmbariCluster cluster) {
        String result = null;
        ServiceURLPropertyConfig.Property p = config.getConfigProperty(this.serviceName, this.propertyName);
        if (p != null) {
            ServiceURLPropertyConfig.Property derived;
            String value = null;
            if (p.getType().equalsIgnoreCase("DERIVED")) {
                ConditionalValueHandler valueHandler = p.getConditionHandler();
                if (valueHandler != null) {
                    value = valueHandler.evaluate(config, cluster);
                }
            } else {
                value = this.getActualPropertyValue(cluster, p);
            }
            if (this.propertyValue == null) {
                if (value != null) {
                    result = this.affirmativeResult.evaluate(config, cluster);
                } else if (this.negativeResult != null) {
                    result = this.negativeResult.evaluate(config, cluster);
                }
            }
            if (result == null) {
                if (this.propertyValue != null && this.propertyValue.equals(value)) {
                    result = this.affirmativeResult.evaluate(config, cluster);
                } else if (this.negativeResult != null) {
                    result = this.negativeResult.evaluate(config, cluster);
                }
            }
            if ((derived = config.getConfigProperty(this.serviceName, result)) != null) {
                result = this.getActualPropertyValue(cluster, derived);
            }
        }
        return result;
    }

    private String getActualPropertyValue(AmbariCluster cluster, ServiceURLPropertyConfig.Property property) {
        String value = null;
        String propertyType = property.getType();
        if ("COMPONENT".equals(propertyType)) {
            AmbariComponent component = cluster.getComponent(property.getComponent());
            if (component != null) {
                value = component.getConfigProperty(property.getValue());
            }
        } else if ("SERVICE".equals(propertyType)) {
            value = cluster.getServiceConfiguration(property.getService(), property.getServiceConfig()).getProperties().get(property.getValue());
        }
        return value;
    }
}

