/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.simple;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.io.FilenameUtils;
import org.apache.knox.gateway.topology.simple.ProviderConfiguration;

public class ProviderConfigurationParser {
    private static final String EXT_XML = "xml";
    private static final String EXT_JSON = "json";
    private static final String EXT_YML = "yml";
    private static final String EXT_YAML = "yaml";
    public static final List<String> SUPPORTED_EXTENSIONS = Collections.unmodifiableList(Arrays.asList("xml", "json", "yml", "yaml"));

    public static ProviderConfiguration parse(String path) throws Exception {
        return ProviderConfigurationParser.parse(new File(path));
    }

    public static ProviderConfiguration parse(File file) throws Exception {
        ProviderConfiguration providerConfig = null;
        String extension = FilenameUtils.getExtension((String)file.getName());
        if (SUPPORTED_EXTENSIONS.contains(extension)) {
            if (ProviderConfigurationParser.isXML(extension)) {
                providerConfig = ProviderConfigurationParser.parseXML(file);
            } else if (ProviderConfigurationParser.isJSON(extension)) {
                providerConfig = ProviderConfigurationParser.parseJSON(file);
            } else if (ProviderConfigurationParser.isYAML(extension)) {
                providerConfig = ProviderConfigurationParser.parseYAML(file);
            }
        } else {
            throw new IllegalArgumentException("Unsupported provider configuration format: " + extension);
        }
        return providerConfig;
    }

    private static boolean isXML(String extension) {
        return EXT_XML.equals(extension);
    }

    private static boolean isJSON(String extension) {
        return EXT_JSON.equals(extension);
    }

    private static boolean isYAML(String extension) {
        return EXT_YAML.equals(extension) || EXT_YML.equals(extension);
    }

    static ProviderConfiguration parseXML(File file) throws Exception {
        return ProviderConfigurationParser.parseXML(new FileInputStream(file));
    }

    static ProviderConfiguration parseXML(InputStream in) throws Exception {
        XMLProviderConfiguration providerConfig = null;
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{XMLProviderConfiguration.class});
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        providerConfig = (XMLProviderConfiguration)jaxbUnmarshaller.unmarshal(in);
        return providerConfig;
    }

    static ProviderConfiguration parseJSON(File file) throws IOException {
        return ProviderConfigurationParser.parseJSON(new FileInputStream(file));
    }

    static ProviderConfiguration parseJSON(InputStream in) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JSONProviderConfiguration providerConfig = (JSONProviderConfiguration)mapper.readValue(in, JSONProviderConfiguration.class);
        return providerConfig;
    }

    static ProviderConfiguration parseYAML(File file) throws IOException {
        return ProviderConfigurationParser.parseYAML(new FileInputStream(file));
    }

    static ProviderConfiguration parseYAML(InputStream in) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        JSONProviderConfiguration providerConfig = (JSONProviderConfiguration)mapper.readValue(in, JSONProviderConfiguration.class);
        return providerConfig;
    }

    private static class JSONProviderConfiguration
    implements ProviderConfiguration {
        @JsonProperty(value="providers")
        private List<JSONProvider> providers;

        private JSONProviderConfiguration() {
        }

        @Override
        public List<ProviderConfiguration.Provider> getProviders() {
            ArrayList<ProviderConfiguration.Provider> plist = new ArrayList<ProviderConfiguration.Provider>();
            if (this.providers != null) {
                plist.addAll(this.providers);
            }
            return plist;
        }

        private static class JSONProvider
        implements ProviderConfiguration.Provider {
            @JsonProperty(value="role")
            private String role;
            @JsonProperty(value="name")
            private String name;
            @JsonProperty(value="enabled")
            private boolean enabled;
            @JsonProperty(value="params")
            private Map<String, String> params;

            private JSONProvider() {
            }

            @Override
            public String getRole() {
                return this.role;
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public boolean isEnabled() {
                return this.enabled;
            }

            @Override
            public Map<String, String> getParams() {
                LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
                if (this.params != null) {
                    result.putAll(this.params);
                }
                return result;
            }
        }
    }

    @XmlRootElement(name="gateway")
    private static class XMLProviderConfiguration
    implements ProviderConfiguration {
        @XmlElement(name="provider")
        private List<XMLProvider> providers;

        private XMLProviderConfiguration() {
        }

        @Override
        public List<ProviderConfiguration.Provider> getProviders() {
            ArrayList<ProviderConfiguration.Provider> plist = new ArrayList<ProviderConfiguration.Provider>();
            if (this.providers != null) {
                plist.addAll(this.providers);
            }
            return plist;
        }

        @XmlAccessorType(value=XmlAccessType.NONE)
        private static class XMLProvider
        implements ProviderConfiguration.Provider {
            @XmlElement
            private String role;
            @XmlElement
            private String name;
            @XmlElement
            private boolean enabled;
            @XmlElement(name="param")
            private List<XMLParam> params;

            private XMLProvider() {
            }

            @Override
            public String getRole() {
                return this.role;
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public boolean isEnabled() {
                return this.enabled;
            }

            @Override
            public Map<String, String> getParams() {
                LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
                if (this.params != null) {
                    for (XMLParam p : this.params) {
                        result.put(p.name, p.value);
                    }
                }
                return result;
            }

            @XmlAccessorType(value=XmlAccessType.NONE)
            private static class XMLParam {
                @XmlElement
                private String name;
                @XmlElement
                private String value;

                private XMLParam() {
                }

                String getName() {
                    return this.name;
                }

                String getValue() {
                    return this.value;
                }
            }
        }
    }
}

