/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.dispatch;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.knox.gateway.SpiGatewayMessages;
import org.apache.knox.gateway.config.ConfigurationInjectorBuilder;
import org.apache.knox.gateway.dispatch.DefaultHttpClientFactory;
import org.apache.knox.gateway.dispatch.Dispatch;
import org.apache.knox.gateway.dispatch.HttpClientFactory;
import org.apache.knox.gateway.filter.AbstractGatewayFilter;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.util.RegExUtils;
import org.apache.knox.gateway.util.WhitelistUtils;

public class GatewayDispatchFilter
extends AbstractGatewayFilter {
    private static final Map<String, Adapter> METHOD_ADAPTERS = GatewayDispatchFilter.createMethodAdapters();
    protected static final SpiGatewayMessages LOG = (SpiGatewayMessages)MessagesFactory.get(SpiGatewayMessages.class);
    private final Object lock = new Object();
    private String whitelist = null;
    private Dispatch dispatch;
    private HttpClient httpClient;

    private static Map<String, Adapter> createMethodAdapters() {
        HashMap<String, Adapter> map = new HashMap<String, Adapter>();
        map.put("GET", new GetAdapter());
        map.put("POST", new PostAdapter());
        map.put("PUT", new PutAdapter());
        map.put("DELETE", new DeleteAdapter());
        map.put("OPTIONS", new OptionsAdapter());
        map.put("HEAD", new HeadAdapter());
        return Collections.unmodifiableMap(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        Object object = this.lock;
        synchronized (object) {
            if (this.dispatch == null) {
                String dispatchImpl = filterConfig.getInitParameter("dispatch-impl");
                this.dispatch = (Dispatch)this.newInstanceFromName(dispatchImpl);
            }
            ConfigurationInjectorBuilder.configuration().target((Object)this.dispatch).source((Object)filterConfig).inject();
            String httpClientFactoryClass = filterConfig.getInitParameter("httpClientFactory");
            HttpClientFactory httpClientFactory = httpClientFactoryClass != null ? (HttpClientFactory)this.newInstanceFromName(httpClientFactoryClass) : new DefaultHttpClientFactory();
            this.httpClient = httpClientFactory.createHttpClient(filterConfig);
            this.dispatch.setHttpClient(this.httpClient);
            this.dispatch.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.lock;
        synchronized (object) {
            this.dispatch.destroy();
            try {
                if (this.httpClient instanceof CloseableHttpClient) {
                    ((CloseableHttpClient)this.httpClient).close();
                }
            }
            catch (IOException e) {
                LOG.errorClosingHttpClient(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dispatch getDispatch() {
        Object object = this.lock;
        synchronized (object) {
            return this.dispatch;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDispatch(Dispatch dispatch) {
        Object object = this.lock;
        synchronized (object) {
            this.dispatch = dispatch;
        }
    }

    @Override
    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String method = request.getMethod().toUpperCase(Locale.ROOT);
        Adapter adapter = METHOD_ADAPTERS.get(method);
        if (adapter != null) {
            if (this.isDispatchAllowed(request)) {
                try {
                    adapter.doMethod(this.getDispatch(), request, response);
                }
                catch (URISyntaxException e) {
                    throw new ServletException((Throwable)e);
                }
            } else {
                response.sendError(400);
            }
        } else {
            response.sendError(405);
        }
    }

    private boolean isDispatchAllowed(HttpServletRequest request) {
        boolean isAllowed = true;
        if (this.whitelist == null) {
            this.whitelist = WhitelistUtils.getDispatchWhitelist(request);
        }
        if (this.whitelist != null) {
            String requestURI = request.getRequestURI();
            String decodedURL = null;
            try {
                decodedURL = URLDecoder.decode(requestURI, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            isAllowed = RegExUtils.checkWhitelist((String)this.whitelist, (String)(decodedURL != null ? decodedURL : requestURI));
            if (!isAllowed) {
                LOG.dispatchDisallowed(requestURI);
            }
        }
        return isAllowed;
    }

    private <T> T newInstanceFromName(String dispatchImpl) throws ServletException {
        try {
            Class<T> clazz = this.loadClass(dispatchImpl);
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private <T> Class<T> loadClass(String className) throws ClassNotFoundException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        return loader.loadClass(className);
    }

    private static class HeadAdapter
    implements Adapter {
        private HeadAdapter() {
        }

        @Override
        public void doMethod(Dispatch dispatch, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, URISyntaxException {
            dispatch.doHead(dispatch.getDispatchUrl(request), request, response);
        }
    }

    private static class OptionsAdapter
    implements Adapter {
        private OptionsAdapter() {
        }

        @Override
        public void doMethod(Dispatch dispatch, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, URISyntaxException {
            dispatch.doOptions(dispatch.getDispatchUrl(request), request, response);
        }
    }

    private static class DeleteAdapter
    implements Adapter {
        private DeleteAdapter() {
        }

        @Override
        public void doMethod(Dispatch dispatch, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, URISyntaxException {
            dispatch.doDelete(dispatch.getDispatchUrl(request), request, response);
        }
    }

    private static class PutAdapter
    implements Adapter {
        private PutAdapter() {
        }

        @Override
        public void doMethod(Dispatch dispatch, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, URISyntaxException {
            dispatch.doPut(dispatch.getDispatchUrl(request), request, response);
        }
    }

    private static class PostAdapter
    implements Adapter {
        private PostAdapter() {
        }

        @Override
        public void doMethod(Dispatch dispatch, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, URISyntaxException {
            dispatch.doPost(dispatch.getDispatchUrl(request), request, response);
        }
    }

    private static class GetAdapter
    implements Adapter {
        private GetAdapter() {
        }

        @Override
        public void doMethod(Dispatch dispatch, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, URISyntaxException {
            dispatch.doGet(dispatch.getDispatchUrl(request), request, response);
        }
    }

    private static interface Adapter {
        public void doMethod(Dispatch var1, HttpServletRequest var2, HttpServletResponse var3) throws IOException, ServletException, URISyntaxException;
    }
}

