/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology;

public class Version
implements Comparable<Version> {
    private int major;
    private int minor;
    private int patch;

    public Version() {
    }

    public Version(String version) {
        this.setVersion(version);
    }

    public Version(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public int getMinor() {
        return this.minor;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public void setPatch(int patch) {
        this.patch = patch;
    }

    public void setVersion(String version) {
        if (version != null) {
            this.parseVersion(version);
        }
    }

    private void parseVersion(String version) {
        String[] parts = version.split("\\.");
        int length = parts.length;
        if (length >= 1) {
            this.major = Integer.parseInt(parts[0]);
        }
        if (length >= 2) {
            this.minor = Integer.parseInt(parts[1]);
        }
        if (length >= 3) {
            this.patch = Integer.parseInt(parts[2]);
        }
    }

    @Override
    public int compareTo(Version version) {
        if (this.major > version.getMajor()) {
            return 1;
        }
        if (this.major < version.getMajor()) {
            return -1;
        }
        if (this.minor > version.getMinor()) {
            return 1;
        }
        if (this.minor < version.getMinor()) {
            return -1;
        }
        if (this.patch > version.getPatch()) {
            return 1;
        }
        if (this.patch < version.getPatch()) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.major);
        buffer.append(".");
        buffer.append(this.minor);
        buffer.append(".");
        buffer.append(this.patch);
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Version)) {
            return false;
        }
        Version that = (Version)o;
        return this.major == that.getMajor() && this.minor == that.getMinor() && this.patch == that.getPatch();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

