/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.replication.provider;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.constants.SchemaConstants;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapEntryAlreadyExistsException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.filter.EqualityNode;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.ldap.model.message.SearchRequestImpl;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.event.EventType;
import org.apache.directory.server.core.api.event.NotificationCriteria;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.api.partition.PartitionReadTxn;
import org.apache.directory.server.core.api.partition.PartitionTxn;
import org.apache.directory.server.ldap.replication.provider.ReplicaEventLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplConsumerManager {
    private static final Logger LOG = LoggerFactory.getLogger(ReplConsumerManager.class);
    private static final Logger PROVIDER_LOG = LoggerFactory.getLogger((String)Loggers.PROVIDER_LOG.getName());
    private CoreSession adminSession;
    private DirectoryService directoryService;
    private SchemaManager schemaManager;
    private static final String REPL_CONSUMER_DN_STR = "ou=consumers,ou=system";
    private Dn replConsumerDn;
    private static final String CONSUMERS = "consumers";
    private AttributeType adsReplLastSentCsn;
    private Map<Integer, Modification> modMap = new ConcurrentHashMap<Integer, Modification>();

    public ReplConsumerManager(DirectoryService directoryService) throws Exception {
        this.directoryService = directoryService;
        this.adminSession = directoryService.getAdminSession();
        this.schemaManager = directoryService.getSchemaManager();
        this.replConsumerDn = directoryService.getDnFactory().create(REPL_CONSUMER_DN_STR);
        this.adsReplLastSentCsn = this.schemaManager.lookupAttributeTypeRegistry("ads-replLastSentCsn");
        PROVIDER_LOG.debug("Starting the replication consumer manager");
        this.createConsumersBranch();
    }

    private void createConsumersBranch() throws Exception {
        if (!this.adminSession.exists(this.replConsumerDn)) {
            LOG.debug("creating the entry for storing replication consumers' details");
            PROVIDER_LOG.debug("Creating the entry for storing replication consumers' details in {}", (Object)this.replConsumerDn);
            DefaultEntry entry = new DefaultEntry(this.schemaManager, this.replConsumerDn, new Object[]{"objectClass", "organizationalUnit", "ou", CONSUMERS});
            this.adminSession.add((Entry)entry);
        }
    }

    public void addConsumerEntry(ReplicaEventLog replica) throws Exception {
        if (replica == null) {
            return;
        }
        PROVIDER_LOG.debug("Adding a consumer for replica {}", (Object)replica.toString());
        Dn consumerDn = this.directoryService.getDnFactory().create("ads-dsReplicaId=" + replica.getId() + "," + this.replConsumerDn);
        if (this.adminSession.exists(consumerDn)) {
            String message = "The replica " + consumerDn.getName() + " already exists";
            LOG.error(message);
            PROVIDER_LOG.error(message);
            throw new LdapEntryAlreadyExistsException(message);
        }
        DefaultEntry entry = new DefaultEntry(this.schemaManager, consumerDn, new Object[]{"objectClass", "ads-replEventLog", "ads-dsReplicaId", String.valueOf(replica.getId()), "ads-replAliasDerefMode", replica.getSearchCriteria().getAliasDerefMode().getJndiValue(), "ads-searchBaseDN", replica.getSearchCriteria().getBase().getName(), "ads-replLastSentCsn", replica.getLastSentCsn(), "ads-replSearchScope", replica.getSearchCriteria().getScope().getLdapUrlValue(), "ads-replRefreshNPersist", String.valueOf(replica.isRefreshNPersist()), "ads-replSearchFilter", replica.getSearchFilter(), "ads-replLogMaxIdle", String.valueOf(replica.getMaxIdlePeriod()), "ads-replLogPurgeThresholdCount", String.valueOf(replica.getPurgeThresholdCount())});
        this.adminSession.add((Entry)entry);
        replica.setConsumerEntryDn(consumerDn);
        LOG.debug("stored replication consumer entry {}", (Object)consumerDn);
    }

    public void deleteConsumerEntry(ReplicaEventLog replica) throws LdapException {
        if (replica == null) {
            return;
        }
        Dn consumerDn = this.directoryService.getDnFactory().create("ads-dsReplicaId=" + replica.getId() + "," + this.replConsumerDn);
        PROVIDER_LOG.debug("Trying to delete the consumer entry {}", (Object)consumerDn);
        if (!this.adminSession.exists(consumerDn)) {
            String message = "The replica " + consumerDn.getName() + " does not exist";
            LOG.error(message);
            PROVIDER_LOG.debug(message);
            return;
        }
        this.adminSession.delete(consumerDn);
        LOG.debug("Deleted replication consumer entry {}", (Object)consumerDn);
    }

    public void updateReplicaLastSentCsn(ReplicaEventLog replica) throws Exception {
        Modification mod = this.modMap.get(replica.getId());
        Attribute lastSentCsnAt = null;
        if (mod == null) {
            mod = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, this.adsReplLastSentCsn, new String[]{replica.getLastSentCsn()});
            this.modMap.put(replica.getId(), mod);
        } else {
            lastSentCsnAt = mod.getAttribute();
            lastSentCsnAt.clear();
            lastSentCsnAt.add(new String[]{replica.getLastSentCsn()});
        }
        Dn dn = this.directoryService.getDnFactory().create("ads-dsReplicaId=" + replica.getId() + "," + this.replConsumerDn);
        this.adminSession.modify(dn, new Modification[]{mod});
        LOG.debug("updated last sent CSN of consumer entry {}", (Object)dn);
        PROVIDER_LOG.debug("updated the LastSentCSN of consumer entry {}", (Object)dn);
    }

    public List<ReplicaEventLog> getReplicaEventLogs() throws Exception {
        ArrayList<ReplicaEventLog> replicas = new ArrayList<ReplicaEventLog>();
        Partition partition = this.directoryService.getPartitionNexus().getPartition(this.replConsumerDn);
        EqualityNode filter = new EqualityNode(this.directoryService.getAtProvider().getObjectClass(), new Value(this.directoryService.getAtProvider().getObjectClass(), "ads-replEventLog"));
        SearchRequestImpl searchRequest = new SearchRequestImpl();
        searchRequest.setBase(this.replConsumerDn);
        searchRequest.setScope(SearchScope.ONELEVEL);
        searchRequest.setFilter((ExprNode)filter);
        searchRequest.addAttributes(SchemaConstants.ALL_ATTRIBUTES_ARRAY);
        Cursor cursor = this.adminSession.search((SearchRequest)searchRequest);
        while (cursor.next()) {
            Entry entry = (Entry)cursor.get();
            PartitionReadTxn partitionTxn = partition.beginReadTransaction();
            Throwable throwable = null;
            try {
                ReplicaEventLog replica = this.convertEntryToReplica((PartitionTxn)partitionTxn, entry);
                replicas.add(replica);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (partitionTxn == null) continue;
                if (throwable != null) {
                    try {
                        partitionTxn.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                partitionTxn.close();
            }
        }
        cursor.close();
        return replicas;
    }

    private ReplicaEventLog convertEntryToReplica(PartitionTxn partitionTxn, Entry entry) throws Exception {
        String id = entry.get("ads-dsReplicaId").getString();
        ReplicaEventLog replica = new ReplicaEventLog(partitionTxn, this.directoryService, Integer.parseInt(id));
        NotificationCriteria searchCriteria = new NotificationCriteria(this.schemaManager);
        String aliasMode = entry.get("ads-replAliasDerefMode").getString();
        searchCriteria.setAliasDerefMode(AliasDerefMode.getDerefMode((String)aliasMode));
        String baseDn = entry.get("ads-searchBaseDN").getString();
        searchCriteria.setBase(new Dn(this.schemaManager, new String[]{baseDn}));
        Attribute lastSentCsnAt = entry.get("ads-replLastSentCsn");
        if (lastSentCsnAt != null) {
            replica.setLastSentCsn(lastSentCsnAt.getString());
        }
        String scope = entry.get("ads-replSearchScope").getString();
        int scopeIntVal = SearchScope.getSearchScope((String)scope);
        searchCriteria.setScope(SearchScope.getSearchScope((int)scopeIntVal));
        String filter = entry.get("ads-replSearchFilter").getString();
        searchCriteria.setFilter(filter);
        replica.setSearchFilter(filter);
        replica.setRefreshNPersist(Boolean.parseBoolean(entry.get("ads-replRefreshNPersist").getString()));
        searchCriteria.setEventMask(EventType.ALL_EVENT_TYPES_MASK);
        replica.setSearchCriteria(searchCriteria);
        int maxIdlePeriod = Integer.parseInt(entry.get("ads-replLogMaxIdle").getString());
        replica.setMaxIdlePeriod(maxIdlePeriod);
        int purgeThreshold = Integer.parseInt(entry.get("ads-replLogPurgeThresholdCount").getString());
        replica.setPurgeThresholdCount(purgeThreshold);
        replica.setDirty(false);
        replica.setConsumerEntryDn(entry.getDn());
        return replica;
    }
}

