/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.tree.analysis;

import java.util.List;
import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.internal.libraries.asm.tree.analysis.AnalyzerException;
import org.eclipse.persistence.internal.libraries.asm.tree.analysis.BasicValue;
import org.eclipse.persistence.internal.libraries.asm.tree.analysis.BasicVerifier;

public class SimpleVerifier
extends BasicVerifier {
    private final Type currentClass;
    private final Type currentSuperClass;
    private final List<Type> currentClassInterfaces;
    private final boolean isInterface;
    private ClassLoader loader = this.getClass().getClassLoader();

    public SimpleVerifier() {
        this(null, null, false);
    }

    public SimpleVerifier(Type type, Type type2, boolean bl) {
        this(type, type2, null, bl);
    }

    public SimpleVerifier(Type type, Type type2, List<Type> list, boolean bl) {
        this(393216, type, type2, list, bl);
        if (this.getClass() != SimpleVerifier.class) {
            throw new IllegalStateException();
        }
    }

    protected SimpleVerifier(int n, Type type, Type type2, List<Type> list, boolean bl) {
        super(n);
        this.currentClass = type;
        this.currentSuperClass = type2;
        this.currentClassInterfaces = list;
        this.isInterface = bl;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.loader = classLoader;
    }

    @Override
    public BasicValue newValue(Type type) {
        BasicValue basicValue;
        boolean bl;
        if (type == null) {
            return BasicValue.UNINITIALIZED_VALUE;
        }
        boolean bl2 = bl = type.getSort() == 9;
        if (bl) {
            switch (type.getElementType().getSort()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return new BasicValue(type);
                }
            }
        }
        if (BasicValue.REFERENCE_VALUE.equals(basicValue = super.newValue(type))) {
            if (bl) {
                basicValue = this.newValue(type.getElementType());
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < type.getDimensions(); ++i) {
                    stringBuilder.append('[');
                }
                stringBuilder.append(basicValue.getType().getDescriptor());
                basicValue = new BasicValue(Type.getType(stringBuilder.toString()));
            } else {
                basicValue = new BasicValue(type);
            }
        }
        return basicValue;
    }

    @Override
    protected boolean isArrayValue(BasicValue basicValue) {
        Type type = basicValue.getType();
        return type != null && (type.getSort() == 9 || type.equals(NULL_TYPE));
    }

    @Override
    protected BasicValue getElementValue(BasicValue basicValue) throws AnalyzerException {
        Type type = basicValue.getType();
        if (type != null) {
            if (type.getSort() == 9) {
                return this.newValue(Type.getType(type.getDescriptor().substring(1)));
            }
            if (type.equals(NULL_TYPE)) {
                return basicValue;
            }
        }
        throw new AssertionError();
    }

    @Override
    protected boolean isSubTypeOf(BasicValue basicValue, BasicValue basicValue2) {
        Type type = basicValue2.getType();
        Type type2 = basicValue.getType();
        switch (type.getSort()) {
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return type2.equals(type);
            }
            case 9: 
            case 10: {
                if (type2.equals(NULL_TYPE)) {
                    return true;
                }
                if (type2.getSort() == 10 || type2.getSort() == 9) {
                    return this.isAssignableFrom(type, type2);
                }
                return false;
            }
        }
        throw new AssertionError();
    }

    @Override
    public BasicValue merge(BasicValue basicValue, BasicValue basicValue2) {
        if (!basicValue.equals(basicValue2)) {
            Type type = basicValue.getType();
            Type type2 = basicValue2.getType();
            if (!(type == null || type.getSort() != 10 && type.getSort() != 9 || type2 == null || type2.getSort() != 10 && type2.getSort() != 9)) {
                if (type.equals(NULL_TYPE)) {
                    return basicValue2;
                }
                if (type2.equals(NULL_TYPE)) {
                    return basicValue;
                }
                if (this.isAssignableFrom(type, type2)) {
                    return basicValue;
                }
                if (this.isAssignableFrom(type2, type)) {
                    return basicValue2;
                }
                int n = 0;
                if (type.getSort() == 9 && type2.getSort() == 9 && type.getDimensions() == type2.getDimensions() && type.getElementType().getSort() == 10 && type2.getElementType().getSort() == 10) {
                    n = type.getDimensions();
                    type = type.getElementType();
                    type2 = type2.getElementType();
                }
                do {
                    if (type != null && !this.isInterface(type)) continue;
                    return this.newValue(Type.getObjectType("java/lang/Object"), n);
                } while (!this.isAssignableFrom(type = this.getSuperClass(type), type2));
                return this.newValue(type, n);
            }
            return BasicValue.UNINITIALIZED_VALUE;
        }
        return basicValue;
    }

    private BasicValue newValue(Type type, int n) {
        if (n == 0) {
            return this.newValue(type);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append('[');
        }
        stringBuilder.append(type.getDescriptor());
        return this.newValue(Type.getType(stringBuilder.toString()));
    }

    protected boolean isInterface(Type type) {
        if (this.currentClass != null && type.equals(this.currentClass)) {
            return this.isInterface;
        }
        return this.getClass(type).isInterface();
    }

    protected Type getSuperClass(Type type) {
        if (this.currentClass != null && type.equals(this.currentClass)) {
            return this.currentSuperClass;
        }
        Class<?> clazz = this.getClass(type).getSuperclass();
        return clazz == null ? null : Type.getType(clazz);
    }

    protected boolean isAssignableFrom(Type type, Type type2) {
        if (type.equals(type2)) {
            return true;
        }
        if (this.currentClass != null && type.equals(this.currentClass)) {
            if (this.getSuperClass(type2) == null) {
                return false;
            }
            if (this.isInterface) {
                return type2.getSort() == 10 || type2.getSort() == 9;
            }
            return this.isAssignableFrom(type, this.getSuperClass(type2));
        }
        if (this.currentClass != null && type2.equals(this.currentClass)) {
            if (this.isAssignableFrom(type, this.currentSuperClass)) {
                return true;
            }
            if (this.currentClassInterfaces != null) {
                for (int i = 0; i < this.currentClassInterfaces.size(); ++i) {
                    Type type3 = this.currentClassInterfaces.get(i);
                    if (!this.isAssignableFrom(type, type3)) continue;
                    return true;
                }
            }
            return false;
        }
        Class<Object> clazz = this.getClass(type);
        if (clazz.isInterface()) {
            clazz = Object.class;
        }
        return clazz.isAssignableFrom(this.getClass(type2));
    }

    protected Class<?> getClass(Type type) {
        try {
            if (type.getSort() == 9) {
                return Class.forName(type.getDescriptor().replace('/', '.'), false, this.loader);
            }
            return Class.forName(type.getClassName(), false, this.loader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TypeNotPresentException(classNotFoundException.toString(), classNotFoundException);
        }
    }
}

