/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiEventAttribute;
import com.cloudera.api.swagger.model.ApiEventCategory;
import com.cloudera.api.swagger.model.ApiEventSeverity;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Events model noteworthy incidents in Cloudera Manager or the managed Hadoop cluster. An event carries its event category, severity, and a string content. They also have generic attributes, which are free-form key value pairs. Important events may be promoted into alerts.")
public class ApiEvent {
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="content")
    private String content = null;
    @SerializedName(value="timeOccurred")
    private String timeOccurred = null;
    @SerializedName(value="timeReceived")
    private String timeReceived = null;
    @SerializedName(value="category")
    private ApiEventCategory category = null;
    @SerializedName(value="severity")
    private ApiEventSeverity severity = null;
    @SerializedName(value="alert")
    private Boolean alert = null;
    @SerializedName(value="attributes")
    private List<ApiEventAttribute> attributes = null;

    public ApiEvent id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="A unique ID for this event.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ApiEvent content(String content) {
        this.content = content;
        return this;
    }

    @ApiModelProperty(value="The content payload of this event.")
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public ApiEvent timeOccurred(String timeOccurred) {
        this.timeOccurred = timeOccurred;
        return this;
    }

    @ApiModelProperty(value="When the event was generated.")
    public String getTimeOccurred() {
        return this.timeOccurred;
    }

    public void setTimeOccurred(String timeOccurred) {
        this.timeOccurred = timeOccurred;
    }

    public ApiEvent timeReceived(String timeReceived) {
        this.timeReceived = timeReceived;
        return this;
    }

    @ApiModelProperty(value="When the event was stored by Cloudera Manager. Events do not arrive in the order that they are generated. If you are writing an event poller, this is a useful field to query.")
    public String getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(String timeReceived) {
        this.timeReceived = timeReceived;
    }

    public ApiEvent category(ApiEventCategory category) {
        this.category = category;
        return this;
    }

    @ApiModelProperty(value="The category of this event -- whether it is a health event, an audit event, an activity event, etc.")
    public ApiEventCategory getCategory() {
        return this.category;
    }

    public void setCategory(ApiEventCategory category) {
        this.category = category;
    }

    public ApiEvent severity(ApiEventSeverity severity) {
        this.severity = severity;
        return this;
    }

    @ApiModelProperty(value="The severity of the event.")
    public ApiEventSeverity getSeverity() {
        return this.severity;
    }

    public void setSeverity(ApiEventSeverity severity) {
        this.severity = severity;
    }

    public ApiEvent alert(Boolean alert) {
        this.alert = alert;
        return this;
    }

    @ApiModelProperty(value="Whether the event is promoted to an alert according to configuration.")
    public Boolean getAlert() {
        return this.alert;
    }

    public void setAlert(Boolean alert) {
        this.alert = alert;
    }

    public ApiEvent attributes(List<ApiEventAttribute> attributes) {
        this.attributes = attributes;
        return this;
    }

    public ApiEvent addAttributesItem(ApiEventAttribute attributesItem) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<ApiEventAttribute>();
        }
        this.attributes.add(attributesItem);
        return this;
    }

    @ApiModelProperty(value="A list of key-value attribute pairs.")
    public List<ApiEventAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<ApiEventAttribute> attributes) {
        this.attributes = attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiEvent apiEvent = (ApiEvent)o;
        return Objects.equals(this.id, apiEvent.id) && Objects.equals(this.content, apiEvent.content) && Objects.equals(this.timeOccurred, apiEvent.timeOccurred) && Objects.equals(this.timeReceived, apiEvent.timeReceived) && Objects.equals((Object)this.category, (Object)apiEvent.category) && Objects.equals((Object)this.severity, (Object)apiEvent.severity) && Objects.equals(this.alert, apiEvent.alert) && Objects.equals(this.attributes, apiEvent.attributes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.content, this.timeOccurred, this.timeReceived, this.category, this.severity, this.alert, this.attributes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiEvent {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    timeOccurred: ").append(this.toIndentedString(this.timeOccurred)).append("\n");
        sb.append("    timeReceived: ").append(this.toIndentedString(this.timeReceived)).append("\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    severity: ").append(this.toIndentedString((Object)this.severity)).append("\n");
        sb.append("    alert: ").append(this.toIndentedString(this.alert)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

