/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { AnimationTriggerMetadata } from '@angular/animations';
/**
 * Animations used by the mat-menu component.
 * Animation duration and timing values are based on:
 * https://material.io/guidelines/components/menus.html#menus-usage
 */
export declare const matMenuAnimations: {
    readonly transformMenu: AnimationTriggerMetadata;
    readonly fadeInItems: AnimationTriggerMetadata;
};
/**
 * @deprecated
 * @deletion-target 7.0.0
 */
export declare const fadeInItems: AnimationTriggerMetadata;
/**
 * @deprecated
 * @deletion-target 7.0.0
 */
export declare const transformMenu: AnimationTriggerMetadata;
