/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Date;
import java.util.UUID;
import org.pac4j.core.exception.TechnicalException;

public final class CommonHelper {
    private static final String EMPTY = "";
    private static final int INDEX_NOT_FOUND = -1;

    public static boolean isNotBlank(String s) {
        if (s == null) {
            return false;
        }
        return s.trim().length() > 0;
    }

    public static boolean isBlank(String s) {
        return !CommonHelper.isNotBlank(s);
    }

    public static boolean areEquals(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    public static boolean areEqualsIgnoreCaseAndTrim(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 != null && s2 != null) {
            return s1.trim().equalsIgnoreCase(s2.trim());
        }
        return false;
    }

    public static boolean areNotEquals(String s1, String s2) {
        return !CommonHelper.areEquals(s1, s2);
    }

    public static boolean isEmpty(Collection<?> coll) {
        return coll == null || coll.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> coll) {
        return !CommonHelper.isEmpty(coll);
    }

    public static void assertTrue(boolean value, String message) {
        if (!value) {
            throw new TechnicalException(message);
        }
    }

    public static void assertNotBlank(String name, String value, String msg) {
        CommonHelper.assertTrue(!CommonHelper.isBlank(value), name + " cannot be blank" + (msg != null ? ": " + msg : EMPTY));
    }

    public static void assertNotBlank(String name, String value) {
        CommonHelper.assertNotBlank(name, value, null);
    }

    public static void assertNotNull(String name, Object obj) {
        CommonHelper.assertTrue(obj != null, name + " cannot be null");
    }

    public static void assertNull(String name, Object obj) {
        CommonHelper.assertTrue(obj == null, name + " must be null");
    }

    public static String addParameter(String url, String name, String value) {
        if (url != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(url);
            if (name != null) {
                if (url.indexOf("?") >= 0) {
                    sb.append("&");
                } else {
                    sb.append("?");
                }
                sb.append(name);
                sb.append("=");
                if (value != null) {
                    sb.append(CommonHelper.urlEncode(value));
                }
            }
            return sb.toString();
        }
        return null;
    }

    public static String urlEncode(String text) {
        try {
            return URLEncoder.encode(text, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            String message = "Unable to encode text : " + text;
            throw new TechnicalException(message, e);
        }
    }

    public static String toNiceString(Class<?> clazz, Object ... args) {
        StringBuilder sb = new StringBuilder();
        sb.append("#");
        sb.append(clazz.getSimpleName());
        sb.append("# |");
        boolean b = true;
        for (Object arg : args) {
            if (b) {
                sb.append(" ");
                sb.append(arg);
                sb.append(":");
            } else {
                sb.append(" ");
                sb.append(arg);
                sb.append(" |");
            }
            b = !b;
        }
        return sb.toString();
    }

    public static String randomString(int size) {
        StringBuffer sb = new StringBuffer(EMPTY);
        while (sb.length() < size) {
            sb.append(UUID.randomUUID().toString().replace("-", EMPTY));
        }
        return sb.toString().substring(0, size);
    }

    public static Date newDate(Date original) {
        return original != null ? new Date(original.getTime()) : null;
    }

    public static URI asURI(String s) {
        try {
            return new URI(s);
        }
        catch (URISyntaxException e) {
            throw new TechnicalException("Cannot make an URI from: " + s, e);
        }
    }

    public static String substringBetween(String str, String open, String close) {
        int end;
        if (str == null || open == null || close == null) {
            return null;
        }
        int start = str.indexOf(open);
        if (start != -1 && (end = str.indexOf(close, start + open.length())) != -1) {
            return str.substring(start + open.length(), end);
        }
        return null;
    }

    public static String substringAfter(String str, String separator) {
        if (CommonHelper.isEmpty(str)) {
            return str;
        }
        if (separator == null) {
            return EMPTY;
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return EMPTY;
        }
        return str.substring(pos + separator.length());
    }

    public static String substringBefore(String str, String separator) {
        if (CommonHelper.isEmpty(str) || separator == null) {
            return str;
        }
        if (separator.length() == 0) {
            return EMPTY;
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    private static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }
}

