/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.interceptor.context;

import javax.naming.directory.SearchControls;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.message.MessageTypeEnum;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.StringConstants;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.OperationEnum;
import org.apache.directory.server.core.api.interceptor.context.FilteringOperationContext;

public class SearchOperationContext
extends FilteringOperationContext {
    private AliasDerefMode aliasDerefMode = AliasDerefMode.DEREF_ALWAYS;
    private long sizeLimit = 0L;
    private int timeLimit = 0;
    private SearchScope scope = SearchScope.ONELEVEL;
    protected boolean abandoned = false;
    private ExprNode filter;
    private boolean syncreplSearch;

    public SearchOperationContext(CoreSession session) {
        super(session);
        if (session != null) {
            this.setInterceptors(session.getDirectoryService().getInterceptors(OperationEnum.SEARCH));
        }
    }

    public SearchOperationContext(CoreSession session, SearchRequest searchRequest) {
        super(session, searchRequest.getBase(), searchRequest.getAttributes().toArray(StringConstants.EMPTY_STRINGS));
        if (session != null) {
            this.setInterceptors(session.getDirectoryService().getInterceptors(OperationEnum.SEARCH));
        }
        this.filter = searchRequest.getFilter();
        this.abandoned = searchRequest.isAbandoned();
        this.aliasDerefMode = searchRequest.getDerefAliases();
        this.requestControls = searchRequest.getControls();
        this.scope = searchRequest.getScope();
        this.sizeLimit = searchRequest.getSizeLimit();
        this.timeLimit = searchRequest.getTimeLimit();
        this.typesOnly = searchRequest.getTypesOnly();
        this.throwReferral = !this.requestControls.containsKey("2.16.840.1.113730.3.4.2");
    }

    public SearchOperationContext(CoreSession session, Dn dn, ExprNode filter, SearchControls searchControls) {
        super(session, dn, searchControls.getReturningAttributes());
        this.filter = filter;
        this.scope = SearchScope.getSearchScope((int)searchControls.getSearchScope());
        this.timeLimit = searchControls.getTimeLimit();
        this.sizeLimit = searchControls.getCountLimit();
        this.typesOnly = searchControls.getReturningObjFlag();
        if (session != null) {
            this.setInterceptors(session.getDirectoryService().getInterceptors(OperationEnum.SEARCH));
        }
    }

    public SearchOperationContext(CoreSession session, Dn dn, SearchScope scope, ExprNode filter, String ... returningAttributes) {
        super(session, dn, returningAttributes);
        this.scope = scope;
        this.filter = filter;
        if (session != null) {
            this.setInterceptors(session.getDirectoryService().getInterceptors(OperationEnum.SEARCH));
        }
    }

    public boolean hasManageDsaItControl() {
        return super.hasRequestControl("2.16.840.1.113730.3.4.2");
    }

    public ExprNode getFilter() {
        return this.filter;
    }

    public void setFilter(ExprNode filter) {
        this.filter = filter;
    }

    @Override
    public String getName() {
        return MessageTypeEnum.SEARCH_REQUEST.name();
    }

    public boolean isSyncreplSearch() {
        return this.syncreplSearch;
    }

    public void setSyncreplSearch(boolean syncreplSearch) {
        this.syncreplSearch = syncreplSearch;
    }

    public AliasDerefMode getAliasDerefMode() {
        return this.aliasDerefMode;
    }

    public void setAliasDerefMode(AliasDerefMode aliasDerefMode) {
        this.aliasDerefMode = aliasDerefMode;
    }

    public long getSizeLimit() {
        return this.sizeLimit;
    }

    public void setSizeLimit(long sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimit(int timeLimit) {
        this.timeLimit = timeLimit;
    }

    public SearchScope getScope() {
        return this.scope;
    }

    public void setScope(SearchScope scope) {
        this.scope = scope;
    }

    public boolean isAbandoned() {
        return this.abandoned;
    }

    public void setAbandoned(boolean abandoned) {
        this.abandoned = abandoned;
    }

    @Override
    public String toString() {
        return "SearchContext for Dn '" + this.getDn().getName() + "', filter :'" + this.filter + "'";
    }
}

