/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.crypto;

import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.GCMParameterSpec;
import org.apache.shiro.crypto.DefaultBlockCipherService;
import org.apache.shiro.crypto.OperationMode;
import org.apache.shiro.crypto.PaddingScheme;

public class AesCipherService
extends DefaultBlockCipherService {
    private static final String ALGORITHM_NAME = "AES";

    public AesCipherService() {
        super(ALGORITHM_NAME);
        this.setMode(OperationMode.GCM);
        this.setStreamingMode(OperationMode.GCM);
        this.setPaddingScheme(PaddingScheme.NONE);
    }

    @Override
    protected AlgorithmParameterSpec createParameterSpec(byte[] iv, boolean streaming) {
        if (streaming && OperationMode.GCM.name().equals(this.getStreamingModeName()) || !streaming && OperationMode.GCM.name().equals(this.getModeName())) {
            return new GCMParameterSpec(this.getKeySize(), iv);
        }
        return super.createParameterSpec(iv, streaming);
    }
}

