/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.service.metadata;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.dto.HomePageProfile;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.service.definition.Metadata;
import org.apache.knox.gateway.service.definition.ServiceDefinitionPair;
import org.apache.knox.gateway.service.metadata.GeneralProxyInformation;
import org.apache.knox.gateway.service.metadata.MetadataServiceMessages;
import org.apache.knox.gateway.service.metadata.ServiceModel;
import org.apache.knox.gateway.service.metadata.TopologyInformationWrapper;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.ServerInfoService;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.registry.ServiceDefinitionRegistry;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.AliasServiceException;
import org.apache.knox.gateway.services.security.KeystoreService;
import org.apache.knox.gateway.services.security.KeystoreServiceException;
import org.apache.knox.gateway.services.topology.TopologyService;
import org.apache.knox.gateway.topology.Service;
import org.apache.knox.gateway.topology.Topology;
import org.apache.knox.gateway.util.JsonUtils;
import org.apache.knox.gateway.util.X509CertificateUtil;

@Api(value="metadata", description="RESTful API to interact with metadata.")
@Singleton
@Path(value="/api/v1/metadata")
public class KnoxMetadataResource {
    private static final MetadataServiceMessages LOG = (MetadataServiceMessages)MessagesFactory.get(MetadataServiceMessages.class);
    private static final String SNAPSHOT_VERSION_POSTFIX = "-SNAPSHOT";
    private static final Set<String> UNREAL_SERVICES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("NAMENODE", "JOBTRACKER", "RESOURCEMANAGERAPI")));
    private Set<String> pinnedTopologies;
    private java.nio.file.Path pemFilePath;
    private java.nio.file.Path jksFilePath;
    @Context
    private HttpServletRequest request;

    @ApiOperation(value="Get general proxy information", notes="Get general proxy information such as TLS Public Certificate, Knox Admin UI Url, etc...", response=GeneralProxyInformation.class)
    @GET
    @Produces(value={"application/json", "application/xml"})
    @Path(value="info")
    public GeneralProxyInformation getGeneralProxyInformation() {
        GeneralProxyInformation proxyInfo = new GeneralProxyInformation();
        GatewayServices gatewayServices = (GatewayServices)this.request.getServletContext().getAttribute("org.apache.knox.gateway.gateway.services");
        if (gatewayServices != null) {
            ServerInfoService serviceInfoService = (ServerInfoService)gatewayServices.getService(ServiceType.SERVER_INFO_SERVICE);
            String versionInfo = serviceInfoService.getBuildVersion() + " (hash=" + serviceInfoService.getBuildHash() + ")";
            proxyInfo.setVersion(versionInfo);
            proxyInfo.setAdminApiBookUrl(String.format(Locale.ROOT, "https://knox.apache.org/books/knox-%s/user-guide.html#Admin+API", this.getAdminApiBookVersion(serviceInfoService.getBuildVersion())));
            GatewayConfig config = (GatewayConfig)this.request.getServletContext().getAttribute("org.apache.knox.gateway.config");
            proxyInfo.setAdminUiUrl(this.getBaseGatewayUrl(config) + "/manager/admin-ui/");
            proxyInfo.setWebShellUrl(this.getBaseGatewayUrl(config) + "/homepage/webshell-ui/index.html");
            this.setTokenManagementEnabledFlag(proxyInfo, gatewayServices);
            proxyInfo.setEnableWebshell(String.valueOf(config.isWebShellEnabled()));
        }
        return proxyInfo;
    }

    private void setTokenManagementEnabledFlag(GeneralProxyInformation proxyInfo, GatewayServices gatewayServices) {
        try {
            AliasService aliasService = (AliasService)gatewayServices.getService(ServiceType.ALIAS_SERVICE);
            List aliases = aliasService.getAliasesForCluster("__gateway");
            boolean tokenManagementEnabled = aliases.contains("knox.token.hash.key");
            proxyInfo.setEnableTokenManagement(Boolean.toString(tokenManagementEnabled));
            if (!tokenManagementEnabled) {
                LOG.tokenManagementDisabled();
            }
        }
        catch (AliasServiceException e) {
            LOG.failedToFetchGatewayAliasList(e.getMessage(), (Exception)((Object)e));
        }
    }

    private String getAdminApiBookVersion(String buildVersion) {
        return buildVersion.replaceAll(SNAPSHOT_VERSION_POSTFIX, "").replaceAll("\\.", "-");
    }

    @GET
    @Produces(value={"application/octet-stream"})
    @Path(value="publicCert")
    public Response getPublicCertification(@QueryParam(value="type") @DefaultValue(value="pem") String certType) {
        GatewayConfig config;
        Certificate certificate;
        GatewayServices gatewayServices = (GatewayServices)this.request.getServletContext().getAttribute("org.apache.knox.gateway.gateway.services");
        if (gatewayServices != null && (certificate = this.getPublicCertificate(gatewayServices, config = (GatewayConfig)this.request.getServletContext().getAttribute("org.apache.knox.gateway.config"))) != null) {
            if ("pem".equals(certType)) {
                this.generateCertificatePem(certificate, config);
                return this.generateSuccessFileDownloadResponse(this.pemFilePath);
            }
            if ("jks".equals(certType)) {
                this.generateCertificateJks(certificate, config);
                return this.generateSuccessFileDownloadResponse(this.jksFilePath);
            }
            return this.generateFailureFileDownloadResponse(Response.Status.BAD_REQUEST, "Invalid certification type provided!");
        }
        return this.generateFailureFileDownloadResponse(Response.Status.SERVICE_UNAVAILABLE, "Could not generate public certificate");
    }

    private Response generateSuccessFileDownloadResponse(java.nio.file.Path publicCertFilePath) {
        Response.ResponseBuilder responseBuilder = Response.ok((Object)publicCertFilePath.toFile());
        responseBuilder.header("Content-Disposition", (Object)("attachment;filename=" + publicCertFilePath.getFileName().toString()));
        return responseBuilder.build();
    }

    private Response generateFailureFileDownloadResponse(Response.Status status, String errorMessage) {
        Response.ResponseBuilder responseBuilder = Response.status((Response.Status)status);
        responseBuilder.entity((Object)errorMessage);
        return responseBuilder.build();
    }

    private Certificate getPublicCertificate(GatewayServices gatewayServices, GatewayConfig config) {
        try {
            KeystoreService keystoreService = (KeystoreService)gatewayServices.getService(ServiceType.KEYSTORE_SERVICE);
            return keystoreService.getKeystoreForGateway().getCertificate(config.getIdentityKeyAlias());
        }
        catch (KeyStoreException | KeystoreServiceException e) {
            LOG.failedToFetchPublicCert(e.getMessage(), (Exception)e);
            return null;
        }
    }

    private void generateCertificatePem(Certificate certificate, GatewayConfig gatewayConfig) {
        try {
            if (this.pemFilePath == null || !this.pemFilePath.toFile().exists()) {
                this.pemFilePath = Paths.get(gatewayConfig.getGatewaySecurityDir(), "gateway-client-trust.pem");
                X509CertificateUtil.writeCertificateToFile((Certificate)certificate, (File)this.pemFilePath.toFile());
            }
        }
        catch (IOException | CertificateEncodingException e) {
            LOG.failedToGeneratePublicCert("PEM", e.getMessage(), e);
        }
    }

    private void generateCertificateJks(Certificate certificate, GatewayConfig gatewayConfig) {
        try {
            if (this.jksFilePath == null || !this.jksFilePath.toFile().exists()) {
                this.jksFilePath = Paths.get(gatewayConfig.getGatewaySecurityDir(), "gateway-client-trust.jks");
                X509CertificateUtil.writeCertificateToJks((Certificate)certificate, (File)this.jksFilePath.toFile());
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            LOG.failedToGeneratePublicCert("JKS", e.getMessage(), e);
        }
    }

    private String getBaseGatewayUrl(GatewayConfig config) {
        return this.request.getRequestURL().substring(0, this.request.getRequestURL().length() - this.request.getRequestURI().length()) + "/" + config.getGatewayPath();
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="topologies")
    public TopologyInformationWrapper getTopologies() {
        return this.getTopologies(null);
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="topologies/{name}")
    public TopologyInformationWrapper getTopology(@PathParam(value="name") String topologyName) {
        return this.getTopologies(topologyName);
    }

    private TopologyInformationWrapper getTopologies(String topologyName) {
        TopologyInformationWrapper topologies = new TopologyInformationWrapper();
        GatewayServices gatewayServices = (GatewayServices)this.request.getServletContext().getAttribute("org.apache.knox.gateway.gateway.services");
        GatewayConfig config = (GatewayConfig)this.request.getServletContext().getAttribute("org.apache.knox.gateway.config");
        ServiceDefinitionRegistry serviceDefinitionRegistry = (ServiceDefinitionRegistry)gatewayServices.getService(ServiceType.SERVICE_DEFINITION_REGISTRY);
        Set hiddenTopologies = config.getHiddenTopologiesOnHomepage();
        if (gatewayServices != null) {
            TopologyService topologyService = (TopologyService)gatewayServices.getService(ServiceType.TOPOLOGY_SERVICE);
            for (Topology topology : topologyService.getTopologies()) {
                if (hiddenTopologies.contains(topology.getName()) || topologyName != null && !topology.getName().equalsIgnoreCase(topologyName)) continue;
                HashSet apiServices = new HashSet();
                HashSet uiServices = new HashSet();
                topology.getServices().stream().filter(service -> !UNREAL_SERVICES.contains(service.getRole())).forEach(service -> service.getUrls().forEach(serviceUrl -> {
                    ServiceModel serviceModel = this.getServiceModel(this.request, config.getGatewayPath(), topology.getName(), (Service)service, this.getServiceMetadata(serviceDefinitionRegistry, (Service)service), (String)serviceUrl);
                    if (ServiceModel.Type.UI == serviceModel.getType()) {
                        uiServices.add(serviceModel);
                    } else if (ServiceModel.Type.API_AND_UI == serviceModel.getType()) {
                        uiServices.add(serviceModel);
                        apiServices.add(serviceModel);
                    } else {
                        apiServices.add(serviceModel);
                    }
                }));
                topologies.addTopology(topology.getName(), this.isPinnedTopology(topology.getName(), config), new TreeSet<ServiceModel>(apiServices), new TreeSet<ServiceModel>(uiServices));
            }
        }
        return topologies;
    }

    boolean isPinnedTopology(String topologyName, GatewayConfig config) {
        if (this.pinnedTopologies == null) {
            this.pinnedTopologies = config.getPinnedTopologiesOnHomepage();
        }
        return this.pinnedTopologies.contains(topologyName);
    }

    private Metadata getServiceMetadata(ServiceDefinitionRegistry serviceDefinitionRegistry, Service service) {
        Optional<ServiceDefinitionPair> serviceDefinition = serviceDefinitionRegistry.getServiceDefinitions().stream().filter(serviceDefinitionPair -> serviceDefinitionPair.getService().getRole().equalsIgnoreCase(service.getRole())).filter(serviceDefinitionPair -> service.getVersion() == null || service.getVersion().toString().equalsIgnoreCase(serviceDefinitionPair.getService().getVersion())).findFirst();
        return serviceDefinition.isPresent() ? serviceDefinition.get().getService().getMetadata() : null;
    }

    private ServiceModel getServiceModel(HttpServletRequest request, String gatewayPath, String topologyName, Service service, Metadata serviceMetadata, String serviceUrl) {
        ServiceModel serviceModel = new ServiceModel();
        serviceModel.setRequest(request);
        serviceModel.setGatewayPath(gatewayPath);
        serviceModel.setTopologyName(topologyName);
        serviceModel.setService(service);
        serviceModel.setServiceMetadata(serviceMetadata);
        serviceModel.setServiceUrl(serviceUrl);
        return serviceModel;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="profiles/{profile}")
    public String getProfile(@PathParam(value="profile") String profileName) {
        GatewayConfig config = (GatewayConfig)this.request.getServletContext().getAttribute("org.apache.knox.gateway.config");
        Map configuredProfiles = config.getHomePageProfiles();
        if (configuredProfiles.containsKey(profileName.toLowerCase(Locale.getDefault()))) {
            HomePageProfile profile = new HomePageProfile((Collection)configuredProfiles.get(profileName));
            return JsonUtils.renderAsJsonString((Object)profile.getProfileElements());
        }
        return JsonUtils.renderAsJsonString(Collections.emptyMap());
    }
}

